/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.directconnect.model.RouteFilterPrefix;
import com.amazonaws.services.directconnect.model.VirtualInterface;
import com.amazonaws.services.directconnect.model.transform.RouteFilterPrefixJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class VirtualInterfaceJsonMarshaller {
    private static VirtualInterfaceJsonMarshaller instance;

    public void marshall(VirtualInterface virtualInterface, JSONWriter jsonWriter) {
        if (virtualInterface == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList routeFilterPrefixesList;
            jsonWriter.object();
            if (virtualInterface.getOwnerAccount() != null) {
                jsonWriter.key("ownerAccount").value(virtualInterface.getOwnerAccount());
            }
            if (virtualInterface.getVirtualInterfaceId() != null) {
                jsonWriter.key("virtualInterfaceId").value(virtualInterface.getVirtualInterfaceId());
            }
            if (virtualInterface.getLocation() != null) {
                jsonWriter.key("location").value(virtualInterface.getLocation());
            }
            if (virtualInterface.getConnectionId() != null) {
                jsonWriter.key("connectionId").value(virtualInterface.getConnectionId());
            }
            if (virtualInterface.getVirtualInterfaceType() != null) {
                jsonWriter.key("virtualInterfaceType").value(virtualInterface.getVirtualInterfaceType());
            }
            if (virtualInterface.getVirtualInterfaceName() != null) {
                jsonWriter.key("virtualInterfaceName").value(virtualInterface.getVirtualInterfaceName());
            }
            if (virtualInterface.getVlan() != null) {
                jsonWriter.key("vlan").value(virtualInterface.getVlan());
            }
            if (virtualInterface.getAsn() != null) {
                jsonWriter.key("asn").value(virtualInterface.getAsn());
            }
            if (virtualInterface.getAuthKey() != null) {
                jsonWriter.key("authKey").value(virtualInterface.getAuthKey());
            }
            if (virtualInterface.getAmazonAddress() != null) {
                jsonWriter.key("amazonAddress").value(virtualInterface.getAmazonAddress());
            }
            if (virtualInterface.getCustomerAddress() != null) {
                jsonWriter.key("customerAddress").value(virtualInterface.getCustomerAddress());
            }
            if (virtualInterface.getVirtualInterfaceState() != null) {
                jsonWriter.key("virtualInterfaceState").value(virtualInterface.getVirtualInterfaceState());
            }
            if (virtualInterface.getCustomerRouterConfig() != null) {
                jsonWriter.key("customerRouterConfig").value(virtualInterface.getCustomerRouterConfig());
            }
            if (virtualInterface.getVirtualGatewayId() != null) {
                jsonWriter.key("virtualGatewayId").value(virtualInterface.getVirtualGatewayId());
            }
            if (!(routeFilterPrefixesList = (SdkInternalList)virtualInterface.getRouteFilterPrefixes()).isEmpty() || !routeFilterPrefixesList.isAutoConstruct()) {
                jsonWriter.key("routeFilterPrefixes");
                jsonWriter.array();
                for (RouteFilterPrefix routeFilterPrefixesListValue : routeFilterPrefixesList) {
                    if (routeFilterPrefixesListValue == null) continue;
                    RouteFilterPrefixJsonMarshaller.getInstance().marshall(routeFilterPrefixesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static VirtualInterfaceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new VirtualInterfaceJsonMarshaller();
        }
        return instance;
    }
}

