/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchdomain.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.cloudsearchdomain.model.Bucket;
import com.amazonaws.util.json.JSONWriter;

public class BucketJsonMarshaller {
    private static BucketJsonMarshaller instance;

    public void marshall(Bucket bucket, JSONWriter jsonWriter) {
        if (bucket == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (bucket.getValue() != null) {
                jsonWriter.key("value").value(bucket.getValue());
            }
            if (bucket.getCount() != null) {
                jsonWriter.key("count").value(bucket.getCount());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static BucketJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new BucketJsonMarshaller();
        }
        return instance;
    }
}

