/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.ViewerCertificate;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ViewerCertificateStaxUnmarshaller
implements Unmarshaller<ViewerCertificate, StaxUnmarshallerContext> {
    private static ViewerCertificateStaxUnmarshaller instance;

    @Override
    public ViewerCertificate unmarshall(StaxUnmarshallerContext context) throws Exception {
        ViewerCertificate viewerCertificate = new ViewerCertificate();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return viewerCertificate;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Certificate", targetDepth)) {
                    viewerCertificate.setCertificate(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CertificateSource", targetDepth)) {
                    viewerCertificate.setCertificateSource(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SSLSupportMethod", targetDepth)) {
                    viewerCertificate.setSSLSupportMethod(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MinimumProtocolVersion", targetDepth)) {
                    viewerCertificate.setMinimumProtocolVersion(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IAMCertificateId", targetDepth)) {
                    viewerCertificate.setIAMCertificateId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CloudFrontDefaultCertificate", targetDepth)) continue;
                viewerCertificate.setCloudFrontDefaultCertificate(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return viewerCertificate;
    }

    public static ViewerCertificateStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ViewerCertificateStaxUnmarshaller();
        }
        return instance;
    }
}

