/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.route53.model.ChangeTagsForResourceRequest;
import com.amazonaws.services.route53.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;

public class ChangeTagsForResourceRequestMarshaller
implements Marshaller<Request<ChangeTagsForResourceRequest>, ChangeTagsForResourceRequest> {
    @Override
    public Request<ChangeTagsForResourceRequest> marshall(ChangeTagsForResourceRequest changeTagsForResourceRequest) {
        if (changeTagsForResourceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ChangeTagsForResourceRequest> request = new DefaultRequest<ChangeTagsForResourceRequest>(changeTagsForResourceRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2013-04-01/tags/{ResourceType}/{ResourceId}";
        uriResourcePath = uriResourcePath.replace("{ResourceType}", changeTagsForResourceRequest.getResourceType() == null ? "" : StringUtils.fromString(changeTagsForResourceRequest.getResourceType()));
        uriResourcePath = uriResourcePath.replace("{ResourceId}", changeTagsForResourceRequest.getResourceId() == null ? "" : StringUtils.fromString(changeTagsForResourceRequest.getResourceId()));
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter(stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");
            xmlWriter.startElement("ChangeTagsForResourceRequest");
            if (changeTagsForResourceRequest != null) {
                SdkInternalList changeTagsForResourceRequestRemoveTagKeysList;
                SdkInternalList changeTagsForResourceRequestAddTagsList = (SdkInternalList)changeTagsForResourceRequest.getAddTags();
                if (!changeTagsForResourceRequestAddTagsList.isEmpty() || !changeTagsForResourceRequestAddTagsList.isAutoConstruct()) {
                    xmlWriter.startElement("AddTags");
                    for (Tag changeTagsForResourceRequestAddTagsListValue : changeTagsForResourceRequestAddTagsList) {
                        xmlWriter.startElement("Tag");
                        if (changeTagsForResourceRequestAddTagsListValue.getKey() != null) {
                            xmlWriter.startElement("Key").value(changeTagsForResourceRequestAddTagsListValue.getKey()).endElement();
                        }
                        if (changeTagsForResourceRequestAddTagsListValue.getValue() != null) {
                            xmlWriter.startElement("Value").value(changeTagsForResourceRequestAddTagsListValue.getValue()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (!(changeTagsForResourceRequestRemoveTagKeysList = (SdkInternalList)changeTagsForResourceRequest.getRemoveTagKeys()).isEmpty() || !changeTagsForResourceRequestRemoveTagKeysList.isAutoConstruct()) {
                    xmlWriter.startElement("RemoveTagKeys");
                    for (String changeTagsForResourceRequestRemoveTagKeysListValue : changeTagsForResourceRequestRemoveTagKeysList) {
                        xmlWriter.startElement("Key");
                        xmlWriter.value(changeTagsForResourceRequestRemoveTagKeysListValue);
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
            }
            xmlWriter.endElement();
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

