/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.opsworks.model.Source;
import com.amazonaws.util.json.JSONWriter;

public class SourceJsonMarshaller {
    private static SourceJsonMarshaller instance;

    public void marshall(Source source, JSONWriter jsonWriter) {
        if (source == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (source.getType() != null) {
                jsonWriter.key("Type").value(source.getType());
            }
            if (source.getUrl() != null) {
                jsonWriter.key("Url").value(source.getUrl());
            }
            if (source.getUsername() != null) {
                jsonWriter.key("Username").value(source.getUsername());
            }
            if (source.getPassword() != null) {
                jsonWriter.key("Password").value(source.getPassword());
            }
            if (source.getSshKey() != null) {
                jsonWriter.key("SshKey").value(source.getSshKey());
            }
            if (source.getRevision() != null) {
                jsonWriter.key("Revision").value(source.getRevision());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SourceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SourceJsonMarshaller();
        }
        return instance;
    }
}

