/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ecs.model.DeploymentConfiguration;
import com.amazonaws.util.json.JSONWriter;

public class DeploymentConfigurationJsonMarshaller {
    private static DeploymentConfigurationJsonMarshaller instance;

    public void marshall(DeploymentConfiguration deploymentConfiguration, JSONWriter jsonWriter) {
        if (deploymentConfiguration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (deploymentConfiguration.getMaximumPercent() != null) {
                jsonWriter.key("maximumPercent").value(deploymentConfiguration.getMaximumPercent());
            }
            if (deploymentConfiguration.getMinimumHealthyPercent() != null) {
                jsonWriter.key("minimumHealthyPercent").value(deploymentConfiguration.getMinimumHealthyPercent());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DeploymentConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DeploymentConfigurationJsonMarshaller();
        }
        return instance;
    }
}

