/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandlerV2;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import com.amazonaws.services.simplesystemsmanagement.model.AssociatedInstancesException;
import com.amazonaws.services.simplesystemsmanagement.model.AssociationAlreadyExistsException;
import com.amazonaws.services.simplesystemsmanagement.model.AssociationDoesNotExistException;
import com.amazonaws.services.simplesystemsmanagement.model.AssociationLimitExceededException;
import com.amazonaws.services.simplesystemsmanagement.model.CancelCommandRequest;
import com.amazonaws.services.simplesystemsmanagement.model.CancelCommandResult;
import com.amazonaws.services.simplesystemsmanagement.model.CreateAssociationBatchRequest;
import com.amazonaws.services.simplesystemsmanagement.model.CreateAssociationBatchResult;
import com.amazonaws.services.simplesystemsmanagement.model.CreateAssociationRequest;
import com.amazonaws.services.simplesystemsmanagement.model.CreateAssociationResult;
import com.amazonaws.services.simplesystemsmanagement.model.CreateDocumentRequest;
import com.amazonaws.services.simplesystemsmanagement.model.CreateDocumentResult;
import com.amazonaws.services.simplesystemsmanagement.model.DeleteAssociationRequest;
import com.amazonaws.services.simplesystemsmanagement.model.DeleteAssociationResult;
import com.amazonaws.services.simplesystemsmanagement.model.DeleteDocumentRequest;
import com.amazonaws.services.simplesystemsmanagement.model.DeleteDocumentResult;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeAssociationRequest;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeAssociationResult;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeDocumentRequest;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeDocumentResult;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeInstanceInformationRequest;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeInstanceInformationResult;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentAlreadyExistsException;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentLimitExceededException;
import com.amazonaws.services.simplesystemsmanagement.model.DuplicateInstanceIdException;
import com.amazonaws.services.simplesystemsmanagement.model.GetDocumentRequest;
import com.amazonaws.services.simplesystemsmanagement.model.GetDocumentResult;
import com.amazonaws.services.simplesystemsmanagement.model.InternalServerErrorException;
import com.amazonaws.services.simplesystemsmanagement.model.InvalidCommandIdException;
import com.amazonaws.services.simplesystemsmanagement.model.InvalidDocumentContentException;
import com.amazonaws.services.simplesystemsmanagement.model.InvalidDocumentException;
import com.amazonaws.services.simplesystemsmanagement.model.InvalidFilterKeyException;
import com.amazonaws.services.simplesystemsmanagement.model.InvalidInstanceIdException;
import com.amazonaws.services.simplesystemsmanagement.model.InvalidInstanceInformationFilterValueException;
import com.amazonaws.services.simplesystemsmanagement.model.InvalidNextTokenException;
import com.amazonaws.services.simplesystemsmanagement.model.InvalidOutputFolderException;
import com.amazonaws.services.simplesystemsmanagement.model.InvalidParametersException;
import com.amazonaws.services.simplesystemsmanagement.model.ListAssociationsRequest;
import com.amazonaws.services.simplesystemsmanagement.model.ListAssociationsResult;
import com.amazonaws.services.simplesystemsmanagement.model.ListCommandInvocationsRequest;
import com.amazonaws.services.simplesystemsmanagement.model.ListCommandInvocationsResult;
import com.amazonaws.services.simplesystemsmanagement.model.ListCommandsRequest;
import com.amazonaws.services.simplesystemsmanagement.model.ListCommandsResult;
import com.amazonaws.services.simplesystemsmanagement.model.ListDocumentsRequest;
import com.amazonaws.services.simplesystemsmanagement.model.ListDocumentsResult;
import com.amazonaws.services.simplesystemsmanagement.model.MaxDocumentSizeExceededException;
import com.amazonaws.services.simplesystemsmanagement.model.SendCommandRequest;
import com.amazonaws.services.simplesystemsmanagement.model.SendCommandResult;
import com.amazonaws.services.simplesystemsmanagement.model.StatusUnchangedException;
import com.amazonaws.services.simplesystemsmanagement.model.TooManyUpdatesException;
import com.amazonaws.services.simplesystemsmanagement.model.UnsupportedPlatformTypeException;
import com.amazonaws.services.simplesystemsmanagement.model.UpdateAssociationStatusRequest;
import com.amazonaws.services.simplesystemsmanagement.model.UpdateAssociationStatusResult;
import com.amazonaws.services.simplesystemsmanagement.model.transform.CancelCommandRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.CancelCommandResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.CreateAssociationBatchRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.CreateAssociationBatchResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.CreateAssociationRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.CreateAssociationResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.CreateDocumentRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.CreateDocumentResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DeleteAssociationRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DeleteAssociationResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DeleteDocumentRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DeleteDocumentResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DescribeAssociationRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DescribeAssociationResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DescribeDocumentRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DescribeDocumentResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DescribeInstanceInformationRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DescribeInstanceInformationResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.GetDocumentRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.GetDocumentResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.ListAssociationsRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.ListAssociationsResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.ListCommandInvocationsRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.ListCommandInvocationsResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.ListCommandsRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.ListCommandsResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.ListDocumentsRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.ListDocumentsResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.SendCommandRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.SendCommandResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.UpdateAssociationStatusRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.UpdateAssociationStatusResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshallerV2;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AWSSimpleSystemsManagementClient
extends AmazonWebServiceClient
implements AWSSimpleSystemsManagement {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSSimpleSystemsManagement.class);
    private static final String DEFAULT_SIGNING_NAME = "ssm";
    private static final String DEFAULT_ENDPOINT_PREFIX = "ssm";
    protected List<JsonErrorUnmarshallerV2> jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshallerV2>();

    public AWSSimpleSystemsManagementClient() {
        this(new DefaultAWSCredentialsProviderChain(), PredefinedClientConfigurations.defaultConfig());
    }

    public AWSSimpleSystemsManagementClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AWSSimpleSystemsManagementClient(AWSCredentials awsCredentials) {
        this(awsCredentials, PredefinedClientConfigurations.defaultConfig());
    }

    public AWSSimpleSystemsManagementClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSSimpleSystemsManagementClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, PredefinedClientConfigurations.defaultConfig());
    }

    public AWSSimpleSystemsManagementClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AWSSimpleSystemsManagementClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidInstanceInformationFilterValueException.class, "InvalidInstanceInformationFilterValue"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidNextTokenException.class, "InvalidNextToken"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(AssociatedInstancesException.class, "AssociatedInstances"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(AssociationLimitExceededException.class, "AssociationLimitExceeded"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(DuplicateInstanceIdException.class, "DuplicateInstanceId"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidFilterKeyException.class, "InvalidFilterKey"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidParametersException.class, "InvalidParameters"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(AssociationAlreadyExistsException.class, "AssociationAlreadyExists"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidCommandIdException.class, "InvalidCommandId"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidDocumentException.class, "InvalidDocument"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidDocumentContentException.class, "InvalidDocumentContent"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(AssociationDoesNotExistException.class, "AssociationDoesNotExist"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(TooManyUpdatesException.class, "TooManyUpdates"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InternalServerErrorException.class, "InternalServerError"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(MaxDocumentSizeExceededException.class, "MaxDocumentSizeExceeded"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(UnsupportedPlatformTypeException.class, "UnsupportedPlatformType"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidInstanceIdException.class, "InvalidInstanceId"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(DocumentAlreadyExistsException.class, "DocumentAlreadyExists"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(DocumentLimitExceededException.class, "DocumentLimitExceeded"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(StatusUnchangedException.class, "StatusUnchanged"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidOutputFolderException.class, "InvalidOutputFolder"));
        this.jsonErrorUnmarshallers.add(JsonErrorUnmarshallerV2.DEFAULT_UNMARSHALLER);
        this.setEndpoint("https://ssm.us-east-1.amazonaws.com");
        this.setServiceNameIntern("ssm");
        this.setEndpointPrefix("ssm");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/simplesystemsmanagement/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/simplesystemsmanagement/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelCommandResult cancelCommand(CancelCommandRequest cancelCommandRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelCommandRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelCommandRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelCommandRequestMarshaller().marshall(super.beforeMarshalling(cancelCommandRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<CancelCommandResult> responseHandler = new JsonResponseHandler<CancelCommandResult>(new CancelCommandResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            CancelCommandResult cancelCommandResult = (CancelCommandResult)response.getAwsResponse();
            return cancelCommandResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAssociationResult createAssociation(CreateAssociationRequest createAssociationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAssociationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAssociationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAssociationRequestMarshaller().marshall(super.beforeMarshalling(createAssociationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<CreateAssociationResult> responseHandler = new JsonResponseHandler<CreateAssociationResult>(new CreateAssociationResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            CreateAssociationResult createAssociationResult = (CreateAssociationResult)response.getAwsResponse();
            return createAssociationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAssociationBatchResult createAssociationBatch(CreateAssociationBatchRequest createAssociationBatchRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAssociationBatchRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAssociationBatchRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAssociationBatchRequestMarshaller().marshall(super.beforeMarshalling(createAssociationBatchRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<CreateAssociationBatchResult> responseHandler = new JsonResponseHandler<CreateAssociationBatchResult>(new CreateAssociationBatchResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            CreateAssociationBatchResult createAssociationBatchResult = (CreateAssociationBatchResult)response.getAwsResponse();
            return createAssociationBatchResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDocumentResult createDocument(CreateDocumentRequest createDocumentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDocumentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDocumentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDocumentRequestMarshaller().marshall(super.beforeMarshalling(createDocumentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<CreateDocumentResult> responseHandler = new JsonResponseHandler<CreateDocumentResult>(new CreateDocumentResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            CreateDocumentResult createDocumentResult = (CreateDocumentResult)response.getAwsResponse();
            return createDocumentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAssociationResult deleteAssociation(DeleteAssociationRequest deleteAssociationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAssociationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAssociationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAssociationRequestMarshaller().marshall(super.beforeMarshalling(deleteAssociationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<DeleteAssociationResult> responseHandler = new JsonResponseHandler<DeleteAssociationResult>(new DeleteAssociationResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAssociationResult deleteAssociationResult = (DeleteAssociationResult)response.getAwsResponse();
            return deleteAssociationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDocumentResult deleteDocument(DeleteDocumentRequest deleteDocumentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDocumentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDocumentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDocumentRequestMarshaller().marshall(super.beforeMarshalling(deleteDocumentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<DeleteDocumentResult> responseHandler = new JsonResponseHandler<DeleteDocumentResult>(new DeleteDocumentResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDocumentResult deleteDocumentResult = (DeleteDocumentResult)response.getAwsResponse();
            return deleteDocumentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAssociationResult describeAssociation(DescribeAssociationRequest describeAssociationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAssociationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAssociationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAssociationRequestMarshaller().marshall(super.beforeMarshalling(describeAssociationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<DescribeAssociationResult> responseHandler = new JsonResponseHandler<DescribeAssociationResult>(new DescribeAssociationResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAssociationResult describeAssociationResult = (DescribeAssociationResult)response.getAwsResponse();
            return describeAssociationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDocumentResult describeDocument(DescribeDocumentRequest describeDocumentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDocumentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDocumentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDocumentRequestMarshaller().marshall(super.beforeMarshalling(describeDocumentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<DescribeDocumentResult> responseHandler = new JsonResponseHandler<DescribeDocumentResult>(new DescribeDocumentResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDocumentResult describeDocumentResult = (DescribeDocumentResult)response.getAwsResponse();
            return describeDocumentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeInstanceInformationResult describeInstanceInformation(DescribeInstanceInformationRequest describeInstanceInformationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeInstanceInformationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeInstanceInformationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeInstanceInformationRequestMarshaller().marshall(super.beforeMarshalling(describeInstanceInformationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<DescribeInstanceInformationResult> responseHandler = new JsonResponseHandler<DescribeInstanceInformationResult>(new DescribeInstanceInformationResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeInstanceInformationResult describeInstanceInformationResult = (DescribeInstanceInformationResult)response.getAwsResponse();
            return describeInstanceInformationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDocumentResult getDocument(GetDocumentRequest getDocumentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDocumentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDocumentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDocumentRequestMarshaller().marshall(super.beforeMarshalling(getDocumentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<GetDocumentResult> responseHandler = new JsonResponseHandler<GetDocumentResult>(new GetDocumentResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            GetDocumentResult getDocumentResult = (GetDocumentResult)response.getAwsResponse();
            return getDocumentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAssociationsResult listAssociations(ListAssociationsRequest listAssociationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAssociationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAssociationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAssociationsRequestMarshaller().marshall(super.beforeMarshalling(listAssociationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<ListAssociationsResult> responseHandler = new JsonResponseHandler<ListAssociationsResult>(new ListAssociationsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            ListAssociationsResult listAssociationsResult = (ListAssociationsResult)response.getAwsResponse();
            return listAssociationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCommandInvocationsResult listCommandInvocations(ListCommandInvocationsRequest listCommandInvocationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listCommandInvocationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListCommandInvocationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListCommandInvocationsRequestMarshaller().marshall(super.beforeMarshalling(listCommandInvocationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<ListCommandInvocationsResult> responseHandler = new JsonResponseHandler<ListCommandInvocationsResult>(new ListCommandInvocationsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            ListCommandInvocationsResult listCommandInvocationsResult = (ListCommandInvocationsResult)response.getAwsResponse();
            return listCommandInvocationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCommandsResult listCommands(ListCommandsRequest listCommandsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listCommandsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListCommandsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListCommandsRequestMarshaller().marshall(super.beforeMarshalling(listCommandsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<ListCommandsResult> responseHandler = new JsonResponseHandler<ListCommandsResult>(new ListCommandsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            ListCommandsResult listCommandsResult = (ListCommandsResult)response.getAwsResponse();
            return listCommandsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDocumentsResult listDocuments(ListDocumentsRequest listDocumentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDocumentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDocumentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDocumentsRequestMarshaller().marshall(super.beforeMarshalling(listDocumentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<ListDocumentsResult> responseHandler = new JsonResponseHandler<ListDocumentsResult>(new ListDocumentsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            ListDocumentsResult listDocumentsResult = (ListDocumentsResult)response.getAwsResponse();
            return listDocumentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDocumentsResult listDocuments() {
        return this.listDocuments(new ListDocumentsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendCommandResult sendCommand(SendCommandRequest sendCommandRequest) {
        ExecutionContext executionContext = this.createExecutionContext(sendCommandRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SendCommandRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SendCommandRequestMarshaller().marshall(super.beforeMarshalling(sendCommandRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<SendCommandResult> responseHandler = new JsonResponseHandler<SendCommandResult>(new SendCommandResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            SendCommandResult sendCommandResult = (SendCommandResult)response.getAwsResponse();
            return sendCommandResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAssociationStatusResult updateAssociationStatus(UpdateAssociationStatusRequest updateAssociationStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAssociationStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateAssociationStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateAssociationStatusRequestMarshaller().marshall(super.beforeMarshalling(updateAssociationStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<UpdateAssociationStatusResult> responseHandler = new JsonResponseHandler<UpdateAssociationStatusResult>(new UpdateAssociationStatusResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            UpdateAssociationStatusResult updateAssociationStatusResult = (UpdateAssociationStatusResult)response.getAwsResponse();
            return updateAssociationStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandlerV2 errorResponseHandler = new JsonErrorResponseHandlerV2(this.jsonErrorUnmarshallers);
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

