/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.ListResourceRecordSetsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListResourceRecordSetsRequestMarshaller
implements Marshaller<Request<ListResourceRecordSetsRequest>, ListResourceRecordSetsRequest> {
    @Override
    public Request<ListResourceRecordSetsRequest> marshall(ListResourceRecordSetsRequest listResourceRecordSetsRequest) {
        String maxItems;
        String startRecordIdentifier;
        String startRecordType;
        String startRecordName;
        if (listResourceRecordSetsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListResourceRecordSetsRequest> request = new DefaultRequest<ListResourceRecordSetsRequest>(listResourceRecordSetsRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/hostedzone/{Id}/rrset";
        uriResourcePath = uriResourcePath.replace("{Id}", listResourceRecordSetsRequest.getHostedZoneId() == null ? "" : StringUtils.fromString(listResourceRecordSetsRequest.getHostedZoneId()));
        request.setResourcePath(uriResourcePath);
        String string = startRecordName = listResourceRecordSetsRequest.getStartRecordName() == null ? null : StringUtils.fromString(listResourceRecordSetsRequest.getStartRecordName());
        if (startRecordName != null) {
            request.addParameter("name", startRecordName);
        }
        String string2 = startRecordType = listResourceRecordSetsRequest.getStartRecordType() == null ? null : StringUtils.fromString(listResourceRecordSetsRequest.getStartRecordType());
        if (startRecordType != null) {
            request.addParameter("type", startRecordType);
        }
        String string3 = startRecordIdentifier = listResourceRecordSetsRequest.getStartRecordIdentifier() == null ? null : StringUtils.fromString(listResourceRecordSetsRequest.getStartRecordIdentifier());
        if (startRecordIdentifier != null) {
            request.addParameter("identifier", startRecordIdentifier);
        }
        String string4 = maxItems = listResourceRecordSetsRequest.getMaxItems() == null ? null : StringUtils.fromString(listResourceRecordSetsRequest.getMaxItems());
        if (maxItems != null) {
            request.addParameter("maxitems", maxItems);
        }
        return request;
    }
}

