/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromRDSRequest;
import com.amazonaws.services.machinelearning.model.transform.RDSDataSpecJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class CreateDataSourceFromRDSRequestMarshaller
implements Marshaller<Request<CreateDataSourceFromRDSRequest>, CreateDataSourceFromRDSRequest> {
    @Override
    public Request<CreateDataSourceFromRDSRequest> marshall(CreateDataSourceFromRDSRequest createDataSourceFromRDSRequest) {
        if (createDataSourceFromRDSRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateDataSourceFromRDSRequest> request = new DefaultRequest<CreateDataSourceFromRDSRequest>(createDataSourceFromRDSRequest, "AmazonMachineLearning");
        request.addHeader("X-Amz-Target", "AmazonML_20141212.CreateDataSourceFromRDS");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createDataSourceFromRDSRequest.getDataSourceId() != null) {
                jsonWriter.key("DataSourceId").value(createDataSourceFromRDSRequest.getDataSourceId());
            }
            if (createDataSourceFromRDSRequest.getDataSourceName() != null) {
                jsonWriter.key("DataSourceName").value(createDataSourceFromRDSRequest.getDataSourceName());
            }
            if (createDataSourceFromRDSRequest.getRDSData() != null) {
                jsonWriter.key("RDSData");
                RDSDataSpecJsonMarshaller.getInstance().marshall(createDataSourceFromRDSRequest.getRDSData(), jsonWriter);
            }
            if (createDataSourceFromRDSRequest.getRoleARN() != null) {
                jsonWriter.key("RoleARN").value(createDataSourceFromRDSRequest.getRoleARN());
            }
            if (createDataSourceFromRDSRequest.getComputeStatistics() != null) {
                jsonWriter.key("ComputeStatistics").value(createDataSourceFromRDSRequest.getComputeStatistics());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

