/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceAsync;
import com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient;
import com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest;
import com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsResult;
import com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest;
import com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsResult;
import com.amazonaws.services.elasticmapreduce.model.AddTagsRequest;
import com.amazonaws.services.elasticmapreduce.model.AddTagsResult;
import com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest;
import com.amazonaws.services.elasticmapreduce.model.DescribeClusterResult;
import com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest;
import com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsResult;
import com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest;
import com.amazonaws.services.elasticmapreduce.model.DescribeStepResult;
import com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsRequest;
import com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsResult;
import com.amazonaws.services.elasticmapreduce.model.ListClustersRequest;
import com.amazonaws.services.elasticmapreduce.model.ListClustersResult;
import com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsRequest;
import com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsResult;
import com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest;
import com.amazonaws.services.elasticmapreduce.model.ListInstancesResult;
import com.amazonaws.services.elasticmapreduce.model.ListStepsRequest;
import com.amazonaws.services.elasticmapreduce.model.ListStepsResult;
import com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest;
import com.amazonaws.services.elasticmapreduce.model.RemoveTagsRequest;
import com.amazonaws.services.elasticmapreduce.model.RemoveTagsResult;
import com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest;
import com.amazonaws.services.elasticmapreduce.model.RunJobFlowResult;
import com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest;
import com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest;
import com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonElasticMapReduceAsyncClient
extends AmazonElasticMapReduceClient
implements AmazonElasticMapReduceAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonElasticMapReduceAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonElasticMapReduceAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonElasticMapReduceAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonElasticMapReduceAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, new ClientConfiguration(), executorService);
    }

    public AmazonElasticMapReduceAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonElasticMapReduceAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonElasticMapReduceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonElasticMapReduceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonElasticMapReduceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddInstanceGroupsResult> addInstanceGroupsAsync(AddInstanceGroupsRequest request) {
        return this.addInstanceGroupsAsync(request, null);
    }

    @Override
    public Future<AddInstanceGroupsResult> addInstanceGroupsAsync(final AddInstanceGroupsRequest request, final AsyncHandler<AddInstanceGroupsRequest, AddInstanceGroupsResult> asyncHandler) {
        return this.executorService.submit(new Callable<AddInstanceGroupsResult>(){

            @Override
            public AddInstanceGroupsResult call() throws Exception {
                AddInstanceGroupsResult result;
                try {
                    result = AmazonElasticMapReduceAsyncClient.this.addInstanceGroups(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AddJobFlowStepsResult> addJobFlowStepsAsync(AddJobFlowStepsRequest request) {
        return this.addJobFlowStepsAsync(request, null);
    }

    @Override
    public Future<AddJobFlowStepsResult> addJobFlowStepsAsync(final AddJobFlowStepsRequest request, final AsyncHandler<AddJobFlowStepsRequest, AddJobFlowStepsResult> asyncHandler) {
        return this.executorService.submit(new Callable<AddJobFlowStepsResult>(){

            @Override
            public AddJobFlowStepsResult call() throws Exception {
                AddJobFlowStepsResult result;
                try {
                    result = AmazonElasticMapReduceAsyncClient.this.addJobFlowSteps(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AddTagsResult> addTagsAsync(AddTagsRequest request) {
        return this.addTagsAsync(request, null);
    }

    @Override
    public Future<AddTagsResult> addTagsAsync(final AddTagsRequest request, final AsyncHandler<AddTagsRequest, AddTagsResult> asyncHandler) {
        return this.executorService.submit(new Callable<AddTagsResult>(){

            @Override
            public AddTagsResult call() throws Exception {
                AddTagsResult result;
                try {
                    result = AmazonElasticMapReduceAsyncClient.this.addTags(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterResult> describeClusterAsync(DescribeClusterRequest request) {
        return this.describeClusterAsync(request, null);
    }

    @Override
    public Future<DescribeClusterResult> describeClusterAsync(final DescribeClusterRequest request, final AsyncHandler<DescribeClusterRequest, DescribeClusterResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeClusterResult>(){

            @Override
            public DescribeClusterResult call() throws Exception {
                DescribeClusterResult result;
                try {
                    result = AmazonElasticMapReduceAsyncClient.this.describeCluster(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    @Deprecated
    public Future<DescribeJobFlowsResult> describeJobFlowsAsync(DescribeJobFlowsRequest request) {
        return this.describeJobFlowsAsync(request, null);
    }

    @Override
    @Deprecated
    public Future<DescribeJobFlowsResult> describeJobFlowsAsync(final DescribeJobFlowsRequest request, final AsyncHandler<DescribeJobFlowsRequest, DescribeJobFlowsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeJobFlowsResult>(){

            @Override
            public DescribeJobFlowsResult call() throws Exception {
                DescribeJobFlowsResult result;
                try {
                    result = AmazonElasticMapReduceAsyncClient.this.describeJobFlows(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    @Deprecated
    public Future<DescribeJobFlowsResult> describeJobFlowsAsync() {
        return this.describeJobFlowsAsync(new DescribeJobFlowsRequest());
    }

    @Override
    public Future<DescribeJobFlowsResult> describeJobFlowsAsync(AsyncHandler<DescribeJobFlowsRequest, DescribeJobFlowsResult> asyncHandler) {
        return this.describeJobFlowsAsync(new DescribeJobFlowsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeStepResult> describeStepAsync(DescribeStepRequest request) {
        return this.describeStepAsync(request, null);
    }

    @Override
    public Future<DescribeStepResult> describeStepAsync(final DescribeStepRequest request, final AsyncHandler<DescribeStepRequest, DescribeStepResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeStepResult>(){

            @Override
            public DescribeStepResult call() throws Exception {
                DescribeStepResult result;
                try {
                    result = AmazonElasticMapReduceAsyncClient.this.describeStep(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListBootstrapActionsResult> listBootstrapActionsAsync(ListBootstrapActionsRequest request) {
        return this.listBootstrapActionsAsync(request, null);
    }

    @Override
    public Future<ListBootstrapActionsResult> listBootstrapActionsAsync(final ListBootstrapActionsRequest request, final AsyncHandler<ListBootstrapActionsRequest, ListBootstrapActionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListBootstrapActionsResult>(){

            @Override
            public ListBootstrapActionsResult call() throws Exception {
                ListBootstrapActionsResult result;
                try {
                    result = AmazonElasticMapReduceAsyncClient.this.listBootstrapActions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListClustersResult> listClustersAsync(ListClustersRequest request) {
        return this.listClustersAsync(request, null);
    }

    @Override
    public Future<ListClustersResult> listClustersAsync(final ListClustersRequest request, final AsyncHandler<ListClustersRequest, ListClustersResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListClustersResult>(){

            @Override
            public ListClustersResult call() throws Exception {
                ListClustersResult result;
                try {
                    result = AmazonElasticMapReduceAsyncClient.this.listClusters(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListClustersResult> listClustersAsync() {
        return this.listClustersAsync(new ListClustersRequest());
    }

    @Override
    public Future<ListClustersResult> listClustersAsync(AsyncHandler<ListClustersRequest, ListClustersResult> asyncHandler) {
        return this.listClustersAsync(new ListClustersRequest(), asyncHandler);
    }

    @Override
    public Future<ListInstanceGroupsResult> listInstanceGroupsAsync(ListInstanceGroupsRequest request) {
        return this.listInstanceGroupsAsync(request, null);
    }

    @Override
    public Future<ListInstanceGroupsResult> listInstanceGroupsAsync(final ListInstanceGroupsRequest request, final AsyncHandler<ListInstanceGroupsRequest, ListInstanceGroupsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListInstanceGroupsResult>(){

            @Override
            public ListInstanceGroupsResult call() throws Exception {
                ListInstanceGroupsResult result;
                try {
                    result = AmazonElasticMapReduceAsyncClient.this.listInstanceGroups(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListInstancesResult> listInstancesAsync(ListInstancesRequest request) {
        return this.listInstancesAsync(request, null);
    }

    @Override
    public Future<ListInstancesResult> listInstancesAsync(final ListInstancesRequest request, final AsyncHandler<ListInstancesRequest, ListInstancesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListInstancesResult>(){

            @Override
            public ListInstancesResult call() throws Exception {
                ListInstancesResult result;
                try {
                    result = AmazonElasticMapReduceAsyncClient.this.listInstances(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListStepsResult> listStepsAsync(ListStepsRequest request) {
        return this.listStepsAsync(request, null);
    }

    @Override
    public Future<ListStepsResult> listStepsAsync(final ListStepsRequest request, final AsyncHandler<ListStepsRequest, ListStepsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListStepsResult>(){

            @Override
            public ListStepsResult call() throws Exception {
                ListStepsResult result;
                try {
                    result = AmazonElasticMapReduceAsyncClient.this.listSteps(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> modifyInstanceGroupsAsync(ModifyInstanceGroupsRequest request) {
        return this.modifyInstanceGroupsAsync(request, null);
    }

    @Override
    public Future<Void> modifyInstanceGroupsAsync(final ModifyInstanceGroupsRequest request, final AsyncHandler<ModifyInstanceGroupsRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonElasticMapReduceAsyncClient.this.modifyInstanceGroups(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> modifyInstanceGroupsAsync() {
        return this.modifyInstanceGroupsAsync(new ModifyInstanceGroupsRequest());
    }

    @Override
    public Future<Void> modifyInstanceGroupsAsync(AsyncHandler<ModifyInstanceGroupsRequest, Void> asyncHandler) {
        return this.modifyInstanceGroupsAsync(new ModifyInstanceGroupsRequest(), asyncHandler);
    }

    @Override
    public Future<RemoveTagsResult> removeTagsAsync(RemoveTagsRequest request) {
        return this.removeTagsAsync(request, null);
    }

    @Override
    public Future<RemoveTagsResult> removeTagsAsync(final RemoveTagsRequest request, final AsyncHandler<RemoveTagsRequest, RemoveTagsResult> asyncHandler) {
        return this.executorService.submit(new Callable<RemoveTagsResult>(){

            @Override
            public RemoveTagsResult call() throws Exception {
                RemoveTagsResult result;
                try {
                    result = AmazonElasticMapReduceAsyncClient.this.removeTags(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RunJobFlowResult> runJobFlowAsync(RunJobFlowRequest request) {
        return this.runJobFlowAsync(request, null);
    }

    @Override
    public Future<RunJobFlowResult> runJobFlowAsync(final RunJobFlowRequest request, final AsyncHandler<RunJobFlowRequest, RunJobFlowResult> asyncHandler) {
        return this.executorService.submit(new Callable<RunJobFlowResult>(){

            @Override
            public RunJobFlowResult call() throws Exception {
                RunJobFlowResult result;
                try {
                    result = AmazonElasticMapReduceAsyncClient.this.runJobFlow(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> setTerminationProtectionAsync(SetTerminationProtectionRequest request) {
        return this.setTerminationProtectionAsync(request, null);
    }

    @Override
    public Future<Void> setTerminationProtectionAsync(final SetTerminationProtectionRequest request, final AsyncHandler<SetTerminationProtectionRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonElasticMapReduceAsyncClient.this.setTerminationProtection(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> setVisibleToAllUsersAsync(SetVisibleToAllUsersRequest request) {
        return this.setVisibleToAllUsersAsync(request, null);
    }

    @Override
    public Future<Void> setVisibleToAllUsersAsync(final SetVisibleToAllUsersRequest request, final AsyncHandler<SetVisibleToAllUsersRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonElasticMapReduceAsyncClient.this.setVisibleToAllUsers(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> terminateJobFlowsAsync(TerminateJobFlowsRequest request) {
        return this.terminateJobFlowsAsync(request, null);
    }

    @Override
    public Future<Void> terminateJobFlowsAsync(final TerminateJobFlowsRequest request, final AsyncHandler<TerminateJobFlowsRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonElasticMapReduceAsyncClient.this.terminateJobFlows(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

