/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.elasticache.AmazonElastiCacheAsync;
import com.amazonaws.services.elasticache.AmazonElastiCacheClient;
import com.amazonaws.services.elasticache.model.AddTagsToResourceRequest;
import com.amazonaws.services.elasticache.model.AddTagsToResourceResult;
import com.amazonaws.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest;
import com.amazonaws.services.elasticache.model.CacheCluster;
import com.amazonaws.services.elasticache.model.CacheParameterGroup;
import com.amazonaws.services.elasticache.model.CacheSecurityGroup;
import com.amazonaws.services.elasticache.model.CacheSubnetGroup;
import com.amazonaws.services.elasticache.model.CopySnapshotRequest;
import com.amazonaws.services.elasticache.model.CreateCacheClusterRequest;
import com.amazonaws.services.elasticache.model.CreateCacheParameterGroupRequest;
import com.amazonaws.services.elasticache.model.CreateCacheSecurityGroupRequest;
import com.amazonaws.services.elasticache.model.CreateCacheSubnetGroupRequest;
import com.amazonaws.services.elasticache.model.CreateReplicationGroupRequest;
import com.amazonaws.services.elasticache.model.CreateSnapshotRequest;
import com.amazonaws.services.elasticache.model.DeleteCacheClusterRequest;
import com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupRequest;
import com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupRequest;
import com.amazonaws.services.elasticache.model.DeleteCacheSubnetGroupRequest;
import com.amazonaws.services.elasticache.model.DeleteReplicationGroupRequest;
import com.amazonaws.services.elasticache.model.DeleteSnapshotRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheClustersResult;
import com.amazonaws.services.elasticache.model.DescribeCacheEngineVersionsRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheEngineVersionsResult;
import com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsResult;
import com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheParametersResult;
import com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsResult;
import com.amazonaws.services.elasticache.model.DescribeCacheSubnetGroupsRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheSubnetGroupsResult;
import com.amazonaws.services.elasticache.model.DescribeEngineDefaultParametersRequest;
import com.amazonaws.services.elasticache.model.DescribeEventsRequest;
import com.amazonaws.services.elasticache.model.DescribeEventsResult;
import com.amazonaws.services.elasticache.model.DescribeReplicationGroupsRequest;
import com.amazonaws.services.elasticache.model.DescribeReplicationGroupsResult;
import com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest;
import com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsResult;
import com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesRequest;
import com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesResult;
import com.amazonaws.services.elasticache.model.DescribeSnapshotsRequest;
import com.amazonaws.services.elasticache.model.DescribeSnapshotsResult;
import com.amazonaws.services.elasticache.model.EngineDefaults;
import com.amazonaws.services.elasticache.model.ListTagsForResourceRequest;
import com.amazonaws.services.elasticache.model.ListTagsForResourceResult;
import com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest;
import com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest;
import com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupResult;
import com.amazonaws.services.elasticache.model.ModifyCacheSubnetGroupRequest;
import com.amazonaws.services.elasticache.model.ModifyReplicationGroupRequest;
import com.amazonaws.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest;
import com.amazonaws.services.elasticache.model.RebootCacheClusterRequest;
import com.amazonaws.services.elasticache.model.RemoveTagsFromResourceRequest;
import com.amazonaws.services.elasticache.model.RemoveTagsFromResourceResult;
import com.amazonaws.services.elasticache.model.ReplicationGroup;
import com.amazonaws.services.elasticache.model.ReservedCacheNode;
import com.amazonaws.services.elasticache.model.ResetCacheParameterGroupRequest;
import com.amazonaws.services.elasticache.model.ResetCacheParameterGroupResult;
import com.amazonaws.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest;
import com.amazonaws.services.elasticache.model.Snapshot;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonElastiCacheAsyncClient
extends AmazonElastiCacheClient
implements AmazonElastiCacheAsync {
    private final ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AmazonElastiCacheAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonElastiCacheAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonElastiCacheAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonElastiCacheAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonElastiCacheAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonElastiCacheAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonElastiCacheAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonElastiCacheAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonElastiCacheAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<EngineDefaults> describeEngineDefaultParametersAsync(final DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EngineDefaults>(){

            @Override
            public EngineDefaults call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.describeEngineDefaultParameters(describeEngineDefaultParametersRequest);
            }
        });
    }

    @Override
    public Future<EngineDefaults> describeEngineDefaultParametersAsync(final DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest, final AsyncHandler<DescribeEngineDefaultParametersRequest, EngineDefaults> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EngineDefaults>(){

            @Override
            public EngineDefaults call() throws Exception {
                EngineDefaults result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeEngineDefaultParameters(describeEngineDefaultParametersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeEngineDefaultParametersRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CacheCluster> deleteCacheClusterAsync(final DeleteCacheClusterRequest deleteCacheClusterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.deleteCacheCluster(deleteCacheClusterRequest);
            }
        });
    }

    @Override
    public Future<CacheCluster> deleteCacheClusterAsync(final DeleteCacheClusterRequest deleteCacheClusterRequest, final AsyncHandler<DeleteCacheClusterRequest, CacheCluster> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                CacheCluster result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.deleteCacheCluster(deleteCacheClusterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteCacheClusterRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ReplicationGroup> deleteReplicationGroupAsync(final DeleteReplicationGroupRequest deleteReplicationGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReplicationGroup>(){

            @Override
            public ReplicationGroup call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.deleteReplicationGroup(deleteReplicationGroupRequest);
            }
        });
    }

    @Override
    public Future<ReplicationGroup> deleteReplicationGroupAsync(final DeleteReplicationGroupRequest deleteReplicationGroupRequest, final AsyncHandler<DeleteReplicationGroupRequest, ReplicationGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReplicationGroup>(){

            @Override
            public ReplicationGroup call() throws Exception {
                ReplicationGroup result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.deleteReplicationGroup(deleteReplicationGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteReplicationGroupRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReservedCacheNodesResult> describeReservedCacheNodesAsync(final DescribeReservedCacheNodesRequest describeReservedCacheNodesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedCacheNodesResult>(){

            @Override
            public DescribeReservedCacheNodesResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.describeReservedCacheNodes(describeReservedCacheNodesRequest);
            }
        });
    }

    @Override
    public Future<DescribeReservedCacheNodesResult> describeReservedCacheNodesAsync(final DescribeReservedCacheNodesRequest describeReservedCacheNodesRequest, final AsyncHandler<DescribeReservedCacheNodesRequest, DescribeReservedCacheNodesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedCacheNodesResult>(){

            @Override
            public DescribeReservedCacheNodesResult call() throws Exception {
                DescribeReservedCacheNodesResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeReservedCacheNodes(describeReservedCacheNodesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeReservedCacheNodesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Snapshot> deleteSnapshotAsync(final DeleteSnapshotRequest deleteSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.deleteSnapshot(deleteSnapshotRequest);
            }
        });
    }

    @Override
    public Future<Snapshot> deleteSnapshotAsync(final DeleteSnapshotRequest deleteSnapshotRequest, final AsyncHandler<DeleteSnapshotRequest, Snapshot> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                Snapshot result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.deleteSnapshot(deleteSnapshotRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteSnapshotRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteCacheSubnetGroupAsync(final DeleteCacheSubnetGroupRequest deleteCacheSubnetGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonElastiCacheAsyncClient.this.deleteCacheSubnetGroup(deleteCacheSubnetGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteCacheSubnetGroupAsync(final DeleteCacheSubnetGroupRequest deleteCacheSubnetGroupRequest, final AsyncHandler<DeleteCacheSubnetGroupRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonElastiCacheAsyncClient.this.deleteCacheSubnetGroup(deleteCacheSubnetGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteCacheSubnetGroupRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<CacheSubnetGroup> createCacheSubnetGroupAsync(final CreateCacheSubnetGroupRequest createCacheSubnetGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheSubnetGroup>(){

            @Override
            public CacheSubnetGroup call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.createCacheSubnetGroup(createCacheSubnetGroupRequest);
            }
        });
    }

    @Override
    public Future<CacheSubnetGroup> createCacheSubnetGroupAsync(final CreateCacheSubnetGroupRequest createCacheSubnetGroupRequest, final AsyncHandler<CreateCacheSubnetGroupRequest, CacheSubnetGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheSubnetGroup>(){

            @Override
            public CacheSubnetGroup call() throws Exception {
                CacheSubnetGroup result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.createCacheSubnetGroup(createCacheSubnetGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createCacheSubnetGroupRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCacheParametersResult> describeCacheParametersAsync(final DescribeCacheParametersRequest describeCacheParametersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCacheParametersResult>(){

            @Override
            public DescribeCacheParametersResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.describeCacheParameters(describeCacheParametersRequest);
            }
        });
    }

    @Override
    public Future<DescribeCacheParametersResult> describeCacheParametersAsync(final DescribeCacheParametersRequest describeCacheParametersRequest, final AsyncHandler<DescribeCacheParametersRequest, DescribeCacheParametersResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCacheParametersResult>(){

            @Override
            public DescribeCacheParametersResult call() throws Exception {
                DescribeCacheParametersResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeCacheParameters(describeCacheParametersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeCacheParametersRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(final ListTagsForResourceRequest listTagsForResourceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.listTagsForResource(listTagsForResourceRequest);
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(final ListTagsForResourceRequest listTagsForResourceRequest, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.listTagsForResource(listTagsForResourceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listTagsForResourceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteCacheSecurityGroupAsync(final DeleteCacheSecurityGroupRequest deleteCacheSecurityGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonElastiCacheAsyncClient.this.deleteCacheSecurityGroup(deleteCacheSecurityGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteCacheSecurityGroupAsync(final DeleteCacheSecurityGroupRequest deleteCacheSecurityGroupRequest, final AsyncHandler<DeleteCacheSecurityGroupRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonElastiCacheAsyncClient.this.deleteCacheSecurityGroup(deleteCacheSecurityGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteCacheSecurityGroupRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<AddTagsToResourceResult> addTagsToResourceAsync(final AddTagsToResourceRequest addTagsToResourceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AddTagsToResourceResult>(){

            @Override
            public AddTagsToResourceResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.addTagsToResource(addTagsToResourceRequest);
            }
        });
    }

    @Override
    public Future<AddTagsToResourceResult> addTagsToResourceAsync(final AddTagsToResourceRequest addTagsToResourceRequest, final AsyncHandler<AddTagsToResourceRequest, AddTagsToResourceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AddTagsToResourceResult>(){

            @Override
            public AddTagsToResourceResult call() throws Exception {
                AddTagsToResourceResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.addTagsToResource(addTagsToResourceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(addTagsToResourceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSnapshotsResult> describeSnapshotsAsync(final DescribeSnapshotsRequest describeSnapshotsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSnapshotsResult>(){

            @Override
            public DescribeSnapshotsResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.describeSnapshots(describeSnapshotsRequest);
            }
        });
    }

    @Override
    public Future<DescribeSnapshotsResult> describeSnapshotsAsync(final DescribeSnapshotsRequest describeSnapshotsRequest, final AsyncHandler<DescribeSnapshotsRequest, DescribeSnapshotsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSnapshotsResult>(){

            @Override
            public DescribeSnapshotsResult call() throws Exception {
                DescribeSnapshotsResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeSnapshots(describeSnapshotsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeSnapshotsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Snapshot> copySnapshotAsync(final CopySnapshotRequest copySnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.copySnapshot(copySnapshotRequest);
            }
        });
    }

    @Override
    public Future<Snapshot> copySnapshotAsync(final CopySnapshotRequest copySnapshotRequest, final AsyncHandler<CopySnapshotRequest, Snapshot> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                Snapshot result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.copySnapshot(copySnapshotRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(copySnapshotRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCacheSecurityGroupsResult> describeCacheSecurityGroupsAsync(final DescribeCacheSecurityGroupsRequest describeCacheSecurityGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCacheSecurityGroupsResult>(){

            @Override
            public DescribeCacheSecurityGroupsResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.describeCacheSecurityGroups(describeCacheSecurityGroupsRequest);
            }
        });
    }

    @Override
    public Future<DescribeCacheSecurityGroupsResult> describeCacheSecurityGroupsAsync(final DescribeCacheSecurityGroupsRequest describeCacheSecurityGroupsRequest, final AsyncHandler<DescribeCacheSecurityGroupsRequest, DescribeCacheSecurityGroupsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCacheSecurityGroupsResult>(){

            @Override
            public DescribeCacheSecurityGroupsResult call() throws Exception {
                DescribeCacheSecurityGroupsResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeCacheSecurityGroups(describeCacheSecurityGroupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeCacheSecurityGroupsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CacheSecurityGroup> revokeCacheSecurityGroupIngressAsync(final RevokeCacheSecurityGroupIngressRequest revokeCacheSecurityGroupIngressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheSecurityGroup>(){

            @Override
            public CacheSecurityGroup call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.revokeCacheSecurityGroupIngress(revokeCacheSecurityGroupIngressRequest);
            }
        });
    }

    @Override
    public Future<CacheSecurityGroup> revokeCacheSecurityGroupIngressAsync(final RevokeCacheSecurityGroupIngressRequest revokeCacheSecurityGroupIngressRequest, final AsyncHandler<RevokeCacheSecurityGroupIngressRequest, CacheSecurityGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheSecurityGroup>(){

            @Override
            public CacheSecurityGroup call() throws Exception {
                CacheSecurityGroup result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.revokeCacheSecurityGroupIngress(revokeCacheSecurityGroupIngressRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(revokeCacheSecurityGroupIngressRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ReplicationGroup> createReplicationGroupAsync(final CreateReplicationGroupRequest createReplicationGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReplicationGroup>(){

            @Override
            public ReplicationGroup call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.createReplicationGroup(createReplicationGroupRequest);
            }
        });
    }

    @Override
    public Future<ReplicationGroup> createReplicationGroupAsync(final CreateReplicationGroupRequest createReplicationGroupRequest, final AsyncHandler<CreateReplicationGroupRequest, ReplicationGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReplicationGroup>(){

            @Override
            public ReplicationGroup call() throws Exception {
                ReplicationGroup result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.createReplicationGroup(createReplicationGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createReplicationGroupRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<RemoveTagsFromResourceResult> removeTagsFromResourceAsync(final RemoveTagsFromResourceRequest removeTagsFromResourceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RemoveTagsFromResourceResult>(){

            @Override
            public RemoveTagsFromResourceResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.removeTagsFromResource(removeTagsFromResourceRequest);
            }
        });
    }

    @Override
    public Future<RemoveTagsFromResourceResult> removeTagsFromResourceAsync(final RemoveTagsFromResourceRequest removeTagsFromResourceRequest, final AsyncHandler<RemoveTagsFromResourceRequest, RemoveTagsFromResourceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RemoveTagsFromResourceResult>(){

            @Override
            public RemoveTagsFromResourceResult call() throws Exception {
                RemoveTagsFromResourceResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.removeTagsFromResource(removeTagsFromResourceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(removeTagsFromResourceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CacheCluster> createCacheClusterAsync(final CreateCacheClusterRequest createCacheClusterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.createCacheCluster(createCacheClusterRequest);
            }
        });
    }

    @Override
    public Future<CacheCluster> createCacheClusterAsync(final CreateCacheClusterRequest createCacheClusterRequest, final AsyncHandler<CreateCacheClusterRequest, CacheCluster> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                CacheCluster result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.createCacheCluster(createCacheClusterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createCacheClusterRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCacheEngineVersionsResult> describeCacheEngineVersionsAsync(final DescribeCacheEngineVersionsRequest describeCacheEngineVersionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCacheEngineVersionsResult>(){

            @Override
            public DescribeCacheEngineVersionsResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.describeCacheEngineVersions(describeCacheEngineVersionsRequest);
            }
        });
    }

    @Override
    public Future<DescribeCacheEngineVersionsResult> describeCacheEngineVersionsAsync(final DescribeCacheEngineVersionsRequest describeCacheEngineVersionsRequest, final AsyncHandler<DescribeCacheEngineVersionsRequest, DescribeCacheEngineVersionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCacheEngineVersionsResult>(){

            @Override
            public DescribeCacheEngineVersionsResult call() throws Exception {
                DescribeCacheEngineVersionsResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeCacheEngineVersions(describeCacheEngineVersionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeCacheEngineVersionsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CacheSubnetGroup> modifyCacheSubnetGroupAsync(final ModifyCacheSubnetGroupRequest modifyCacheSubnetGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheSubnetGroup>(){

            @Override
            public CacheSubnetGroup call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.modifyCacheSubnetGroup(modifyCacheSubnetGroupRequest);
            }
        });
    }

    @Override
    public Future<CacheSubnetGroup> modifyCacheSubnetGroupAsync(final ModifyCacheSubnetGroupRequest modifyCacheSubnetGroupRequest, final AsyncHandler<ModifyCacheSubnetGroupRequest, CacheSubnetGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheSubnetGroup>(){

            @Override
            public CacheSubnetGroup call() throws Exception {
                CacheSubnetGroup result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.modifyCacheSubnetGroup(modifyCacheSubnetGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(modifyCacheSubnetGroupRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteCacheParameterGroupAsync(final DeleteCacheParameterGroupRequest deleteCacheParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonElastiCacheAsyncClient.this.deleteCacheParameterGroup(deleteCacheParameterGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteCacheParameterGroupAsync(final DeleteCacheParameterGroupRequest deleteCacheParameterGroupRequest, final AsyncHandler<DeleteCacheParameterGroupRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonElastiCacheAsyncClient.this.deleteCacheParameterGroup(deleteCacheParameterGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteCacheParameterGroupRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Snapshot> createSnapshotAsync(final CreateSnapshotRequest createSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.createSnapshot(createSnapshotRequest);
            }
        });
    }

    @Override
    public Future<Snapshot> createSnapshotAsync(final CreateSnapshotRequest createSnapshotRequest, final AsyncHandler<CreateSnapshotRequest, Snapshot> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                Snapshot result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.createSnapshot(createSnapshotRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createSnapshotRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(final DescribeEventsRequest describeEventsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEventsResult>(){

            @Override
            public DescribeEventsResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.describeEvents(describeEventsRequest);
            }
        });
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(final DescribeEventsRequest describeEventsRequest, final AsyncHandler<DescribeEventsRequest, DescribeEventsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEventsResult>(){

            @Override
            public DescribeEventsResult call() throws Exception {
                DescribeEventsResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeEvents(describeEventsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeEventsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CacheSecurityGroup> authorizeCacheSecurityGroupIngressAsync(final AuthorizeCacheSecurityGroupIngressRequest authorizeCacheSecurityGroupIngressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheSecurityGroup>(){

            @Override
            public CacheSecurityGroup call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.authorizeCacheSecurityGroupIngress(authorizeCacheSecurityGroupIngressRequest);
            }
        });
    }

    @Override
    public Future<CacheSecurityGroup> authorizeCacheSecurityGroupIngressAsync(final AuthorizeCacheSecurityGroupIngressRequest authorizeCacheSecurityGroupIngressRequest, final AsyncHandler<AuthorizeCacheSecurityGroupIngressRequest, CacheSecurityGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheSecurityGroup>(){

            @Override
            public CacheSecurityGroup call() throws Exception {
                CacheSecurityGroup result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.authorizeCacheSecurityGroupIngress(authorizeCacheSecurityGroupIngressRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(authorizeCacheSecurityGroupIngressRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ReservedCacheNode> purchaseReservedCacheNodesOfferingAsync(final PurchaseReservedCacheNodesOfferingRequest purchaseReservedCacheNodesOfferingRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReservedCacheNode>(){

            @Override
            public ReservedCacheNode call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.purchaseReservedCacheNodesOffering(purchaseReservedCacheNodesOfferingRequest);
            }
        });
    }

    @Override
    public Future<ReservedCacheNode> purchaseReservedCacheNodesOfferingAsync(final PurchaseReservedCacheNodesOfferingRequest purchaseReservedCacheNodesOfferingRequest, final AsyncHandler<PurchaseReservedCacheNodesOfferingRequest, ReservedCacheNode> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReservedCacheNode>(){

            @Override
            public ReservedCacheNode call() throws Exception {
                ReservedCacheNode result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.purchaseReservedCacheNodesOffering(purchaseReservedCacheNodesOfferingRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(purchaseReservedCacheNodesOfferingRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ReplicationGroup> modifyReplicationGroupAsync(final ModifyReplicationGroupRequest modifyReplicationGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReplicationGroup>(){

            @Override
            public ReplicationGroup call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.modifyReplicationGroup(modifyReplicationGroupRequest);
            }
        });
    }

    @Override
    public Future<ReplicationGroup> modifyReplicationGroupAsync(final ModifyReplicationGroupRequest modifyReplicationGroupRequest, final AsyncHandler<ModifyReplicationGroupRequest, ReplicationGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReplicationGroup>(){

            @Override
            public ReplicationGroup call() throws Exception {
                ReplicationGroup result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.modifyReplicationGroup(modifyReplicationGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(modifyReplicationGroupRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReplicationGroupsResult> describeReplicationGroupsAsync(final DescribeReplicationGroupsRequest describeReplicationGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReplicationGroupsResult>(){

            @Override
            public DescribeReplicationGroupsResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.describeReplicationGroups(describeReplicationGroupsRequest);
            }
        });
    }

    @Override
    public Future<DescribeReplicationGroupsResult> describeReplicationGroupsAsync(final DescribeReplicationGroupsRequest describeReplicationGroupsRequest, final AsyncHandler<DescribeReplicationGroupsRequest, DescribeReplicationGroupsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReplicationGroupsResult>(){

            @Override
            public DescribeReplicationGroupsResult call() throws Exception {
                DescribeReplicationGroupsResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeReplicationGroups(describeReplicationGroupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeReplicationGroupsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ModifyCacheParameterGroupResult> modifyCacheParameterGroupAsync(final ModifyCacheParameterGroupRequest modifyCacheParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifyCacheParameterGroupResult>(){

            @Override
            public ModifyCacheParameterGroupResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.modifyCacheParameterGroup(modifyCacheParameterGroupRequest);
            }
        });
    }

    @Override
    public Future<ModifyCacheParameterGroupResult> modifyCacheParameterGroupAsync(final ModifyCacheParameterGroupRequest modifyCacheParameterGroupRequest, final AsyncHandler<ModifyCacheParameterGroupRequest, ModifyCacheParameterGroupResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifyCacheParameterGroupResult>(){

            @Override
            public ModifyCacheParameterGroupResult call() throws Exception {
                ModifyCacheParameterGroupResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.modifyCacheParameterGroup(modifyCacheParameterGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(modifyCacheParameterGroupRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReservedCacheNodesOfferingsResult> describeReservedCacheNodesOfferingsAsync(final DescribeReservedCacheNodesOfferingsRequest describeReservedCacheNodesOfferingsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedCacheNodesOfferingsResult>(){

            @Override
            public DescribeReservedCacheNodesOfferingsResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.describeReservedCacheNodesOfferings(describeReservedCacheNodesOfferingsRequest);
            }
        });
    }

    @Override
    public Future<DescribeReservedCacheNodesOfferingsResult> describeReservedCacheNodesOfferingsAsync(final DescribeReservedCacheNodesOfferingsRequest describeReservedCacheNodesOfferingsRequest, final AsyncHandler<DescribeReservedCacheNodesOfferingsRequest, DescribeReservedCacheNodesOfferingsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedCacheNodesOfferingsResult>(){

            @Override
            public DescribeReservedCacheNodesOfferingsResult call() throws Exception {
                DescribeReservedCacheNodesOfferingsResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeReservedCacheNodesOfferings(describeReservedCacheNodesOfferingsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeReservedCacheNodesOfferingsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CacheCluster> modifyCacheClusterAsync(final ModifyCacheClusterRequest modifyCacheClusterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.modifyCacheCluster(modifyCacheClusterRequest);
            }
        });
    }

    @Override
    public Future<CacheCluster> modifyCacheClusterAsync(final ModifyCacheClusterRequest modifyCacheClusterRequest, final AsyncHandler<ModifyCacheClusterRequest, CacheCluster> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                CacheCluster result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.modifyCacheCluster(modifyCacheClusterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(modifyCacheClusterRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ResetCacheParameterGroupResult> resetCacheParameterGroupAsync(final ResetCacheParameterGroupRequest resetCacheParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ResetCacheParameterGroupResult>(){

            @Override
            public ResetCacheParameterGroupResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.resetCacheParameterGroup(resetCacheParameterGroupRequest);
            }
        });
    }

    @Override
    public Future<ResetCacheParameterGroupResult> resetCacheParameterGroupAsync(final ResetCacheParameterGroupRequest resetCacheParameterGroupRequest, final AsyncHandler<ResetCacheParameterGroupRequest, ResetCacheParameterGroupResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ResetCacheParameterGroupResult>(){

            @Override
            public ResetCacheParameterGroupResult call() throws Exception {
                ResetCacheParameterGroupResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.resetCacheParameterGroup(resetCacheParameterGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(resetCacheParameterGroupRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCacheClustersResult> describeCacheClustersAsync(final DescribeCacheClustersRequest describeCacheClustersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCacheClustersResult>(){

            @Override
            public DescribeCacheClustersResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.describeCacheClusters(describeCacheClustersRequest);
            }
        });
    }

    @Override
    public Future<DescribeCacheClustersResult> describeCacheClustersAsync(final DescribeCacheClustersRequest describeCacheClustersRequest, final AsyncHandler<DescribeCacheClustersRequest, DescribeCacheClustersResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCacheClustersResult>(){

            @Override
            public DescribeCacheClustersResult call() throws Exception {
                DescribeCacheClustersResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeCacheClusters(describeCacheClustersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeCacheClustersRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CacheSecurityGroup> createCacheSecurityGroupAsync(final CreateCacheSecurityGroupRequest createCacheSecurityGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheSecurityGroup>(){

            @Override
            public CacheSecurityGroup call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.createCacheSecurityGroup(createCacheSecurityGroupRequest);
            }
        });
    }

    @Override
    public Future<CacheSecurityGroup> createCacheSecurityGroupAsync(final CreateCacheSecurityGroupRequest createCacheSecurityGroupRequest, final AsyncHandler<CreateCacheSecurityGroupRequest, CacheSecurityGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheSecurityGroup>(){

            @Override
            public CacheSecurityGroup call() throws Exception {
                CacheSecurityGroup result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.createCacheSecurityGroup(createCacheSecurityGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createCacheSecurityGroupRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCacheSubnetGroupsResult> describeCacheSubnetGroupsAsync(final DescribeCacheSubnetGroupsRequest describeCacheSubnetGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCacheSubnetGroupsResult>(){

            @Override
            public DescribeCacheSubnetGroupsResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.describeCacheSubnetGroups(describeCacheSubnetGroupsRequest);
            }
        });
    }

    @Override
    public Future<DescribeCacheSubnetGroupsResult> describeCacheSubnetGroupsAsync(final DescribeCacheSubnetGroupsRequest describeCacheSubnetGroupsRequest, final AsyncHandler<DescribeCacheSubnetGroupsRequest, DescribeCacheSubnetGroupsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCacheSubnetGroupsResult>(){

            @Override
            public DescribeCacheSubnetGroupsResult call() throws Exception {
                DescribeCacheSubnetGroupsResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeCacheSubnetGroups(describeCacheSubnetGroupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeCacheSubnetGroupsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCacheParameterGroupsResult> describeCacheParameterGroupsAsync(final DescribeCacheParameterGroupsRequest describeCacheParameterGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCacheParameterGroupsResult>(){

            @Override
            public DescribeCacheParameterGroupsResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.describeCacheParameterGroups(describeCacheParameterGroupsRequest);
            }
        });
    }

    @Override
    public Future<DescribeCacheParameterGroupsResult> describeCacheParameterGroupsAsync(final DescribeCacheParameterGroupsRequest describeCacheParameterGroupsRequest, final AsyncHandler<DescribeCacheParameterGroupsRequest, DescribeCacheParameterGroupsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCacheParameterGroupsResult>(){

            @Override
            public DescribeCacheParameterGroupsResult call() throws Exception {
                DescribeCacheParameterGroupsResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeCacheParameterGroups(describeCacheParameterGroupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeCacheParameterGroupsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CacheCluster> rebootCacheClusterAsync(final RebootCacheClusterRequest rebootCacheClusterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.rebootCacheCluster(rebootCacheClusterRequest);
            }
        });
    }

    @Override
    public Future<CacheCluster> rebootCacheClusterAsync(final RebootCacheClusterRequest rebootCacheClusterRequest, final AsyncHandler<RebootCacheClusterRequest, CacheCluster> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                CacheCluster result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.rebootCacheCluster(rebootCacheClusterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(rebootCacheClusterRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CacheParameterGroup> createCacheParameterGroupAsync(final CreateCacheParameterGroupRequest createCacheParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheParameterGroup>(){

            @Override
            public CacheParameterGroup call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.createCacheParameterGroup(createCacheParameterGroupRequest);
            }
        });
    }

    @Override
    public Future<CacheParameterGroup> createCacheParameterGroupAsync(final CreateCacheParameterGroupRequest createCacheParameterGroupRequest, final AsyncHandler<CreateCacheParameterGroupRequest, CacheParameterGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheParameterGroup>(){

            @Override
            public CacheParameterGroup call() throws Exception {
                CacheParameterGroup result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.createCacheParameterGroup(createCacheParameterGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createCacheParameterGroupRequest, result);
                return result;
            }
        });
    }
}

