/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ecr.model.ImageIdentifier;
import com.amazonaws.util.json.JSONWriter;

public class ImageIdentifierJsonMarshaller {
    private static ImageIdentifierJsonMarshaller instance;

    public void marshall(ImageIdentifier imageIdentifier, JSONWriter jsonWriter) {
        if (imageIdentifier == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (imageIdentifier.getImageDigest() != null) {
                jsonWriter.key("imageDigest").value(imageIdentifier.getImageDigest());
            }
            if (imageIdentifier.getImageTag() != null) {
                jsonWriter.key("imageTag").value(imageIdentifier.getImageTag());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ImageIdentifierJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ImageIdentifierJsonMarshaller();
        }
        return instance;
    }
}

