/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetBasePathMappingRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetBasePathMappingRequestMarshaller
implements Marshaller<Request<GetBasePathMappingRequest>, GetBasePathMappingRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<GetBasePathMappingRequest> marshall(GetBasePathMappingRequest getBasePathMappingRequest) {
        if (getBasePathMappingRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetBasePathMappingRequest> request = new DefaultRequest<GetBasePathMappingRequest>(getBasePathMappingRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/domainnames/{domain_name}/basepathmappings/{base_path}";
        uriResourcePath = uriResourcePath.replace("{domain_name}", getBasePathMappingRequest.getDomainName() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(getBasePathMappingRequest.getDomainName()));
        uriResourcePath = uriResourcePath.replace("{base_path}", getBasePathMappingRequest.getBasePath() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(getBasePathMappingRequest.getBasePath()));
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

