/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elastictranscoder.model.Permission;
import com.amazonaws.util.json.JSONWriter;

public class PermissionJsonMarshaller {
    private static PermissionJsonMarshaller instance;

    public void marshall(Permission permission, JSONWriter jsonWriter) {
        if (permission == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList accessList;
            jsonWriter.object();
            if (permission.getGranteeType() != null) {
                jsonWriter.key("GranteeType").value(permission.getGranteeType());
            }
            if (permission.getGrantee() != null) {
                jsonWriter.key("Grantee").value(permission.getGrantee());
            }
            if (!(accessList = (SdkInternalList)permission.getAccess()).isEmpty() || !accessList.isAutoConstruct()) {
                jsonWriter.key("Access");
                jsonWriter.array();
                for (String accessListValue : accessList) {
                    if (accessListValue == null) continue;
                    jsonWriter.value(accessListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PermissionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PermissionJsonMarshaller();
        }
        return instance;
    }
}

