/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroupType;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListInstancesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clusterId;
    private String instanceGroupId;
    private SdkInternalList<String> instanceGroupTypes;
    private String marker;

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public ListInstancesRequest withClusterId(String clusterId) {
        this.setClusterId(clusterId);
        return this;
    }

    public void setInstanceGroupId(String instanceGroupId) {
        this.instanceGroupId = instanceGroupId;
    }

    public String getInstanceGroupId() {
        return this.instanceGroupId;
    }

    public ListInstancesRequest withInstanceGroupId(String instanceGroupId) {
        this.setInstanceGroupId(instanceGroupId);
        return this;
    }

    public List<String> getInstanceGroupTypes() {
        if (this.instanceGroupTypes == null) {
            this.instanceGroupTypes = new SdkInternalList();
        }
        return this.instanceGroupTypes;
    }

    public void setInstanceGroupTypes(Collection<String> instanceGroupTypes) {
        if (instanceGroupTypes == null) {
            this.instanceGroupTypes = null;
            return;
        }
        this.instanceGroupTypes = new SdkInternalList<String>(instanceGroupTypes);
    }

    public ListInstancesRequest withInstanceGroupTypes(String ... instanceGroupTypes) {
        if (this.instanceGroupTypes == null) {
            this.setInstanceGroupTypes(new SdkInternalList<String>(instanceGroupTypes.length));
        }
        for (String ele : instanceGroupTypes) {
            this.instanceGroupTypes.add(ele);
        }
        return this;
    }

    public ListInstancesRequest withInstanceGroupTypes(Collection<String> instanceGroupTypes) {
        this.setInstanceGroupTypes(instanceGroupTypes);
        return this;
    }

    public ListInstancesRequest withInstanceGroupTypes(InstanceGroupType ... instanceGroupTypes) {
        SdkInternalList<String> instanceGroupTypesCopy = new SdkInternalList<String>(instanceGroupTypes.length);
        for (InstanceGroupType value : instanceGroupTypes) {
            instanceGroupTypesCopy.add(value.toString());
        }
        if (this.getInstanceGroupTypes() == null) {
            this.setInstanceGroupTypes(instanceGroupTypesCopy);
        } else {
            this.getInstanceGroupTypes().addAll(instanceGroupTypesCopy);
        }
        return this;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public ListInstancesRequest withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterId() != null) {
            sb.append("ClusterId: " + this.getClusterId() + ",");
        }
        if (this.getInstanceGroupId() != null) {
            sb.append("InstanceGroupId: " + this.getInstanceGroupId() + ",");
        }
        if (this.getInstanceGroupTypes() != null) {
            sb.append("InstanceGroupTypes: " + this.getInstanceGroupTypes() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstancesRequest)) {
            return false;
        }
        ListInstancesRequest other = (ListInstancesRequest)obj;
        if (other.getClusterId() == null ^ this.getClusterId() == null) {
            return false;
        }
        if (other.getClusterId() != null && !other.getClusterId().equals(this.getClusterId())) {
            return false;
        }
        if (other.getInstanceGroupId() == null ^ this.getInstanceGroupId() == null) {
            return false;
        }
        if (other.getInstanceGroupId() != null && !other.getInstanceGroupId().equals(this.getInstanceGroupId())) {
            return false;
        }
        if (other.getInstanceGroupTypes() == null ^ this.getInstanceGroupTypes() == null) {
            return false;
        }
        if (other.getInstanceGroupTypes() != null && !other.getInstanceGroupTypes().equals(this.getInstanceGroupTypes())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusterId() == null ? 0 : this.getClusterId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceGroupId() == null ? 0 : this.getInstanceGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceGroupTypes() == null ? 0 : this.getInstanceGroupTypes().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    @Override
    public ListInstancesRequest clone() {
        return (ListInstancesRequest)super.clone();
    }
}

