/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.services.simpleemail.model.WorkmailAction;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class WorkmailActionStaxUnmarshaller
implements Unmarshaller<WorkmailAction, StaxUnmarshallerContext> {
    private static WorkmailActionStaxUnmarshaller instance;

    @Override
    public WorkmailAction unmarshall(StaxUnmarshallerContext context) throws Exception {
        WorkmailAction workmailAction = new WorkmailAction();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return workmailAction;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("TopicArn", targetDepth)) {
                    workmailAction.setTopicArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("OrganizationArn", targetDepth)) continue;
                workmailAction.setOrganizationArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return workmailAction;
    }

    public static WorkmailActionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new WorkmailActionStaxUnmarshaller();
        }
        return instance;
    }
}

