/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.opsworks.model.Recipes;
import com.amazonaws.util.json.JSONWriter;

public class RecipesJsonMarshaller {
    private static RecipesJsonMarshaller instance;

    public void marshall(Recipes recipes, JSONWriter jsonWriter) {
        if (recipes == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList shutdownList;
            SdkInternalList undeployList;
            SdkInternalList deployList;
            SdkInternalList configureList;
            jsonWriter.object();
            SdkInternalList setupList = (SdkInternalList)recipes.getSetup();
            if (!setupList.isEmpty() || !setupList.isAutoConstruct()) {
                jsonWriter.key("Setup");
                jsonWriter.array();
                for (String setupListValue : setupList) {
                    if (setupListValue == null) continue;
                    jsonWriter.value(setupListValue);
                }
                jsonWriter.endArray();
            }
            if (!(configureList = (SdkInternalList)recipes.getConfigure()).isEmpty() || !configureList.isAutoConstruct()) {
                jsonWriter.key("Configure");
                jsonWriter.array();
                for (String configureListValue : configureList) {
                    if (configureListValue == null) continue;
                    jsonWriter.value(configureListValue);
                }
                jsonWriter.endArray();
            }
            if (!(deployList = (SdkInternalList)recipes.getDeploy()).isEmpty() || !deployList.isAutoConstruct()) {
                jsonWriter.key("Deploy");
                jsonWriter.array();
                for (String deployListValue : deployList) {
                    if (deployListValue == null) continue;
                    jsonWriter.value(deployListValue);
                }
                jsonWriter.endArray();
            }
            if (!(undeployList = (SdkInternalList)recipes.getUndeploy()).isEmpty() || !undeployList.isAutoConstruct()) {
                jsonWriter.key("Undeploy");
                jsonWriter.array();
                for (String undeployListValue : undeployList) {
                    if (undeployListValue == null) continue;
                    jsonWriter.value(undeployListValue);
                }
                jsonWriter.endArray();
            }
            if (!(shutdownList = (SdkInternalList)recipes.getShutdown()).isEmpty() || !shutdownList.isAutoConstruct()) {
                jsonWriter.key("Shutdown");
                jsonWriter.array();
                for (String shutdownListValue : shutdownList) {
                    if (shutdownListValue == null) continue;
                    jsonWriter.value(shutdownListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RecipesJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RecipesJsonMarshaller();
        }
        return instance;
    }
}

