/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model;

import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListStreamsResult
implements Serializable,
Cloneable {
    private SdkInternalList<String> streamNames;
    private Boolean hasMoreStreams;

    public List<String> getStreamNames() {
        if (this.streamNames == null) {
            this.streamNames = new SdkInternalList();
        }
        return this.streamNames;
    }

    public void setStreamNames(Collection<String> streamNames) {
        if (streamNames == null) {
            this.streamNames = null;
            return;
        }
        this.streamNames = new SdkInternalList<String>(streamNames);
    }

    public ListStreamsResult withStreamNames(String ... streamNames) {
        if (this.streamNames == null) {
            this.setStreamNames(new SdkInternalList<String>(streamNames.length));
        }
        for (String ele : streamNames) {
            this.streamNames.add(ele);
        }
        return this;
    }

    public ListStreamsResult withStreamNames(Collection<String> streamNames) {
        this.setStreamNames(streamNames);
        return this;
    }

    public void setHasMoreStreams(Boolean hasMoreStreams) {
        this.hasMoreStreams = hasMoreStreams;
    }

    public Boolean getHasMoreStreams() {
        return this.hasMoreStreams;
    }

    public ListStreamsResult withHasMoreStreams(Boolean hasMoreStreams) {
        this.setHasMoreStreams(hasMoreStreams);
        return this;
    }

    public Boolean isHasMoreStreams() {
        return this.hasMoreStreams;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStreamNames() != null) {
            sb.append("StreamNames: " + this.getStreamNames() + ",");
        }
        if (this.getHasMoreStreams() != null) {
            sb.append("HasMoreStreams: " + this.getHasMoreStreams());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamsResult)) {
            return false;
        }
        ListStreamsResult other = (ListStreamsResult)obj;
        if (other.getStreamNames() == null ^ this.getStreamNames() == null) {
            return false;
        }
        if (other.getStreamNames() != null && !other.getStreamNames().equals(this.getStreamNames())) {
            return false;
        }
        if (other.getHasMoreStreams() == null ^ this.getHasMoreStreams() == null) {
            return false;
        }
        return other.getHasMoreStreams() == null || other.getHasMoreStreams().equals(this.getHasMoreStreams());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStreamNames() == null ? 0 : this.getStreamNames().hashCode());
        hashCode = 31 * hashCode + (this.getHasMoreStreams() == null ? 0 : this.getHasMoreStreams().hashCode());
        return hashCode;
    }

    public ListStreamsResult clone() {
        try {
            return (ListStreamsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

