/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.ContainerOverride;
import com.amazonaws.services.ecs.model.KeyValuePair;
import com.amazonaws.services.ecs.model.transform.KeyValuePairJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class ContainerOverrideJsonMarshaller {
    private static ContainerOverrideJsonMarshaller instance;

    public void marshall(ContainerOverride containerOverride, JSONWriter jsonWriter) {
        if (containerOverride == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList environmentList;
            SdkInternalList commandList;
            jsonWriter.object();
            if (containerOverride.getName() != null) {
                jsonWriter.key("name").value(containerOverride.getName());
            }
            if (!(commandList = (SdkInternalList)containerOverride.getCommand()).isEmpty() || !commandList.isAutoConstruct()) {
                jsonWriter.key("command");
                jsonWriter.array();
                for (String commandListValue : commandList) {
                    if (commandListValue == null) continue;
                    jsonWriter.value(commandListValue);
                }
                jsonWriter.endArray();
            }
            if (!(environmentList = (SdkInternalList)containerOverride.getEnvironment()).isEmpty() || !environmentList.isAutoConstruct()) {
                jsonWriter.key("environment");
                jsonWriter.array();
                for (KeyValuePair environmentListValue : environmentList) {
                    if (environmentListValue == null) continue;
                    KeyValuePairJsonMarshaller.getInstance().marshall(environmentListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ContainerOverrideJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ContainerOverrideJsonMarshaller();
        }
        return instance;
    }
}

