/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.simpleemail.model.ReceiptRule;
import com.amazonaws.services.simpleemail.model.ReceiptRuleSetMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeActiveReceiptRuleSetResult
implements Serializable,
Cloneable {
    private ReceiptRuleSetMetadata metadata;
    private ListWithAutoConstructFlag<ReceiptRule> rules;

    public ReceiptRuleSetMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ReceiptRuleSetMetadata metadata) {
        this.metadata = metadata;
    }

    public DescribeActiveReceiptRuleSetResult withMetadata(ReceiptRuleSetMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<ReceiptRule> getRules() {
        if (this.rules == null) {
            this.rules = new ListWithAutoConstructFlag();
            this.rules.setAutoConstruct(true);
        }
        return this.rules;
    }

    public void setRules(Collection<ReceiptRule> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        ListWithAutoConstructFlag rulesCopy = new ListWithAutoConstructFlag(rules.size());
        rulesCopy.addAll(rules);
        this.rules = rulesCopy;
    }

    public DescribeActiveReceiptRuleSetResult withRules(ReceiptRule ... rules) {
        if (this.getRules() == null) {
            this.setRules(new ArrayList<ReceiptRule>(rules.length));
        }
        for (ReceiptRule value : rules) {
            this.getRules().add(value);
        }
        return this;
    }

    public DescribeActiveReceiptRuleSetResult withRules(Collection<ReceiptRule> rules) {
        if (rules == null) {
            this.rules = null;
        } else {
            ListWithAutoConstructFlag rulesCopy = new ListWithAutoConstructFlag(rules.size());
            rulesCopy.addAll(rules);
            this.rules = rulesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMetadata() != null) {
            sb.append("Metadata: " + this.getMetadata() + ",");
        }
        if (this.getRules() != null) {
            sb.append("Rules: " + this.getRules());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMetadata() == null ? 0 : this.getMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActiveReceiptRuleSetResult)) {
            return false;
        }
        DescribeActiveReceiptRuleSetResult other = (DescribeActiveReceiptRuleSetResult)obj;
        if (other.getMetadata() == null ^ this.getMetadata() == null) {
            return false;
        }
        if (other.getMetadata() != null && !other.getMetadata().equals(this.getMetadata())) {
            return false;
        }
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        return other.getRules() == null || other.getRules().equals(this.getRules());
    }

    public DescribeActiveReceiptRuleSetResult clone() {
        try {
            return (DescribeActiveReceiptRuleSetResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

