/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.route53.AmazonRoute53Async;
import com.amazonaws.services.route53.AmazonRoute53Client;
import com.amazonaws.services.route53.model.AssociateVPCWithHostedZoneRequest;
import com.amazonaws.services.route53.model.AssociateVPCWithHostedZoneResult;
import com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.ChangeResourceRecordSetsResult;
import com.amazonaws.services.route53.model.ChangeTagsForResourceRequest;
import com.amazonaws.services.route53.model.ChangeTagsForResourceResult;
import com.amazonaws.services.route53.model.CreateHealthCheckRequest;
import com.amazonaws.services.route53.model.CreateHealthCheckResult;
import com.amazonaws.services.route53.model.CreateHostedZoneRequest;
import com.amazonaws.services.route53.model.CreateHostedZoneResult;
import com.amazonaws.services.route53.model.CreateReusableDelegationSetRequest;
import com.amazonaws.services.route53.model.CreateReusableDelegationSetResult;
import com.amazonaws.services.route53.model.CreateTrafficPolicyInstanceRequest;
import com.amazonaws.services.route53.model.CreateTrafficPolicyInstanceResult;
import com.amazonaws.services.route53.model.CreateTrafficPolicyRequest;
import com.amazonaws.services.route53.model.CreateTrafficPolicyResult;
import com.amazonaws.services.route53.model.CreateTrafficPolicyVersionRequest;
import com.amazonaws.services.route53.model.CreateTrafficPolicyVersionResult;
import com.amazonaws.services.route53.model.DeleteHealthCheckRequest;
import com.amazonaws.services.route53.model.DeleteHealthCheckResult;
import com.amazonaws.services.route53.model.DeleteHostedZoneRequest;
import com.amazonaws.services.route53.model.DeleteHostedZoneResult;
import com.amazonaws.services.route53.model.DeleteReusableDelegationSetRequest;
import com.amazonaws.services.route53.model.DeleteReusableDelegationSetResult;
import com.amazonaws.services.route53.model.DeleteTrafficPolicyInstanceRequest;
import com.amazonaws.services.route53.model.DeleteTrafficPolicyInstanceResult;
import com.amazonaws.services.route53.model.DeleteTrafficPolicyRequest;
import com.amazonaws.services.route53.model.DeleteTrafficPolicyResult;
import com.amazonaws.services.route53.model.DisassociateVPCFromHostedZoneRequest;
import com.amazonaws.services.route53.model.DisassociateVPCFromHostedZoneResult;
import com.amazonaws.services.route53.model.GetChangeDetailsRequest;
import com.amazonaws.services.route53.model.GetChangeDetailsResult;
import com.amazonaws.services.route53.model.GetChangeRequest;
import com.amazonaws.services.route53.model.GetChangeResult;
import com.amazonaws.services.route53.model.GetCheckerIpRangesRequest;
import com.amazonaws.services.route53.model.GetCheckerIpRangesResult;
import com.amazonaws.services.route53.model.GetGeoLocationRequest;
import com.amazonaws.services.route53.model.GetGeoLocationResult;
import com.amazonaws.services.route53.model.GetHealthCheckCountRequest;
import com.amazonaws.services.route53.model.GetHealthCheckCountResult;
import com.amazonaws.services.route53.model.GetHealthCheckLastFailureReasonRequest;
import com.amazonaws.services.route53.model.GetHealthCheckLastFailureReasonResult;
import com.amazonaws.services.route53.model.GetHealthCheckRequest;
import com.amazonaws.services.route53.model.GetHealthCheckResult;
import com.amazonaws.services.route53.model.GetHealthCheckStatusRequest;
import com.amazonaws.services.route53.model.GetHealthCheckStatusResult;
import com.amazonaws.services.route53.model.GetHostedZoneCountRequest;
import com.amazonaws.services.route53.model.GetHostedZoneCountResult;
import com.amazonaws.services.route53.model.GetHostedZoneRequest;
import com.amazonaws.services.route53.model.GetHostedZoneResult;
import com.amazonaws.services.route53.model.GetReusableDelegationSetRequest;
import com.amazonaws.services.route53.model.GetReusableDelegationSetResult;
import com.amazonaws.services.route53.model.GetTrafficPolicyInstanceCountRequest;
import com.amazonaws.services.route53.model.GetTrafficPolicyInstanceCountResult;
import com.amazonaws.services.route53.model.GetTrafficPolicyInstanceRequest;
import com.amazonaws.services.route53.model.GetTrafficPolicyInstanceResult;
import com.amazonaws.services.route53.model.GetTrafficPolicyRequest;
import com.amazonaws.services.route53.model.GetTrafficPolicyResult;
import com.amazonaws.services.route53.model.ListChangeBatchesByHostedZoneRequest;
import com.amazonaws.services.route53.model.ListChangeBatchesByHostedZoneResult;
import com.amazonaws.services.route53.model.ListChangeBatchesByRRSetRequest;
import com.amazonaws.services.route53.model.ListChangeBatchesByRRSetResult;
import com.amazonaws.services.route53.model.ListGeoLocationsRequest;
import com.amazonaws.services.route53.model.ListGeoLocationsResult;
import com.amazonaws.services.route53.model.ListHealthChecksRequest;
import com.amazonaws.services.route53.model.ListHealthChecksResult;
import com.amazonaws.services.route53.model.ListHostedZonesByNameRequest;
import com.amazonaws.services.route53.model.ListHostedZonesByNameResult;
import com.amazonaws.services.route53.model.ListHostedZonesRequest;
import com.amazonaws.services.route53.model.ListHostedZonesResult;
import com.amazonaws.services.route53.model.ListResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.ListResourceRecordSetsResult;
import com.amazonaws.services.route53.model.ListReusableDelegationSetsRequest;
import com.amazonaws.services.route53.model.ListReusableDelegationSetsResult;
import com.amazonaws.services.route53.model.ListTagsForResourceRequest;
import com.amazonaws.services.route53.model.ListTagsForResourceResult;
import com.amazonaws.services.route53.model.ListTagsForResourcesRequest;
import com.amazonaws.services.route53.model.ListTagsForResourcesResult;
import com.amazonaws.services.route53.model.ListTrafficPoliciesRequest;
import com.amazonaws.services.route53.model.ListTrafficPoliciesResult;
import com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest;
import com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByHostedZoneResult;
import com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByPolicyRequest;
import com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByPolicyResult;
import com.amazonaws.services.route53.model.ListTrafficPolicyInstancesRequest;
import com.amazonaws.services.route53.model.ListTrafficPolicyInstancesResult;
import com.amazonaws.services.route53.model.ListTrafficPolicyVersionsRequest;
import com.amazonaws.services.route53.model.ListTrafficPolicyVersionsResult;
import com.amazonaws.services.route53.model.UpdateHealthCheckRequest;
import com.amazonaws.services.route53.model.UpdateHealthCheckResult;
import com.amazonaws.services.route53.model.UpdateHostedZoneCommentRequest;
import com.amazonaws.services.route53.model.UpdateHostedZoneCommentResult;
import com.amazonaws.services.route53.model.UpdateTrafficPolicyCommentRequest;
import com.amazonaws.services.route53.model.UpdateTrafficPolicyCommentResult;
import com.amazonaws.services.route53.model.UpdateTrafficPolicyInstanceRequest;
import com.amazonaws.services.route53.model.UpdateTrafficPolicyInstanceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonRoute53AsyncClient
extends AmazonRoute53Client
implements AmazonRoute53Async {
    private final ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AmazonRoute53AsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonRoute53AsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonRoute53AsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonRoute53AsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonRoute53AsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonRoute53AsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonRoute53AsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonRoute53AsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonRoute53AsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<GetTrafficPolicyInstanceResult> getTrafficPolicyInstanceAsync(final GetTrafficPolicyInstanceRequest getTrafficPolicyInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetTrafficPolicyInstanceResult>(){

            @Override
            public GetTrafficPolicyInstanceResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.getTrafficPolicyInstance(getTrafficPolicyInstanceRequest);
            }
        });
    }

    @Override
    public Future<GetTrafficPolicyInstanceResult> getTrafficPolicyInstanceAsync(final GetTrafficPolicyInstanceRequest getTrafficPolicyInstanceRequest, final AsyncHandler<GetTrafficPolicyInstanceRequest, GetTrafficPolicyInstanceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetTrafficPolicyInstanceResult>(){

            @Override
            public GetTrafficPolicyInstanceResult call() throws Exception {
                GetTrafficPolicyInstanceResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getTrafficPolicyInstance(getTrafficPolicyInstanceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getTrafficPolicyInstanceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateTrafficPolicyResult> createTrafficPolicyAsync(final CreateTrafficPolicyRequest createTrafficPolicyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateTrafficPolicyResult>(){

            @Override
            public CreateTrafficPolicyResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.createTrafficPolicy(createTrafficPolicyRequest);
            }
        });
    }

    @Override
    public Future<CreateTrafficPolicyResult> createTrafficPolicyAsync(final CreateTrafficPolicyRequest createTrafficPolicyRequest, final AsyncHandler<CreateTrafficPolicyRequest, CreateTrafficPolicyResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateTrafficPolicyResult>(){

            @Override
            public CreateTrafficPolicyResult call() throws Exception {
                CreateTrafficPolicyResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.createTrafficPolicy(createTrafficPolicyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createTrafficPolicyRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateTrafficPolicyCommentResult> updateTrafficPolicyCommentAsync(final UpdateTrafficPolicyCommentRequest updateTrafficPolicyCommentRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateTrafficPolicyCommentResult>(){

            @Override
            public UpdateTrafficPolicyCommentResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.updateTrafficPolicyComment(updateTrafficPolicyCommentRequest);
            }
        });
    }

    @Override
    public Future<UpdateTrafficPolicyCommentResult> updateTrafficPolicyCommentAsync(final UpdateTrafficPolicyCommentRequest updateTrafficPolicyCommentRequest, final AsyncHandler<UpdateTrafficPolicyCommentRequest, UpdateTrafficPolicyCommentResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateTrafficPolicyCommentResult>(){

            @Override
            public UpdateTrafficPolicyCommentResult call() throws Exception {
                UpdateTrafficPolicyCommentResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.updateTrafficPolicyComment(updateTrafficPolicyCommentRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateTrafficPolicyCommentRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetHostedZoneResult> getHostedZoneAsync(final GetHostedZoneRequest getHostedZoneRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetHostedZoneResult>(){

            @Override
            public GetHostedZoneResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.getHostedZone(getHostedZoneRequest);
            }
        });
    }

    @Override
    public Future<GetHostedZoneResult> getHostedZoneAsync(final GetHostedZoneRequest getHostedZoneRequest, final AsyncHandler<GetHostedZoneRequest, GetHostedZoneResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetHostedZoneResult>(){

            @Override
            public GetHostedZoneResult call() throws Exception {
                GetHostedZoneResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getHostedZone(getHostedZoneRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getHostedZoneRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetChangeResult> getChangeAsync(final GetChangeRequest getChangeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetChangeResult>(){

            @Override
            public GetChangeResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.getChange(getChangeRequest);
            }
        });
    }

    @Override
    public Future<GetChangeResult> getChangeAsync(final GetChangeRequest getChangeRequest, final AsyncHandler<GetChangeRequest, GetChangeResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetChangeResult>(){

            @Override
            public GetChangeResult call() throws Exception {
                GetChangeResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getChange(getChangeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getChangeRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateTrafficPolicyInstanceResult> updateTrafficPolicyInstanceAsync(final UpdateTrafficPolicyInstanceRequest updateTrafficPolicyInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateTrafficPolicyInstanceResult>(){

            @Override
            public UpdateTrafficPolicyInstanceResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.updateTrafficPolicyInstance(updateTrafficPolicyInstanceRequest);
            }
        });
    }

    @Override
    public Future<UpdateTrafficPolicyInstanceResult> updateTrafficPolicyInstanceAsync(final UpdateTrafficPolicyInstanceRequest updateTrafficPolicyInstanceRequest, final AsyncHandler<UpdateTrafficPolicyInstanceRequest, UpdateTrafficPolicyInstanceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateTrafficPolicyInstanceResult>(){

            @Override
            public UpdateTrafficPolicyInstanceResult call() throws Exception {
                UpdateTrafficPolicyInstanceResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.updateTrafficPolicyInstance(updateTrafficPolicyInstanceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateTrafficPolicyInstanceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetGeoLocationResult> getGeoLocationAsync(final GetGeoLocationRequest getGeoLocationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetGeoLocationResult>(){

            @Override
            public GetGeoLocationResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.getGeoLocation(getGeoLocationRequest);
            }
        });
    }

    @Override
    public Future<GetGeoLocationResult> getGeoLocationAsync(final GetGeoLocationRequest getGeoLocationRequest, final AsyncHandler<GetGeoLocationRequest, GetGeoLocationResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetGeoLocationResult>(){

            @Override
            public GetGeoLocationResult call() throws Exception {
                GetGeoLocationResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getGeoLocation(getGeoLocationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getGeoLocationRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateHostedZoneCommentResult> updateHostedZoneCommentAsync(final UpdateHostedZoneCommentRequest updateHostedZoneCommentRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateHostedZoneCommentResult>(){

            @Override
            public UpdateHostedZoneCommentResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.updateHostedZoneComment(updateHostedZoneCommentRequest);
            }
        });
    }

    @Override
    public Future<UpdateHostedZoneCommentResult> updateHostedZoneCommentAsync(final UpdateHostedZoneCommentRequest updateHostedZoneCommentRequest, final AsyncHandler<UpdateHostedZoneCommentRequest, UpdateHostedZoneCommentResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateHostedZoneCommentResult>(){

            @Override
            public UpdateHostedZoneCommentResult call() throws Exception {
                UpdateHostedZoneCommentResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.updateHostedZoneComment(updateHostedZoneCommentRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateHostedZoneCommentRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListTrafficPolicyVersionsResult> listTrafficPolicyVersionsAsync(final ListTrafficPolicyVersionsRequest listTrafficPolicyVersionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTrafficPolicyVersionsResult>(){

            @Override
            public ListTrafficPolicyVersionsResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.listTrafficPolicyVersions(listTrafficPolicyVersionsRequest);
            }
        });
    }

    @Override
    public Future<ListTrafficPolicyVersionsResult> listTrafficPolicyVersionsAsync(final ListTrafficPolicyVersionsRequest listTrafficPolicyVersionsRequest, final AsyncHandler<ListTrafficPolicyVersionsRequest, ListTrafficPolicyVersionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTrafficPolicyVersionsResult>(){

            @Override
            public ListTrafficPolicyVersionsResult call() throws Exception {
                ListTrafficPolicyVersionsResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listTrafficPolicyVersions(listTrafficPolicyVersionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listTrafficPolicyVersionsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteHealthCheckResult> deleteHealthCheckAsync(final DeleteHealthCheckRequest deleteHealthCheckRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteHealthCheckResult>(){

            @Override
            public DeleteHealthCheckResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.deleteHealthCheck(deleteHealthCheckRequest);
            }
        });
    }

    @Override
    public Future<DeleteHealthCheckResult> deleteHealthCheckAsync(final DeleteHealthCheckRequest deleteHealthCheckRequest, final AsyncHandler<DeleteHealthCheckRequest, DeleteHealthCheckResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteHealthCheckResult>(){

            @Override
            public DeleteHealthCheckResult call() throws Exception {
                DeleteHealthCheckResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.deleteHealthCheck(deleteHealthCheckRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteHealthCheckRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourcesResult> listTagsForResourcesAsync(final ListTagsForResourcesRequest listTagsForResourcesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTagsForResourcesResult>(){

            @Override
            public ListTagsForResourcesResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.listTagsForResources(listTagsForResourcesRequest);
            }
        });
    }

    @Override
    public Future<ListTagsForResourcesResult> listTagsForResourcesAsync(final ListTagsForResourcesRequest listTagsForResourcesRequest, final AsyncHandler<ListTagsForResourcesRequest, ListTagsForResourcesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTagsForResourcesResult>(){

            @Override
            public ListTagsForResourcesResult call() throws Exception {
                ListTagsForResourcesResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listTagsForResources(listTagsForResourcesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listTagsForResourcesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListResourceRecordSetsResult> listResourceRecordSetsAsync(final ListResourceRecordSetsRequest listResourceRecordSetsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListResourceRecordSetsResult>(){

            @Override
            public ListResourceRecordSetsResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.listResourceRecordSets(listResourceRecordSetsRequest);
            }
        });
    }

    @Override
    public Future<ListResourceRecordSetsResult> listResourceRecordSetsAsync(final ListResourceRecordSetsRequest listResourceRecordSetsRequest, final AsyncHandler<ListResourceRecordSetsRequest, ListResourceRecordSetsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListResourceRecordSetsResult>(){

            @Override
            public ListResourceRecordSetsResult call() throws Exception {
                ListResourceRecordSetsResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listResourceRecordSets(listResourceRecordSetsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listResourceRecordSetsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTrafficPolicyInstanceResult> deleteTrafficPolicyInstanceAsync(final DeleteTrafficPolicyInstanceRequest deleteTrafficPolicyInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteTrafficPolicyInstanceResult>(){

            @Override
            public DeleteTrafficPolicyInstanceResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.deleteTrafficPolicyInstance(deleteTrafficPolicyInstanceRequest);
            }
        });
    }

    @Override
    public Future<DeleteTrafficPolicyInstanceResult> deleteTrafficPolicyInstanceAsync(final DeleteTrafficPolicyInstanceRequest deleteTrafficPolicyInstanceRequest, final AsyncHandler<DeleteTrafficPolicyInstanceRequest, DeleteTrafficPolicyInstanceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteTrafficPolicyInstanceResult>(){

            @Override
            public DeleteTrafficPolicyInstanceResult call() throws Exception {
                DeleteTrafficPolicyInstanceResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.deleteTrafficPolicyInstance(deleteTrafficPolicyInstanceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteTrafficPolicyInstanceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListTrafficPolicyInstancesByHostedZoneResult> listTrafficPolicyInstancesByHostedZoneAsync(final ListTrafficPolicyInstancesByHostedZoneRequest listTrafficPolicyInstancesByHostedZoneRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTrafficPolicyInstancesByHostedZoneResult>(){

            @Override
            public ListTrafficPolicyInstancesByHostedZoneResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.listTrafficPolicyInstancesByHostedZone(listTrafficPolicyInstancesByHostedZoneRequest);
            }
        });
    }

    @Override
    public Future<ListTrafficPolicyInstancesByHostedZoneResult> listTrafficPolicyInstancesByHostedZoneAsync(final ListTrafficPolicyInstancesByHostedZoneRequest listTrafficPolicyInstancesByHostedZoneRequest, final AsyncHandler<ListTrafficPolicyInstancesByHostedZoneRequest, ListTrafficPolicyInstancesByHostedZoneResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTrafficPolicyInstancesByHostedZoneResult>(){

            @Override
            public ListTrafficPolicyInstancesByHostedZoneResult call() throws Exception {
                ListTrafficPolicyInstancesByHostedZoneResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listTrafficPolicyInstancesByHostedZone(listTrafficPolicyInstancesByHostedZoneRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listTrafficPolicyInstancesByHostedZoneRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteReusableDelegationSetResult> deleteReusableDelegationSetAsync(final DeleteReusableDelegationSetRequest deleteReusableDelegationSetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteReusableDelegationSetResult>(){

            @Override
            public DeleteReusableDelegationSetResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.deleteReusableDelegationSet(deleteReusableDelegationSetRequest);
            }
        });
    }

    @Override
    public Future<DeleteReusableDelegationSetResult> deleteReusableDelegationSetAsync(final DeleteReusableDelegationSetRequest deleteReusableDelegationSetRequest, final AsyncHandler<DeleteReusableDelegationSetRequest, DeleteReusableDelegationSetResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteReusableDelegationSetResult>(){

            @Override
            public DeleteReusableDelegationSetResult call() throws Exception {
                DeleteReusableDelegationSetResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.deleteReusableDelegationSet(deleteReusableDelegationSetRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteReusableDelegationSetRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetChangeDetailsResult> getChangeDetailsAsync(final GetChangeDetailsRequest getChangeDetailsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetChangeDetailsResult>(){

            @Override
            public GetChangeDetailsResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.getChangeDetails(getChangeDetailsRequest);
            }
        });
    }

    @Override
    public Future<GetChangeDetailsResult> getChangeDetailsAsync(final GetChangeDetailsRequest getChangeDetailsRequest, final AsyncHandler<GetChangeDetailsRequest, GetChangeDetailsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetChangeDetailsResult>(){

            @Override
            public GetChangeDetailsResult call() throws Exception {
                GetChangeDetailsResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getChangeDetails(getChangeDetailsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getChangeDetailsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetHealthCheckResult> getHealthCheckAsync(final GetHealthCheckRequest getHealthCheckRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetHealthCheckResult>(){

            @Override
            public GetHealthCheckResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.getHealthCheck(getHealthCheckRequest);
            }
        });
    }

    @Override
    public Future<GetHealthCheckResult> getHealthCheckAsync(final GetHealthCheckRequest getHealthCheckRequest, final AsyncHandler<GetHealthCheckRequest, GetHealthCheckResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetHealthCheckResult>(){

            @Override
            public GetHealthCheckResult call() throws Exception {
                GetHealthCheckResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getHealthCheck(getHealthCheckRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getHealthCheckRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateReusableDelegationSetResult> createReusableDelegationSetAsync(final CreateReusableDelegationSetRequest createReusableDelegationSetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateReusableDelegationSetResult>(){

            @Override
            public CreateReusableDelegationSetResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.createReusableDelegationSet(createReusableDelegationSetRequest);
            }
        });
    }

    @Override
    public Future<CreateReusableDelegationSetResult> createReusableDelegationSetAsync(final CreateReusableDelegationSetRequest createReusableDelegationSetRequest, final AsyncHandler<CreateReusableDelegationSetRequest, CreateReusableDelegationSetResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateReusableDelegationSetResult>(){

            @Override
            public CreateReusableDelegationSetResult call() throws Exception {
                CreateReusableDelegationSetResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.createReusableDelegationSet(createReusableDelegationSetRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createReusableDelegationSetRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetCheckerIpRangesResult> getCheckerIpRangesAsync(final GetCheckerIpRangesRequest getCheckerIpRangesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetCheckerIpRangesResult>(){

            @Override
            public GetCheckerIpRangesResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.getCheckerIpRanges(getCheckerIpRangesRequest);
            }
        });
    }

    @Override
    public Future<GetCheckerIpRangesResult> getCheckerIpRangesAsync(final GetCheckerIpRangesRequest getCheckerIpRangesRequest, final AsyncHandler<GetCheckerIpRangesRequest, GetCheckerIpRangesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetCheckerIpRangesResult>(){

            @Override
            public GetCheckerIpRangesResult call() throws Exception {
                GetCheckerIpRangesResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getCheckerIpRanges(getCheckerIpRangesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getCheckerIpRangesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateVPCFromHostedZoneResult> disassociateVPCFromHostedZoneAsync(final DisassociateVPCFromHostedZoneRequest disassociateVPCFromHostedZoneRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DisassociateVPCFromHostedZoneResult>(){

            @Override
            public DisassociateVPCFromHostedZoneResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.disassociateVPCFromHostedZone(disassociateVPCFromHostedZoneRequest);
            }
        });
    }

    @Override
    public Future<DisassociateVPCFromHostedZoneResult> disassociateVPCFromHostedZoneAsync(final DisassociateVPCFromHostedZoneRequest disassociateVPCFromHostedZoneRequest, final AsyncHandler<DisassociateVPCFromHostedZoneRequest, DisassociateVPCFromHostedZoneResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DisassociateVPCFromHostedZoneResult>(){

            @Override
            public DisassociateVPCFromHostedZoneResult call() throws Exception {
                DisassociateVPCFromHostedZoneResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.disassociateVPCFromHostedZone(disassociateVPCFromHostedZoneRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(disassociateVPCFromHostedZoneRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListChangeBatchesByRRSetResult> listChangeBatchesByRRSetAsync(final ListChangeBatchesByRRSetRequest listChangeBatchesByRRSetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListChangeBatchesByRRSetResult>(){

            @Override
            public ListChangeBatchesByRRSetResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.listChangeBatchesByRRSet(listChangeBatchesByRRSetRequest);
            }
        });
    }

    @Override
    public Future<ListChangeBatchesByRRSetResult> listChangeBatchesByRRSetAsync(final ListChangeBatchesByRRSetRequest listChangeBatchesByRRSetRequest, final AsyncHandler<ListChangeBatchesByRRSetRequest, ListChangeBatchesByRRSetResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListChangeBatchesByRRSetResult>(){

            @Override
            public ListChangeBatchesByRRSetResult call() throws Exception {
                ListChangeBatchesByRRSetResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listChangeBatchesByRRSet(listChangeBatchesByRRSetRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listChangeBatchesByRRSetRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetHealthCheckLastFailureReasonResult> getHealthCheckLastFailureReasonAsync(final GetHealthCheckLastFailureReasonRequest getHealthCheckLastFailureReasonRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetHealthCheckLastFailureReasonResult>(){

            @Override
            public GetHealthCheckLastFailureReasonResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.getHealthCheckLastFailureReason(getHealthCheckLastFailureReasonRequest);
            }
        });
    }

    @Override
    public Future<GetHealthCheckLastFailureReasonResult> getHealthCheckLastFailureReasonAsync(final GetHealthCheckLastFailureReasonRequest getHealthCheckLastFailureReasonRequest, final AsyncHandler<GetHealthCheckLastFailureReasonRequest, GetHealthCheckLastFailureReasonResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetHealthCheckLastFailureReasonResult>(){

            @Override
            public GetHealthCheckLastFailureReasonResult call() throws Exception {
                GetHealthCheckLastFailureReasonResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getHealthCheckLastFailureReason(getHealthCheckLastFailureReasonRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getHealthCheckLastFailureReasonRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListHealthChecksResult> listHealthChecksAsync(final ListHealthChecksRequest listHealthChecksRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListHealthChecksResult>(){

            @Override
            public ListHealthChecksResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.listHealthChecks(listHealthChecksRequest);
            }
        });
    }

    @Override
    public Future<ListHealthChecksResult> listHealthChecksAsync(final ListHealthChecksRequest listHealthChecksRequest, final AsyncHandler<ListHealthChecksRequest, ListHealthChecksResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListHealthChecksResult>(){

            @Override
            public ListHealthChecksResult call() throws Exception {
                ListHealthChecksResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listHealthChecks(listHealthChecksRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listHealthChecksRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListGeoLocationsResult> listGeoLocationsAsync(final ListGeoLocationsRequest listGeoLocationsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListGeoLocationsResult>(){

            @Override
            public ListGeoLocationsResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.listGeoLocations(listGeoLocationsRequest);
            }
        });
    }

    @Override
    public Future<ListGeoLocationsResult> listGeoLocationsAsync(final ListGeoLocationsRequest listGeoLocationsRequest, final AsyncHandler<ListGeoLocationsRequest, ListGeoLocationsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListGeoLocationsResult>(){

            @Override
            public ListGeoLocationsResult call() throws Exception {
                ListGeoLocationsResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listGeoLocations(listGeoLocationsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listGeoLocationsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateHealthCheckResult> createHealthCheckAsync(final CreateHealthCheckRequest createHealthCheckRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateHealthCheckResult>(){

            @Override
            public CreateHealthCheckResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.createHealthCheck(createHealthCheckRequest);
            }
        });
    }

    @Override
    public Future<CreateHealthCheckResult> createHealthCheckAsync(final CreateHealthCheckRequest createHealthCheckRequest, final AsyncHandler<CreateHealthCheckRequest, CreateHealthCheckResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateHealthCheckResult>(){

            @Override
            public CreateHealthCheckResult call() throws Exception {
                CreateHealthCheckResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.createHealthCheck(createHealthCheckRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createHealthCheckRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetHealthCheckCountResult> getHealthCheckCountAsync(final GetHealthCheckCountRequest getHealthCheckCountRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetHealthCheckCountResult>(){

            @Override
            public GetHealthCheckCountResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.getHealthCheckCount(getHealthCheckCountRequest);
            }
        });
    }

    @Override
    public Future<GetHealthCheckCountResult> getHealthCheckCountAsync(final GetHealthCheckCountRequest getHealthCheckCountRequest, final AsyncHandler<GetHealthCheckCountRequest, GetHealthCheckCountResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetHealthCheckCountResult>(){

            @Override
            public GetHealthCheckCountResult call() throws Exception {
                GetHealthCheckCountResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getHealthCheckCount(getHealthCheckCountRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getHealthCheckCountRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ChangeTagsForResourceResult> changeTagsForResourceAsync(final ChangeTagsForResourceRequest changeTagsForResourceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ChangeTagsForResourceResult>(){

            @Override
            public ChangeTagsForResourceResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.changeTagsForResource(changeTagsForResourceRequest);
            }
        });
    }

    @Override
    public Future<ChangeTagsForResourceResult> changeTagsForResourceAsync(final ChangeTagsForResourceRequest changeTagsForResourceRequest, final AsyncHandler<ChangeTagsForResourceRequest, ChangeTagsForResourceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ChangeTagsForResourceResult>(){

            @Override
            public ChangeTagsForResourceResult call() throws Exception {
                ChangeTagsForResourceResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.changeTagsForResource(changeTagsForResourceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(changeTagsForResourceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateTrafficPolicyInstanceResult> createTrafficPolicyInstanceAsync(final CreateTrafficPolicyInstanceRequest createTrafficPolicyInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateTrafficPolicyInstanceResult>(){

            @Override
            public CreateTrafficPolicyInstanceResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.createTrafficPolicyInstance(createTrafficPolicyInstanceRequest);
            }
        });
    }

    @Override
    public Future<CreateTrafficPolicyInstanceResult> createTrafficPolicyInstanceAsync(final CreateTrafficPolicyInstanceRequest createTrafficPolicyInstanceRequest, final AsyncHandler<CreateTrafficPolicyInstanceRequest, CreateTrafficPolicyInstanceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateTrafficPolicyInstanceResult>(){

            @Override
            public CreateTrafficPolicyInstanceResult call() throws Exception {
                CreateTrafficPolicyInstanceResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.createTrafficPolicyInstance(createTrafficPolicyInstanceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createTrafficPolicyInstanceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListTrafficPolicyInstancesResult> listTrafficPolicyInstancesAsync(final ListTrafficPolicyInstancesRequest listTrafficPolicyInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTrafficPolicyInstancesResult>(){

            @Override
            public ListTrafficPolicyInstancesResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.listTrafficPolicyInstances(listTrafficPolicyInstancesRequest);
            }
        });
    }

    @Override
    public Future<ListTrafficPolicyInstancesResult> listTrafficPolicyInstancesAsync(final ListTrafficPolicyInstancesRequest listTrafficPolicyInstancesRequest, final AsyncHandler<ListTrafficPolicyInstancesRequest, ListTrafficPolicyInstancesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTrafficPolicyInstancesResult>(){

            @Override
            public ListTrafficPolicyInstancesResult call() throws Exception {
                ListTrafficPolicyInstancesResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listTrafficPolicyInstances(listTrafficPolicyInstancesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listTrafficPolicyInstancesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListTrafficPoliciesResult> listTrafficPoliciesAsync(final ListTrafficPoliciesRequest listTrafficPoliciesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTrafficPoliciesResult>(){

            @Override
            public ListTrafficPoliciesResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.listTrafficPolicies(listTrafficPoliciesRequest);
            }
        });
    }

    @Override
    public Future<ListTrafficPoliciesResult> listTrafficPoliciesAsync(final ListTrafficPoliciesRequest listTrafficPoliciesRequest, final AsyncHandler<ListTrafficPoliciesRequest, ListTrafficPoliciesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTrafficPoliciesResult>(){

            @Override
            public ListTrafficPoliciesResult call() throws Exception {
                ListTrafficPoliciesResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listTrafficPolicies(listTrafficPoliciesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listTrafficPoliciesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetHealthCheckStatusResult> getHealthCheckStatusAsync(final GetHealthCheckStatusRequest getHealthCheckStatusRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetHealthCheckStatusResult>(){

            @Override
            public GetHealthCheckStatusResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.getHealthCheckStatus(getHealthCheckStatusRequest);
            }
        });
    }

    @Override
    public Future<GetHealthCheckStatusResult> getHealthCheckStatusAsync(final GetHealthCheckStatusRequest getHealthCheckStatusRequest, final AsyncHandler<GetHealthCheckStatusRequest, GetHealthCheckStatusResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetHealthCheckStatusResult>(){

            @Override
            public GetHealthCheckStatusResult call() throws Exception {
                GetHealthCheckStatusResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getHealthCheckStatus(getHealthCheckStatusRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getHealthCheckStatusRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListHostedZonesResult> listHostedZonesAsync(final ListHostedZonesRequest listHostedZonesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListHostedZonesResult>(){

            @Override
            public ListHostedZonesResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.listHostedZones(listHostedZonesRequest);
            }
        });
    }

    @Override
    public Future<ListHostedZonesResult> listHostedZonesAsync(final ListHostedZonesRequest listHostedZonesRequest, final AsyncHandler<ListHostedZonesRequest, ListHostedZonesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListHostedZonesResult>(){

            @Override
            public ListHostedZonesResult call() throws Exception {
                ListHostedZonesResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listHostedZones(listHostedZonesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listHostedZonesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetHostedZoneCountResult> getHostedZoneCountAsync(final GetHostedZoneCountRequest getHostedZoneCountRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetHostedZoneCountResult>(){

            @Override
            public GetHostedZoneCountResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.getHostedZoneCount(getHostedZoneCountRequest);
            }
        });
    }

    @Override
    public Future<GetHostedZoneCountResult> getHostedZoneCountAsync(final GetHostedZoneCountRequest getHostedZoneCountRequest, final AsyncHandler<GetHostedZoneCountRequest, GetHostedZoneCountResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetHostedZoneCountResult>(){

            @Override
            public GetHostedZoneCountResult call() throws Exception {
                GetHostedZoneCountResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getHostedZoneCount(getHostedZoneCountRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getHostedZoneCountRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateHealthCheckResult> updateHealthCheckAsync(final UpdateHealthCheckRequest updateHealthCheckRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateHealthCheckResult>(){

            @Override
            public UpdateHealthCheckResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.updateHealthCheck(updateHealthCheckRequest);
            }
        });
    }

    @Override
    public Future<UpdateHealthCheckResult> updateHealthCheckAsync(final UpdateHealthCheckRequest updateHealthCheckRequest, final AsyncHandler<UpdateHealthCheckRequest, UpdateHealthCheckResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateHealthCheckResult>(){

            @Override
            public UpdateHealthCheckResult call() throws Exception {
                UpdateHealthCheckResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.updateHealthCheck(updateHealthCheckRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateHealthCheckRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetReusableDelegationSetResult> getReusableDelegationSetAsync(final GetReusableDelegationSetRequest getReusableDelegationSetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetReusableDelegationSetResult>(){

            @Override
            public GetReusableDelegationSetResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.getReusableDelegationSet(getReusableDelegationSetRequest);
            }
        });
    }

    @Override
    public Future<GetReusableDelegationSetResult> getReusableDelegationSetAsync(final GetReusableDelegationSetRequest getReusableDelegationSetRequest, final AsyncHandler<GetReusableDelegationSetRequest, GetReusableDelegationSetResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetReusableDelegationSetResult>(){

            @Override
            public GetReusableDelegationSetResult call() throws Exception {
                GetReusableDelegationSetResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getReusableDelegationSet(getReusableDelegationSetRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getReusableDelegationSetRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListHostedZonesByNameResult> listHostedZonesByNameAsync(final ListHostedZonesByNameRequest listHostedZonesByNameRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListHostedZonesByNameResult>(){

            @Override
            public ListHostedZonesByNameResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.listHostedZonesByName(listHostedZonesByNameRequest);
            }
        });
    }

    @Override
    public Future<ListHostedZonesByNameResult> listHostedZonesByNameAsync(final ListHostedZonesByNameRequest listHostedZonesByNameRequest, final AsyncHandler<ListHostedZonesByNameRequest, ListHostedZonesByNameResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListHostedZonesByNameResult>(){

            @Override
            public ListHostedZonesByNameResult call() throws Exception {
                ListHostedZonesByNameResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listHostedZonesByName(listHostedZonesByNameRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listHostedZonesByNameRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetTrafficPolicyResult> getTrafficPolicyAsync(final GetTrafficPolicyRequest getTrafficPolicyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetTrafficPolicyResult>(){

            @Override
            public GetTrafficPolicyResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.getTrafficPolicy(getTrafficPolicyRequest);
            }
        });
    }

    @Override
    public Future<GetTrafficPolicyResult> getTrafficPolicyAsync(final GetTrafficPolicyRequest getTrafficPolicyRequest, final AsyncHandler<GetTrafficPolicyRequest, GetTrafficPolicyResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetTrafficPolicyResult>(){

            @Override
            public GetTrafficPolicyResult call() throws Exception {
                GetTrafficPolicyResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getTrafficPolicy(getTrafficPolicyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getTrafficPolicyRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTrafficPolicyResult> deleteTrafficPolicyAsync(final DeleteTrafficPolicyRequest deleteTrafficPolicyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteTrafficPolicyResult>(){

            @Override
            public DeleteTrafficPolicyResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.deleteTrafficPolicy(deleteTrafficPolicyRequest);
            }
        });
    }

    @Override
    public Future<DeleteTrafficPolicyResult> deleteTrafficPolicyAsync(final DeleteTrafficPolicyRequest deleteTrafficPolicyRequest, final AsyncHandler<DeleteTrafficPolicyRequest, DeleteTrafficPolicyResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteTrafficPolicyResult>(){

            @Override
            public DeleteTrafficPolicyResult call() throws Exception {
                DeleteTrafficPolicyResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.deleteTrafficPolicy(deleteTrafficPolicyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteTrafficPolicyRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetTrafficPolicyInstanceCountResult> getTrafficPolicyInstanceCountAsync(final GetTrafficPolicyInstanceCountRequest getTrafficPolicyInstanceCountRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetTrafficPolicyInstanceCountResult>(){

            @Override
            public GetTrafficPolicyInstanceCountResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.getTrafficPolicyInstanceCount(getTrafficPolicyInstanceCountRequest);
            }
        });
    }

    @Override
    public Future<GetTrafficPolicyInstanceCountResult> getTrafficPolicyInstanceCountAsync(final GetTrafficPolicyInstanceCountRequest getTrafficPolicyInstanceCountRequest, final AsyncHandler<GetTrafficPolicyInstanceCountRequest, GetTrafficPolicyInstanceCountResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetTrafficPolicyInstanceCountResult>(){

            @Override
            public GetTrafficPolicyInstanceCountResult call() throws Exception {
                GetTrafficPolicyInstanceCountResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getTrafficPolicyInstanceCount(getTrafficPolicyInstanceCountRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getTrafficPolicyInstanceCountRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteHostedZoneResult> deleteHostedZoneAsync(final DeleteHostedZoneRequest deleteHostedZoneRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteHostedZoneResult>(){

            @Override
            public DeleteHostedZoneResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.deleteHostedZone(deleteHostedZoneRequest);
            }
        });
    }

    @Override
    public Future<DeleteHostedZoneResult> deleteHostedZoneAsync(final DeleteHostedZoneRequest deleteHostedZoneRequest, final AsyncHandler<DeleteHostedZoneRequest, DeleteHostedZoneResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteHostedZoneResult>(){

            @Override
            public DeleteHostedZoneResult call() throws Exception {
                DeleteHostedZoneResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.deleteHostedZone(deleteHostedZoneRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteHostedZoneRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateHostedZoneResult> createHostedZoneAsync(final CreateHostedZoneRequest createHostedZoneRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateHostedZoneResult>(){

            @Override
            public CreateHostedZoneResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.createHostedZone(createHostedZoneRequest);
            }
        });
    }

    @Override
    public Future<CreateHostedZoneResult> createHostedZoneAsync(final CreateHostedZoneRequest createHostedZoneRequest, final AsyncHandler<CreateHostedZoneRequest, CreateHostedZoneResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateHostedZoneResult>(){

            @Override
            public CreateHostedZoneResult call() throws Exception {
                CreateHostedZoneResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.createHostedZone(createHostedZoneRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createHostedZoneRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<AssociateVPCWithHostedZoneResult> associateVPCWithHostedZoneAsync(final AssociateVPCWithHostedZoneRequest associateVPCWithHostedZoneRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AssociateVPCWithHostedZoneResult>(){

            @Override
            public AssociateVPCWithHostedZoneResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.associateVPCWithHostedZone(associateVPCWithHostedZoneRequest);
            }
        });
    }

    @Override
    public Future<AssociateVPCWithHostedZoneResult> associateVPCWithHostedZoneAsync(final AssociateVPCWithHostedZoneRequest associateVPCWithHostedZoneRequest, final AsyncHandler<AssociateVPCWithHostedZoneRequest, AssociateVPCWithHostedZoneResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AssociateVPCWithHostedZoneResult>(){

            @Override
            public AssociateVPCWithHostedZoneResult call() throws Exception {
                AssociateVPCWithHostedZoneResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.associateVPCWithHostedZone(associateVPCWithHostedZoneRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(associateVPCWithHostedZoneRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(final ListTagsForResourceRequest listTagsForResourceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.listTagsForResource(listTagsForResourceRequest);
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(final ListTagsForResourceRequest listTagsForResourceRequest, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listTagsForResource(listTagsForResourceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listTagsForResourceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListReusableDelegationSetsResult> listReusableDelegationSetsAsync(final ListReusableDelegationSetsRequest listReusableDelegationSetsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListReusableDelegationSetsResult>(){

            @Override
            public ListReusableDelegationSetsResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.listReusableDelegationSets(listReusableDelegationSetsRequest);
            }
        });
    }

    @Override
    public Future<ListReusableDelegationSetsResult> listReusableDelegationSetsAsync(final ListReusableDelegationSetsRequest listReusableDelegationSetsRequest, final AsyncHandler<ListReusableDelegationSetsRequest, ListReusableDelegationSetsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListReusableDelegationSetsResult>(){

            @Override
            public ListReusableDelegationSetsResult call() throws Exception {
                ListReusableDelegationSetsResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listReusableDelegationSets(listReusableDelegationSetsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listReusableDelegationSetsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListChangeBatchesByHostedZoneResult> listChangeBatchesByHostedZoneAsync(final ListChangeBatchesByHostedZoneRequest listChangeBatchesByHostedZoneRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListChangeBatchesByHostedZoneResult>(){

            @Override
            public ListChangeBatchesByHostedZoneResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.listChangeBatchesByHostedZone(listChangeBatchesByHostedZoneRequest);
            }
        });
    }

    @Override
    public Future<ListChangeBatchesByHostedZoneResult> listChangeBatchesByHostedZoneAsync(final ListChangeBatchesByHostedZoneRequest listChangeBatchesByHostedZoneRequest, final AsyncHandler<ListChangeBatchesByHostedZoneRequest, ListChangeBatchesByHostedZoneResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListChangeBatchesByHostedZoneResult>(){

            @Override
            public ListChangeBatchesByHostedZoneResult call() throws Exception {
                ListChangeBatchesByHostedZoneResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listChangeBatchesByHostedZone(listChangeBatchesByHostedZoneRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listChangeBatchesByHostedZoneRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ChangeResourceRecordSetsResult> changeResourceRecordSetsAsync(final ChangeResourceRecordSetsRequest changeResourceRecordSetsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ChangeResourceRecordSetsResult>(){

            @Override
            public ChangeResourceRecordSetsResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.changeResourceRecordSets(changeResourceRecordSetsRequest);
            }
        });
    }

    @Override
    public Future<ChangeResourceRecordSetsResult> changeResourceRecordSetsAsync(final ChangeResourceRecordSetsRequest changeResourceRecordSetsRequest, final AsyncHandler<ChangeResourceRecordSetsRequest, ChangeResourceRecordSetsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ChangeResourceRecordSetsResult>(){

            @Override
            public ChangeResourceRecordSetsResult call() throws Exception {
                ChangeResourceRecordSetsResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.changeResourceRecordSets(changeResourceRecordSetsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(changeResourceRecordSetsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateTrafficPolicyVersionResult> createTrafficPolicyVersionAsync(final CreateTrafficPolicyVersionRequest createTrafficPolicyVersionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateTrafficPolicyVersionResult>(){

            @Override
            public CreateTrafficPolicyVersionResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.createTrafficPolicyVersion(createTrafficPolicyVersionRequest);
            }
        });
    }

    @Override
    public Future<CreateTrafficPolicyVersionResult> createTrafficPolicyVersionAsync(final CreateTrafficPolicyVersionRequest createTrafficPolicyVersionRequest, final AsyncHandler<CreateTrafficPolicyVersionRequest, CreateTrafficPolicyVersionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateTrafficPolicyVersionResult>(){

            @Override
            public CreateTrafficPolicyVersionResult call() throws Exception {
                CreateTrafficPolicyVersionResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.createTrafficPolicyVersion(createTrafficPolicyVersionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createTrafficPolicyVersionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListTrafficPolicyInstancesByPolicyResult> listTrafficPolicyInstancesByPolicyAsync(final ListTrafficPolicyInstancesByPolicyRequest listTrafficPolicyInstancesByPolicyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTrafficPolicyInstancesByPolicyResult>(){

            @Override
            public ListTrafficPolicyInstancesByPolicyResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.listTrafficPolicyInstancesByPolicy(listTrafficPolicyInstancesByPolicyRequest);
            }
        });
    }

    @Override
    public Future<ListTrafficPolicyInstancesByPolicyResult> listTrafficPolicyInstancesByPolicyAsync(final ListTrafficPolicyInstancesByPolicyRequest listTrafficPolicyInstancesByPolicyRequest, final AsyncHandler<ListTrafficPolicyInstancesByPolicyRequest, ListTrafficPolicyInstancesByPolicyResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTrafficPolicyInstancesByPolicyResult>(){

            @Override
            public ListTrafficPolicyInstancesByPolicyResult call() throws Exception {
                ListTrafficPolicyInstancesByPolicyResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listTrafficPolicyInstancesByPolicy(listTrafficPolicyInstancesByPolicyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listTrafficPolicyInstancesByPolicyRequest, result);
                return result;
            }
        });
    }
}

