/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.internal;

import com.amazonaws.internal.SdkDigestInputStream;
import com.amazonaws.internal.SdkFilterInputStream;
import com.amazonaws.services.glacier.TreeHashGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TreeHashInputStream
extends SdkFilterInputStream {
    private final DigestInputStream digestInputStream;
    private final List<byte[]> checksums = new ArrayList<byte[]>();
    private boolean closed = false;
    private int byteOffset = 0;
    private static final int MB = 0x100000;

    public TreeHashInputStream(InputStream in) throws NoSuchAlgorithmException {
        super(new SdkDigestInputStream(in, MessageDigest.getInstance("SHA-256")));
        this.digestInputStream = (DigestInputStream)this.in;
    }

    public List<byte[]> getChecksums() throws IOException {
        if (!this.closed) {
            throw new IOException("Stream must be closed before getting checksums");
        }
        return Collections.unmodifiableList(this.checksums);
    }

    public String getTreeHash() throws IOException {
        if (!this.closed) {
            throw new IOException("Stream must be closed before getting the tree hash");
        }
        return TreeHashGenerator.calculateTreeHash(this.getChecksums());
    }

    @Override
    public int read() throws IOException {
        int read = super.read();
        if (read >= 0) {
            ++this.byteOffset;
        }
        this.digestPart();
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int totalBytesRead = 0;
        int lastBytesRead = 0;
        while (totalBytesRead < len && lastBytesRead > -1) {
            int bytesToRead = Math.min(0x100000 - this.byteOffset, len - totalBytesRead);
            lastBytesRead = super.read(b, off + totalBytesRead, bytesToRead);
            if (lastBytesRead > 0) {
                totalBytesRead += lastBytesRead;
                this.byteOffset += lastBytesRead;
            }
            this.digestPart();
            if (lastBytesRead != -1 || totalBytesRead != 0) continue;
            return -1;
        }
        return totalBytesRead;
    }

    private void digestPart() {
        if (this.byteOffset >= 0x100000) {
            this.byteOffset = 0;
            this.checksums.add(this.digestInputStream.getMessageDigest().digest());
            this.digestInputStream.getMessageDigest().reset();
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.closed = true;
        if (this.byteOffset > 0) {
            this.checksums.add(this.digestInputStream.getMessageDigest().digest());
        }
    }
}

