/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchdomain.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudsearchdomain.model.Bucket;
import com.amazonaws.services.cloudsearchdomain.model.BucketInfo;
import com.amazonaws.services.cloudsearchdomain.model.transform.BucketJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class BucketInfoJsonMarshaller {
    private static BucketInfoJsonMarshaller instance;

    public void marshall(BucketInfo bucketInfo, JSONWriter jsonWriter) {
        if (bucketInfo == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            SdkInternalList bucketsList = (SdkInternalList)bucketInfo.getBuckets();
            if (!bucketsList.isEmpty() || !bucketsList.isAutoConstruct()) {
                jsonWriter.key("buckets");
                jsonWriter.array();
                for (Bucket bucketsListValue : bucketsList) {
                    if (bucketsListValue == null) continue;
                    BucketJsonMarshaller.getInstance().marshall(bucketsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static BucketInfoJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new BucketInfoJsonMarshaller();
        }
        return instance;
    }
}

