/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.PutIntegrationResponseRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.Map;

public class PutIntegrationResponseRequestMarshaller
implements Marshaller<Request<PutIntegrationResponseRequest>, PutIntegrationResponseRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<PutIntegrationResponseRequest> marshall(PutIntegrationResponseRequest putIntegrationResponseRequest) {
        if (putIntegrationResponseRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutIntegrationResponseRequest> request = new DefaultRequest<PutIntegrationResponseRequest>(putIntegrationResponseRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration/responses/{status_code}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", putIntegrationResponseRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(putIntegrationResponseRequest.getRestApiId()));
        uriResourcePath = uriResourcePath.replace("{resource_id}", putIntegrationResponseRequest.getResourceId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(putIntegrationResponseRequest.getResourceId()));
        uriResourcePath = uriResourcePath.replace("{http_method}", putIntegrationResponseRequest.getHttpMethod() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(putIntegrationResponseRequest.getHttpMethod()));
        uriResourcePath = uriResourcePath.replace("{status_code}", putIntegrationResponseRequest.getStatusCode() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(putIntegrationResponseRequest.getStatusCode()));
        request.setResourcePath(uriResourcePath);
        try {
            Map<String, String> responseTemplatesMap;
            Map<String, String> responseParametersMap;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (putIntegrationResponseRequest.getSelectionPattern() != null) {
                jsonWriter.key("selectionPattern").value(putIntegrationResponseRequest.getSelectionPattern());
            }
            if ((responseParametersMap = putIntegrationResponseRequest.getResponseParameters()) != null) {
                jsonWriter.key("responseParameters");
                jsonWriter.object();
                for (Map.Entry<String, String> responseParametersMapValue : responseParametersMap.entrySet()) {
                    if (responseParametersMapValue.getValue() == null) continue;
                    jsonWriter.key(responseParametersMapValue.getKey());
                    jsonWriter.value(responseParametersMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if ((responseTemplatesMap = putIntegrationResponseRequest.getResponseTemplates()) != null) {
                jsonWriter.key("responseTemplates");
                jsonWriter.object();
                for (Map.Entry<String, String> responseTemplatesMapValue : responseTemplatesMap.entrySet()) {
                    if (responseTemplatesMapValue.getValue() == null) continue;
                    jsonWriter.key(responseTemplatesMapValue.getKey());
                    jsonWriter.value(responseTemplatesMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

