/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model;

import java.io.Serializable;
import java.nio.ByteBuffer;

public class Record
implements Serializable,
Cloneable {
    private String sequenceNumber;
    private ByteBuffer data;
    private String partitionKey;

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public Record withSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
        return this;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public void setData(ByteBuffer data) {
        this.data = data;
    }

    public Record withData(ByteBuffer data) {
        this.data = data;
        return this;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    public Record withPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSequenceNumber() != null) {
            sb.append("SequenceNumber: " + this.getSequenceNumber() + ",");
        }
        if (this.getData() != null) {
            sb.append("Data: " + this.getData() + ",");
        }
        if (this.getPartitionKey() != null) {
            sb.append("PartitionKey: " + this.getPartitionKey());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSequenceNumber() == null ? 0 : this.getSequenceNumber().hashCode());
        hashCode = 31 * hashCode + (this.getData() == null ? 0 : this.getData().hashCode());
        hashCode = 31 * hashCode + (this.getPartitionKey() == null ? 0 : this.getPartitionKey().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Record)) {
            return false;
        }
        Record other = (Record)obj;
        if (other.getSequenceNumber() == null ^ this.getSequenceNumber() == null) {
            return false;
        }
        if (other.getSequenceNumber() != null && !other.getSequenceNumber().equals(this.getSequenceNumber())) {
            return false;
        }
        if (other.getData() == null ^ this.getData() == null) {
            return false;
        }
        if (other.getData() != null && !other.getData().equals(this.getData())) {
            return false;
        }
        if (other.getPartitionKey() == null ^ this.getPartitionKey() == null) {
            return false;
        }
        return other.getPartitionKey() == null || other.getPartitionKey().equals(this.getPartitionKey());
    }

    public Record clone() {
        try {
            return (Record)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

