/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListServicesResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<String> serviceArns;
    private String nextToken;

    public List<String> getServiceArns() {
        if (this.serviceArns == null) {
            this.serviceArns = new ListWithAutoConstructFlag();
            this.serviceArns.setAutoConstruct(true);
        }
        return this.serviceArns;
    }

    public void setServiceArns(Collection<String> serviceArns) {
        if (serviceArns == null) {
            this.serviceArns = null;
            return;
        }
        ListWithAutoConstructFlag serviceArnsCopy = new ListWithAutoConstructFlag(serviceArns.size());
        serviceArnsCopy.addAll(serviceArns);
        this.serviceArns = serviceArnsCopy;
    }

    public ListServicesResult withServiceArns(String ... serviceArns) {
        if (this.getServiceArns() == null) {
            this.setServiceArns(new ArrayList<String>(serviceArns.length));
        }
        for (String value : serviceArns) {
            this.getServiceArns().add(value);
        }
        return this;
    }

    public ListServicesResult withServiceArns(Collection<String> serviceArns) {
        if (serviceArns == null) {
            this.serviceArns = null;
        } else {
            ListWithAutoConstructFlag serviceArnsCopy = new ListWithAutoConstructFlag(serviceArns.size());
            serviceArnsCopy.addAll(serviceArns);
            this.serviceArns = serviceArnsCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListServicesResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServiceArns() != null) {
            sb.append("ServiceArns: " + this.getServiceArns() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServiceArns() == null ? 0 : this.getServiceArns().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServicesResult)) {
            return false;
        }
        ListServicesResult other = (ListServicesResult)obj;
        if (other.getServiceArns() == null ^ this.getServiceArns() == null) {
            return false;
        }
        if (other.getServiceArns() != null && !other.getServiceArns().equals(this.getServiceArns())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public ListServicesResult clone() {
        try {
            return (ListServicesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

