/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.service.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.service.codepipeline.model.Artifact;
import com.amazonaws.service.codepipeline.model.ThirdPartyJobData;
import com.amazonaws.service.codepipeline.model.transform.AWSSessionCredentialsJsonMarshaller;
import com.amazonaws.service.codepipeline.model.transform.ActionConfigurationJsonMarshaller;
import com.amazonaws.service.codepipeline.model.transform.ActionTypeIdJsonMarshaller;
import com.amazonaws.service.codepipeline.model.transform.ArtifactJsonMarshaller;
import com.amazonaws.service.codepipeline.model.transform.PipelineContextJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class ThirdPartyJobDataJsonMarshaller {
    private static ThirdPartyJobDataJsonMarshaller instance;

    public void marshall(ThirdPartyJobData thirdPartyJobData, JSONWriter jsonWriter) {
        if (thirdPartyJobData == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Artifact> outputArtifactsList;
            List<Artifact> inputArtifactsList;
            jsonWriter.object();
            if (thirdPartyJobData.getActionTypeId() != null) {
                jsonWriter.key("actionTypeId");
                ActionTypeIdJsonMarshaller.getInstance().marshall(thirdPartyJobData.getActionTypeId(), jsonWriter);
            }
            if (thirdPartyJobData.getActionConfiguration() != null) {
                jsonWriter.key("actionConfiguration");
                ActionConfigurationJsonMarshaller.getInstance().marshall(thirdPartyJobData.getActionConfiguration(), jsonWriter);
            }
            if (thirdPartyJobData.getPipelineContext() != null) {
                jsonWriter.key("pipelineContext");
                PipelineContextJsonMarshaller.getInstance().marshall(thirdPartyJobData.getPipelineContext(), jsonWriter);
            }
            if ((inputArtifactsList = thirdPartyJobData.getInputArtifacts()) != null) {
                jsonWriter.key("inputArtifacts");
                jsonWriter.array();
                for (Artifact inputArtifactsListValue : inputArtifactsList) {
                    if (inputArtifactsListValue == null) continue;
                    ArtifactJsonMarshaller.getInstance().marshall(inputArtifactsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if ((outputArtifactsList = thirdPartyJobData.getOutputArtifacts()) != null) {
                jsonWriter.key("outputArtifacts");
                jsonWriter.array();
                for (Artifact outputArtifactsListValue : outputArtifactsList) {
                    if (outputArtifactsListValue == null) continue;
                    ArtifactJsonMarshaller.getInstance().marshall(outputArtifactsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (thirdPartyJobData.getArtifactCredentials() != null) {
                jsonWriter.key("artifactCredentials");
                AWSSessionCredentialsJsonMarshaller.getInstance().marshall(thirdPartyJobData.getArtifactCredentials(), jsonWriter);
            }
            if (thirdPartyJobData.getContinuationToken() != null) {
                jsonWriter.key("continuationToken").value(thirdPartyJobData.getContinuationToken());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ThirdPartyJobDataJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ThirdPartyJobDataJsonMarshaller();
        }
        return instance;
    }
}

