/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.service.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.service.codepipeline.model.EnableStageTransitionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class EnableStageTransitionRequestMarshaller
implements Marshaller<Request<EnableStageTransitionRequest>, EnableStageTransitionRequest> {
    @Override
    public Request<EnableStageTransitionRequest> marshall(EnableStageTransitionRequest enableStageTransitionRequest) {
        if (enableStageTransitionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<EnableStageTransitionRequest> request = new DefaultRequest<EnableStageTransitionRequest>(enableStageTransitionRequest, "AWSCodePipeline");
        request.addHeader("X-Amz-Target", "CodePipeline_20150709.EnableStageTransition");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (enableStageTransitionRequest.getPipelineName() != null) {
                jsonWriter.key("pipelineName").value(enableStageTransitionRequest.getPipelineName());
            }
            if (enableStageTransitionRequest.getStageName() != null) {
                jsonWriter.key("stageName").value(enableStageTransitionRequest.getStageName());
            }
            if (enableStageTransitionRequest.getTransitionType() != null) {
                jsonWriter.key("transitionType").value(enableStageTransitionRequest.getTransitionType());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

