/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.service.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.service.codepipeline.model.ActionDeclaration;
import com.amazonaws.service.codepipeline.model.InputArtifact;
import com.amazonaws.service.codepipeline.model.OutputArtifact;
import com.amazonaws.service.codepipeline.model.transform.ActionTypeIdJsonMarshaller;
import com.amazonaws.service.codepipeline.model.transform.InputArtifactJsonMarshaller;
import com.amazonaws.service.codepipeline.model.transform.OutputArtifactJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;
import java.util.Map;

public class ActionDeclarationJsonMarshaller {
    private static ActionDeclarationJsonMarshaller instance;

    public void marshall(ActionDeclaration actionDeclaration, JSONWriter jsonWriter) {
        if (actionDeclaration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<InputArtifact> inputArtifactsList;
            List<OutputArtifact> outputArtifactsList;
            Map<String, String> configurationMap;
            jsonWriter.object();
            if (actionDeclaration.getName() != null) {
                jsonWriter.key("name").value(actionDeclaration.getName());
            }
            if (actionDeclaration.getActionTypeId() != null) {
                jsonWriter.key("actionTypeId");
                ActionTypeIdJsonMarshaller.getInstance().marshall(actionDeclaration.getActionTypeId(), jsonWriter);
            }
            if (actionDeclaration.getRunOrder() != null) {
                jsonWriter.key("runOrder").value(actionDeclaration.getRunOrder());
            }
            if ((configurationMap = actionDeclaration.getConfiguration()) != null) {
                jsonWriter.key("configuration");
                jsonWriter.object();
                for (Map.Entry<String, String> configurationMapValue : configurationMap.entrySet()) {
                    if (configurationMapValue.getValue() == null) continue;
                    jsonWriter.key(configurationMapValue.getKey());
                    jsonWriter.value(configurationMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if ((outputArtifactsList = actionDeclaration.getOutputArtifacts()) != null) {
                jsonWriter.key("outputArtifacts");
                jsonWriter.array();
                for (OutputArtifact outputArtifactsListValue : outputArtifactsList) {
                    if (outputArtifactsListValue == null) continue;
                    OutputArtifactJsonMarshaller.getInstance().marshall(outputArtifactsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if ((inputArtifactsList = actionDeclaration.getInputArtifacts()) != null) {
                jsonWriter.key("inputArtifacts");
                jsonWriter.array();
                for (InputArtifact inputArtifactsListValue : inputArtifactsList) {
                    if (inputArtifactsListValue == null) continue;
                    InputArtifactJsonMarshaller.getInstance().marshall(inputArtifactsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (actionDeclaration.getRoleArn() != null) {
                jsonWriter.key("roleArn").value(actionDeclaration.getRoleArn());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ActionDeclarationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ActionDeclarationJsonMarshaller();
        }
        return instance;
    }
}

