/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.service.codepipeline;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.service.codepipeline.AWSCodePipelineAsync;
import com.amazonaws.service.codepipeline.AWSCodePipelineClient;
import com.amazonaws.service.codepipeline.model.AcknowledgeJobRequest;
import com.amazonaws.service.codepipeline.model.AcknowledgeJobResult;
import com.amazonaws.service.codepipeline.model.AcknowledgeThirdPartyJobRequest;
import com.amazonaws.service.codepipeline.model.AcknowledgeThirdPartyJobResult;
import com.amazonaws.service.codepipeline.model.CreateCustomActionTypeRequest;
import com.amazonaws.service.codepipeline.model.CreateCustomActionTypeResult;
import com.amazonaws.service.codepipeline.model.CreatePipelineRequest;
import com.amazonaws.service.codepipeline.model.CreatePipelineResult;
import com.amazonaws.service.codepipeline.model.DeleteCustomActionTypeRequest;
import com.amazonaws.service.codepipeline.model.DeletePipelineRequest;
import com.amazonaws.service.codepipeline.model.DisableStageTransitionRequest;
import com.amazonaws.service.codepipeline.model.EnableStageTransitionRequest;
import com.amazonaws.service.codepipeline.model.GetJobDetailsRequest;
import com.amazonaws.service.codepipeline.model.GetJobDetailsResult;
import com.amazonaws.service.codepipeline.model.GetPipelineRequest;
import com.amazonaws.service.codepipeline.model.GetPipelineResult;
import com.amazonaws.service.codepipeline.model.GetPipelineStateRequest;
import com.amazonaws.service.codepipeline.model.GetPipelineStateResult;
import com.amazonaws.service.codepipeline.model.GetThirdPartyJobDetailsRequest;
import com.amazonaws.service.codepipeline.model.GetThirdPartyJobDetailsResult;
import com.amazonaws.service.codepipeline.model.ListActionTypesRequest;
import com.amazonaws.service.codepipeline.model.ListActionTypesResult;
import com.amazonaws.service.codepipeline.model.ListPipelinesRequest;
import com.amazonaws.service.codepipeline.model.ListPipelinesResult;
import com.amazonaws.service.codepipeline.model.PollForJobsRequest;
import com.amazonaws.service.codepipeline.model.PollForJobsResult;
import com.amazonaws.service.codepipeline.model.PollForThirdPartyJobsRequest;
import com.amazonaws.service.codepipeline.model.PollForThirdPartyJobsResult;
import com.amazonaws.service.codepipeline.model.PutActionRevisionRequest;
import com.amazonaws.service.codepipeline.model.PutActionRevisionResult;
import com.amazonaws.service.codepipeline.model.PutJobFailureResultRequest;
import com.amazonaws.service.codepipeline.model.PutJobSuccessResultRequest;
import com.amazonaws.service.codepipeline.model.PutThirdPartyJobFailureResultRequest;
import com.amazonaws.service.codepipeline.model.PutThirdPartyJobSuccessResultRequest;
import com.amazonaws.service.codepipeline.model.StartPipelineExecutionRequest;
import com.amazonaws.service.codepipeline.model.StartPipelineExecutionResult;
import com.amazonaws.service.codepipeline.model.UpdatePipelineRequest;
import com.amazonaws.service.codepipeline.model.UpdatePipelineResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AWSCodePipelineAsyncClient
extends AWSCodePipelineClient
implements AWSCodePipelineAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSCodePipelineAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AWSCodePipelineAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCodePipelineAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSCodePipelineAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, new ClientConfiguration(), executorService);
    }

    public AWSCodePipelineAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSCodePipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSCodePipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCodePipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AWSCodePipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<AcknowledgeJobResult> acknowledgeJobAsync(final AcknowledgeJobRequest acknowledgeJobRequest) {
        return this.executorService.submit(new Callable<AcknowledgeJobResult>(){

            @Override
            public AcknowledgeJobResult call() {
                return AWSCodePipelineAsyncClient.this.acknowledgeJob(acknowledgeJobRequest);
            }
        });
    }

    @Override
    public Future<AcknowledgeJobResult> acknowledgeJobAsync(final AcknowledgeJobRequest acknowledgeJobRequest, final AsyncHandler<AcknowledgeJobRequest, AcknowledgeJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<AcknowledgeJobResult>(){

            @Override
            public AcknowledgeJobResult call() throws Exception {
                AcknowledgeJobResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.acknowledgeJob(acknowledgeJobRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(acknowledgeJobRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<AcknowledgeThirdPartyJobResult> acknowledgeThirdPartyJobAsync(final AcknowledgeThirdPartyJobRequest acknowledgeThirdPartyJobRequest) {
        return this.executorService.submit(new Callable<AcknowledgeThirdPartyJobResult>(){

            @Override
            public AcknowledgeThirdPartyJobResult call() {
                return AWSCodePipelineAsyncClient.this.acknowledgeThirdPartyJob(acknowledgeThirdPartyJobRequest);
            }
        });
    }

    @Override
    public Future<AcknowledgeThirdPartyJobResult> acknowledgeThirdPartyJobAsync(final AcknowledgeThirdPartyJobRequest acknowledgeThirdPartyJobRequest, final AsyncHandler<AcknowledgeThirdPartyJobRequest, AcknowledgeThirdPartyJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<AcknowledgeThirdPartyJobResult>(){

            @Override
            public AcknowledgeThirdPartyJobResult call() throws Exception {
                AcknowledgeThirdPartyJobResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.acknowledgeThirdPartyJob(acknowledgeThirdPartyJobRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(acknowledgeThirdPartyJobRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateCustomActionTypeResult> createCustomActionTypeAsync(final CreateCustomActionTypeRequest createCustomActionTypeRequest) {
        return this.executorService.submit(new Callable<CreateCustomActionTypeResult>(){

            @Override
            public CreateCustomActionTypeResult call() {
                return AWSCodePipelineAsyncClient.this.createCustomActionType(createCustomActionTypeRequest);
            }
        });
    }

    @Override
    public Future<CreateCustomActionTypeResult> createCustomActionTypeAsync(final CreateCustomActionTypeRequest createCustomActionTypeRequest, final AsyncHandler<CreateCustomActionTypeRequest, CreateCustomActionTypeResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateCustomActionTypeResult>(){

            @Override
            public CreateCustomActionTypeResult call() throws Exception {
                CreateCustomActionTypeResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.createCustomActionType(createCustomActionTypeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createCustomActionTypeRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreatePipelineResult> createPipelineAsync(final CreatePipelineRequest createPipelineRequest) {
        return this.executorService.submit(new Callable<CreatePipelineResult>(){

            @Override
            public CreatePipelineResult call() {
                return AWSCodePipelineAsyncClient.this.createPipeline(createPipelineRequest);
            }
        });
    }

    @Override
    public Future<CreatePipelineResult> createPipelineAsync(final CreatePipelineRequest createPipelineRequest, final AsyncHandler<CreatePipelineRequest, CreatePipelineResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreatePipelineResult>(){

            @Override
            public CreatePipelineResult call() throws Exception {
                CreatePipelineResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.createPipeline(createPipelineRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createPipelineRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteCustomActionTypeAsync(final DeleteCustomActionTypeRequest deleteCustomActionTypeRequest) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                AWSCodePipelineAsyncClient.this.deleteCustomActionType(deleteCustomActionTypeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteCustomActionTypeAsync(final DeleteCustomActionTypeRequest deleteCustomActionTypeRequest, final AsyncHandler<DeleteCustomActionTypeRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodePipelineAsyncClient.this.deleteCustomActionType(deleteCustomActionTypeRequest);
                    result = null;
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteCustomActionTypeRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deletePipelineAsync(final DeletePipelineRequest deletePipelineRequest) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                AWSCodePipelineAsyncClient.this.deletePipeline(deletePipelineRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deletePipelineAsync(final DeletePipelineRequest deletePipelineRequest, final AsyncHandler<DeletePipelineRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodePipelineAsyncClient.this.deletePipeline(deletePipelineRequest);
                    result = null;
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deletePipelineRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> disableStageTransitionAsync(final DisableStageTransitionRequest disableStageTransitionRequest) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                AWSCodePipelineAsyncClient.this.disableStageTransition(disableStageTransitionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> disableStageTransitionAsync(final DisableStageTransitionRequest disableStageTransitionRequest, final AsyncHandler<DisableStageTransitionRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodePipelineAsyncClient.this.disableStageTransition(disableStageTransitionRequest);
                    result = null;
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(disableStageTransitionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> enableStageTransitionAsync(final EnableStageTransitionRequest enableStageTransitionRequest) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                AWSCodePipelineAsyncClient.this.enableStageTransition(enableStageTransitionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> enableStageTransitionAsync(final EnableStageTransitionRequest enableStageTransitionRequest, final AsyncHandler<EnableStageTransitionRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodePipelineAsyncClient.this.enableStageTransition(enableStageTransitionRequest);
                    result = null;
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(enableStageTransitionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetJobDetailsResult> getJobDetailsAsync(final GetJobDetailsRequest getJobDetailsRequest) {
        return this.executorService.submit(new Callable<GetJobDetailsResult>(){

            @Override
            public GetJobDetailsResult call() {
                return AWSCodePipelineAsyncClient.this.getJobDetails(getJobDetailsRequest);
            }
        });
    }

    @Override
    public Future<GetJobDetailsResult> getJobDetailsAsync(final GetJobDetailsRequest getJobDetailsRequest, final AsyncHandler<GetJobDetailsRequest, GetJobDetailsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetJobDetailsResult>(){

            @Override
            public GetJobDetailsResult call() throws Exception {
                GetJobDetailsResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.getJobDetails(getJobDetailsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getJobDetailsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetPipelineResult> getPipelineAsync(final GetPipelineRequest getPipelineRequest) {
        return this.executorService.submit(new Callable<GetPipelineResult>(){

            @Override
            public GetPipelineResult call() {
                return AWSCodePipelineAsyncClient.this.getPipeline(getPipelineRequest);
            }
        });
    }

    @Override
    public Future<GetPipelineResult> getPipelineAsync(final GetPipelineRequest getPipelineRequest, final AsyncHandler<GetPipelineRequest, GetPipelineResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetPipelineResult>(){

            @Override
            public GetPipelineResult call() throws Exception {
                GetPipelineResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.getPipeline(getPipelineRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getPipelineRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetPipelineStateResult> getPipelineStateAsync(final GetPipelineStateRequest getPipelineStateRequest) {
        return this.executorService.submit(new Callable<GetPipelineStateResult>(){

            @Override
            public GetPipelineStateResult call() {
                return AWSCodePipelineAsyncClient.this.getPipelineState(getPipelineStateRequest);
            }
        });
    }

    @Override
    public Future<GetPipelineStateResult> getPipelineStateAsync(final GetPipelineStateRequest getPipelineStateRequest, final AsyncHandler<GetPipelineStateRequest, GetPipelineStateResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetPipelineStateResult>(){

            @Override
            public GetPipelineStateResult call() throws Exception {
                GetPipelineStateResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.getPipelineState(getPipelineStateRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getPipelineStateRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetThirdPartyJobDetailsResult> getThirdPartyJobDetailsAsync(final GetThirdPartyJobDetailsRequest getThirdPartyJobDetailsRequest) {
        return this.executorService.submit(new Callable<GetThirdPartyJobDetailsResult>(){

            @Override
            public GetThirdPartyJobDetailsResult call() {
                return AWSCodePipelineAsyncClient.this.getThirdPartyJobDetails(getThirdPartyJobDetailsRequest);
            }
        });
    }

    @Override
    public Future<GetThirdPartyJobDetailsResult> getThirdPartyJobDetailsAsync(final GetThirdPartyJobDetailsRequest getThirdPartyJobDetailsRequest, final AsyncHandler<GetThirdPartyJobDetailsRequest, GetThirdPartyJobDetailsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetThirdPartyJobDetailsResult>(){

            @Override
            public GetThirdPartyJobDetailsResult call() throws Exception {
                GetThirdPartyJobDetailsResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.getThirdPartyJobDetails(getThirdPartyJobDetailsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getThirdPartyJobDetailsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListActionTypesResult> listActionTypesAsync(final ListActionTypesRequest listActionTypesRequest) {
        return this.executorService.submit(new Callable<ListActionTypesResult>(){

            @Override
            public ListActionTypesResult call() {
                return AWSCodePipelineAsyncClient.this.listActionTypes(listActionTypesRequest);
            }
        });
    }

    @Override
    public Future<ListActionTypesResult> listActionTypesAsync(final ListActionTypesRequest listActionTypesRequest, final AsyncHandler<ListActionTypesRequest, ListActionTypesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListActionTypesResult>(){

            @Override
            public ListActionTypesResult call() throws Exception {
                ListActionTypesResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.listActionTypes(listActionTypesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listActionTypesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(final ListPipelinesRequest listPipelinesRequest) {
        return this.executorService.submit(new Callable<ListPipelinesResult>(){

            @Override
            public ListPipelinesResult call() {
                return AWSCodePipelineAsyncClient.this.listPipelines(listPipelinesRequest);
            }
        });
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(final ListPipelinesRequest listPipelinesRequest, final AsyncHandler<ListPipelinesRequest, ListPipelinesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListPipelinesResult>(){

            @Override
            public ListPipelinesResult call() throws Exception {
                ListPipelinesResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.listPipelines(listPipelinesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listPipelinesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<PollForJobsResult> pollForJobsAsync(final PollForJobsRequest pollForJobsRequest) {
        return this.executorService.submit(new Callable<PollForJobsResult>(){

            @Override
            public PollForJobsResult call() {
                return AWSCodePipelineAsyncClient.this.pollForJobs(pollForJobsRequest);
            }
        });
    }

    @Override
    public Future<PollForJobsResult> pollForJobsAsync(final PollForJobsRequest pollForJobsRequest, final AsyncHandler<PollForJobsRequest, PollForJobsResult> asyncHandler) {
        return this.executorService.submit(new Callable<PollForJobsResult>(){

            @Override
            public PollForJobsResult call() throws Exception {
                PollForJobsResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.pollForJobs(pollForJobsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(pollForJobsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<PollForThirdPartyJobsResult> pollForThirdPartyJobsAsync(final PollForThirdPartyJobsRequest pollForThirdPartyJobsRequest) {
        return this.executorService.submit(new Callable<PollForThirdPartyJobsResult>(){

            @Override
            public PollForThirdPartyJobsResult call() {
                return AWSCodePipelineAsyncClient.this.pollForThirdPartyJobs(pollForThirdPartyJobsRequest);
            }
        });
    }

    @Override
    public Future<PollForThirdPartyJobsResult> pollForThirdPartyJobsAsync(final PollForThirdPartyJobsRequest pollForThirdPartyJobsRequest, final AsyncHandler<PollForThirdPartyJobsRequest, PollForThirdPartyJobsResult> asyncHandler) {
        return this.executorService.submit(new Callable<PollForThirdPartyJobsResult>(){

            @Override
            public PollForThirdPartyJobsResult call() throws Exception {
                PollForThirdPartyJobsResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.pollForThirdPartyJobs(pollForThirdPartyJobsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(pollForThirdPartyJobsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<PutActionRevisionResult> putActionRevisionAsync(final PutActionRevisionRequest putActionRevisionRequest) {
        return this.executorService.submit(new Callable<PutActionRevisionResult>(){

            @Override
            public PutActionRevisionResult call() {
                return AWSCodePipelineAsyncClient.this.putActionRevision(putActionRevisionRequest);
            }
        });
    }

    @Override
    public Future<PutActionRevisionResult> putActionRevisionAsync(final PutActionRevisionRequest putActionRevisionRequest, final AsyncHandler<PutActionRevisionRequest, PutActionRevisionResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutActionRevisionResult>(){

            @Override
            public PutActionRevisionResult call() throws Exception {
                PutActionRevisionResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.putActionRevision(putActionRevisionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(putActionRevisionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> putJobFailureResultAsync(final PutJobFailureResultRequest putJobFailureResultRequest) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                AWSCodePipelineAsyncClient.this.putJobFailureResult(putJobFailureResultRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putJobFailureResultAsync(final PutJobFailureResultRequest putJobFailureResultRequest, final AsyncHandler<PutJobFailureResultRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodePipelineAsyncClient.this.putJobFailureResult(putJobFailureResultRequest);
                    result = null;
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(putJobFailureResultRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> putJobSuccessResultAsync(final PutJobSuccessResultRequest putJobSuccessResultRequest) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                AWSCodePipelineAsyncClient.this.putJobSuccessResult(putJobSuccessResultRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putJobSuccessResultAsync(final PutJobSuccessResultRequest putJobSuccessResultRequest, final AsyncHandler<PutJobSuccessResultRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodePipelineAsyncClient.this.putJobSuccessResult(putJobSuccessResultRequest);
                    result = null;
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(putJobSuccessResultRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> putThirdPartyJobFailureResultAsync(final PutThirdPartyJobFailureResultRequest putThirdPartyJobFailureResultRequest) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                AWSCodePipelineAsyncClient.this.putThirdPartyJobFailureResult(putThirdPartyJobFailureResultRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putThirdPartyJobFailureResultAsync(final PutThirdPartyJobFailureResultRequest putThirdPartyJobFailureResultRequest, final AsyncHandler<PutThirdPartyJobFailureResultRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodePipelineAsyncClient.this.putThirdPartyJobFailureResult(putThirdPartyJobFailureResultRequest);
                    result = null;
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(putThirdPartyJobFailureResultRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> putThirdPartyJobSuccessResultAsync(final PutThirdPartyJobSuccessResultRequest putThirdPartyJobSuccessResultRequest) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                AWSCodePipelineAsyncClient.this.putThirdPartyJobSuccessResult(putThirdPartyJobSuccessResultRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putThirdPartyJobSuccessResultAsync(final PutThirdPartyJobSuccessResultRequest putThirdPartyJobSuccessResultRequest, final AsyncHandler<PutThirdPartyJobSuccessResultRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodePipelineAsyncClient.this.putThirdPartyJobSuccessResult(putThirdPartyJobSuccessResultRequest);
                    result = null;
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(putThirdPartyJobSuccessResultRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<StartPipelineExecutionResult> startPipelineExecutionAsync(final StartPipelineExecutionRequest startPipelineExecutionRequest) {
        return this.executorService.submit(new Callable<StartPipelineExecutionResult>(){

            @Override
            public StartPipelineExecutionResult call() {
                return AWSCodePipelineAsyncClient.this.startPipelineExecution(startPipelineExecutionRequest);
            }
        });
    }

    @Override
    public Future<StartPipelineExecutionResult> startPipelineExecutionAsync(final StartPipelineExecutionRequest startPipelineExecutionRequest, final AsyncHandler<StartPipelineExecutionRequest, StartPipelineExecutionResult> asyncHandler) {
        return this.executorService.submit(new Callable<StartPipelineExecutionResult>(){

            @Override
            public StartPipelineExecutionResult call() throws Exception {
                StartPipelineExecutionResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.startPipelineExecution(startPipelineExecutionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(startPipelineExecutionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePipelineResult> updatePipelineAsync(final UpdatePipelineRequest updatePipelineRequest) {
        return this.executorService.submit(new Callable<UpdatePipelineResult>(){

            @Override
            public UpdatePipelineResult call() {
                return AWSCodePipelineAsyncClient.this.updatePipeline(updatePipelineRequest);
            }
        });
    }

    @Override
    public Future<UpdatePipelineResult> updatePipelineAsync(final UpdatePipelineRequest updatePipelineRequest, final AsyncHandler<UpdatePipelineRequest, UpdatePipelineResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdatePipelineResult>(){

            @Override
            public UpdatePipelineResult call() throws Exception {
                UpdatePipelineResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.updatePipeline(updatePipelineRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updatePipelineRequest, result);
                return result;
            }
        });
    }
}

