/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.storagegateway.model.Tape;
import com.amazonaws.util.json.JSONWriter;

public class TapeJsonMarshaller {
    private static TapeJsonMarshaller instance;

    public void marshall(Tape tape, JSONWriter jsonWriter) {
        if (tape == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (tape.getTapeARN() != null) {
                jsonWriter.key("TapeARN").value(tape.getTapeARN());
            }
            if (tape.getTapeBarcode() != null) {
                jsonWriter.key("TapeBarcode").value(tape.getTapeBarcode());
            }
            if (tape.getTapeSizeInBytes() != null) {
                jsonWriter.key("TapeSizeInBytes").value(tape.getTapeSizeInBytes());
            }
            if (tape.getTapeStatus() != null) {
                jsonWriter.key("TapeStatus").value(tape.getTapeStatus());
            }
            if (tape.getVTLDevice() != null) {
                jsonWriter.key("VTLDevice").value(tape.getVTLDevice());
            }
            if (tape.getProgress() != null) {
                jsonWriter.key("Progress").value(tape.getProgress());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TapeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TapeJsonMarshaller();
        }
        return instance;
    }
}

