/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeInstanceInformationRequest;
import com.amazonaws.services.simplesystemsmanagement.model.InstanceInformationFilter;
import com.amazonaws.services.simplesystemsmanagement.model.transform.InstanceInformationFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DescribeInstanceInformationRequestMarshaller
implements Marshaller<Request<DescribeInstanceInformationRequest>, DescribeInstanceInformationRequest> {
    @Override
    public Request<DescribeInstanceInformationRequest> marshall(DescribeInstanceInformationRequest describeInstanceInformationRequest) {
        if (describeInstanceInformationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeInstanceInformationRequest> request = new DefaultRequest<DescribeInstanceInformationRequest>(describeInstanceInformationRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.DescribeInstanceInformation");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            SdkInternalList instanceInformationFilterListList = (SdkInternalList)describeInstanceInformationRequest.getInstanceInformationFilterList();
            if (!instanceInformationFilterListList.isEmpty() || !instanceInformationFilterListList.isAutoConstruct()) {
                jsonWriter.key("InstanceInformationFilterList");
                jsonWriter.array();
                for (InstanceInformationFilter instanceInformationFilterListListValue : instanceInformationFilterListList) {
                    if (instanceInformationFilterListListValue == null) continue;
                    InstanceInformationFilterJsonMarshaller.getInstance().marshall(instanceInformationFilterListListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (describeInstanceInformationRequest.getMaxResults() != null) {
                jsonWriter.key("MaxResults").value(describeInstanceInformationRequest.getMaxResults());
            }
            if (describeInstanceInformationRequest.getNextToken() != null) {
                jsonWriter.key("NextToken").value(describeInstanceInformationRequest.getNextToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

