/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.devicefarm.model.CreateDevicePoolRequest;
import com.amazonaws.services.devicefarm.model.Rule;
import com.amazonaws.services.devicefarm.model.transform.RuleJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

public class CreateDevicePoolRequestMarshaller
implements Marshaller<Request<CreateDevicePoolRequest>, CreateDevicePoolRequest> {
    @Override
    public Request<CreateDevicePoolRequest> marshall(CreateDevicePoolRequest createDevicePoolRequest) {
        if (createDevicePoolRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateDevicePoolRequest> request = new DefaultRequest<CreateDevicePoolRequest>(createDevicePoolRequest, "AWSDeviceFarm");
        request.addHeader("X-Amz-Target", "DeviceFarm_20150623.CreateDevicePool");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<Rule> rulesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createDevicePoolRequest.getProjectArn() != null) {
                jsonWriter.key("projectArn").value(createDevicePoolRequest.getProjectArn());
            }
            if (createDevicePoolRequest.getName() != null) {
                jsonWriter.key("name").value(createDevicePoolRequest.getName());
            }
            if (createDevicePoolRequest.getDescription() != null) {
                jsonWriter.key("description").value(createDevicePoolRequest.getDescription());
            }
            if ((rulesList = createDevicePoolRequest.getRules()) != null) {
                jsonWriter.key("rules");
                jsonWriter.array();
                for (Rule rulesListValue : rulesList) {
                    if (rulesListValue == null) continue;
                    RuleJsonMarshaller.getInstance().marshall(rulesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

