/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchdomain.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudsearchdomain.model.SuggestRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.UriResourcePathUtils;
import java.io.ByteArrayInputStream;

public class SuggestRequestMarshaller
implements Marshaller<Request<SuggestRequest>, SuggestRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<SuggestRequest> marshall(SuggestRequest suggestRequest) {
        String size;
        String suggester;
        String query;
        if (suggestRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SuggestRequest> request = new DefaultRequest<SuggestRequest>(suggestRequest, "AmazonCloudSearchDomain");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-01-01/suggest?format=sdk&pretty=true";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest(request, uriResourcePath);
        request.setResourcePath(uriResourcePath);
        String string = query = suggestRequest.getQuery() == null ? null : StringUtils.fromString(suggestRequest.getQuery());
        if (query != null) {
            request.addParameter("q", query);
        }
        String string2 = suggester = suggestRequest.getSuggester() == null ? null : StringUtils.fromString(suggestRequest.getSuggester());
        if (suggester != null) {
            request.addParameter("suggester", suggester);
        }
        String string3 = size = suggestRequest.getSize() == null ? null : StringUtils.fromLong(suggestRequest.getSize());
        if (size != null) {
            request.addParameter("size", size);
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

