/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudhsm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudhsm.model.ModifyLunaClientRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ModifyLunaClientRequestMarshaller
implements Marshaller<Request<ModifyLunaClientRequest>, ModifyLunaClientRequest> {
    @Override
    public Request<ModifyLunaClientRequest> marshall(ModifyLunaClientRequest modifyLunaClientRequest) {
        if (modifyLunaClientRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyLunaClientRequest> request = new DefaultRequest<ModifyLunaClientRequest>(modifyLunaClientRequest, "AWSCloudHSM");
        request.addHeader("X-Amz-Target", "CloudHsmFrontendService.ModifyLunaClient");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (modifyLunaClientRequest.getClientArn() != null) {
                jsonWriter.key("ClientArn").value(modifyLunaClientRequest.getClientArn());
            }
            if (modifyLunaClientRequest.getCertificate() != null) {
                jsonWriter.key("Certificate").value(modifyLunaClientRequest.getCertificate());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

