/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetBasePathMappingsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetBasePathMappingsRequestMarshaller
implements Marshaller<Request<GetBasePathMappingsRequest>, GetBasePathMappingsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<GetBasePathMappingsRequest> marshall(GetBasePathMappingsRequest getBasePathMappingsRequest) {
        String limit;
        String position;
        if (getBasePathMappingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetBasePathMappingsRequest> request = new DefaultRequest<GetBasePathMappingsRequest>(getBasePathMappingsRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/domainnames/{domain_name}/basepathmappings";
        uriResourcePath = uriResourcePath.replace("{domain_name}", getBasePathMappingsRequest.getDomainName() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(getBasePathMappingsRequest.getDomainName()));
        request.setResourcePath(uriResourcePath);
        String string = position = getBasePathMappingsRequest.getPosition() == null ? null : StringUtils.fromString(getBasePathMappingsRequest.getPosition());
        if (position != null) {
            request.addParameter("position", position);
        }
        String string2 = limit = getBasePathMappingsRequest.getLimit() == null ? null : StringUtils.fromInteger(getBasePathMappingsRequest.getLimit());
        if (limit != null) {
            request.addParameter("limit", limit);
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

