/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.Host;
import com.amazonaws.services.ec2.model.transform.AvailableCapacityStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.HostInstanceStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.HostPropertiesStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class HostStaxUnmarshaller
implements Unmarshaller<Host, StaxUnmarshallerContext> {
    private static HostStaxUnmarshaller instance;

    @Override
    public Host unmarshall(StaxUnmarshallerContext context) throws Exception {
        Host host = new Host();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return host;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("hostId", targetDepth)) {
                    host.setHostId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("autoPlacement", targetDepth)) {
                    host.setAutoPlacement(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("hostReservationId", targetDepth)) {
                    host.setHostReservationId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("clientToken", targetDepth)) {
                    host.setClientToken(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("hostProperties", targetDepth)) {
                    host.setHostProperties(HostPropertiesStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("state", targetDepth)) {
                    host.setState(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("availabilityZone", targetDepth)) {
                    host.setAvailabilityZone(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("instances/item", targetDepth)) {
                    host.getInstances().add(HostInstanceStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("availableCapacity", targetDepth)) continue;
                host.setAvailableCapacity(AvailableCapacityStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return host;
    }

    public static HostStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new HostStaxUnmarshaller();
        }
        return instance;
    }
}

