/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexUpdate;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeDefinitionJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.GlobalSecondaryIndexUpdateJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ProvisionedThroughputJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.StreamSpecificationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

public class UpdateTableRequestMarshaller
implements Marshaller<Request<UpdateTableRequest>, UpdateTableRequest> {
    @Override
    public Request<UpdateTableRequest> marshall(UpdateTableRequest updateTableRequest) {
        if (updateTableRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateTableRequest> request = new DefaultRequest<UpdateTableRequest>(updateTableRequest, "AmazonDynamoDBv2");
        request.addHeader("X-Amz-Target", "DynamoDB_20120810.UpdateTable");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdatesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            List<AttributeDefinition> attributeDefinitionsList = updateTableRequest.getAttributeDefinitions();
            if (attributeDefinitionsList != null) {
                jsonWriter.key("AttributeDefinitions");
                jsonWriter.array();
                for (AttributeDefinition attributeDefinitionsListValue : attributeDefinitionsList) {
                    if (attributeDefinitionsListValue == null) continue;
                    AttributeDefinitionJsonMarshaller.getInstance().marshall(attributeDefinitionsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (updateTableRequest.getTableName() != null) {
                jsonWriter.key("TableName").value(updateTableRequest.getTableName());
            }
            if (updateTableRequest.getProvisionedThroughput() != null) {
                jsonWriter.key("ProvisionedThroughput");
                ProvisionedThroughputJsonMarshaller.getInstance().marshall(updateTableRequest.getProvisionedThroughput(), jsonWriter);
            }
            if ((globalSecondaryIndexUpdatesList = updateTableRequest.getGlobalSecondaryIndexUpdates()) != null) {
                jsonWriter.key("GlobalSecondaryIndexUpdates");
                jsonWriter.array();
                for (GlobalSecondaryIndexUpdate globalSecondaryIndexUpdatesListValue : globalSecondaryIndexUpdatesList) {
                    if (globalSecondaryIndexUpdatesListValue == null) continue;
                    GlobalSecondaryIndexUpdateJsonMarshaller.getInstance().marshall(globalSecondaryIndexUpdatesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (updateTableRequest.getStreamSpecification() != null) {
                jsonWriter.key("StreamSpecification");
                StreamSpecificationJsonMarshaller.getInstance().marshall(updateTableRequest.getStreamSpecification(), jsonWriter);
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

