/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.identitymanagement.model.PolicyEvaluationDecisionType;
import com.amazonaws.services.identitymanagement.model.Statement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourceSpecificResult
implements Serializable,
Cloneable {
    private String evalResourceName;
    private String evalResourceDecision;
    private ListWithAutoConstructFlag<Statement> matchedStatements;
    private ListWithAutoConstructFlag<String> missingContextValues;
    private Map<String, String> evalDecisionDetails;

    public String getEvalResourceName() {
        return this.evalResourceName;
    }

    public void setEvalResourceName(String evalResourceName) {
        this.evalResourceName = evalResourceName;
    }

    public ResourceSpecificResult withEvalResourceName(String evalResourceName) {
        this.evalResourceName = evalResourceName;
        return this;
    }

    public String getEvalResourceDecision() {
        return this.evalResourceDecision;
    }

    public void setEvalResourceDecision(String evalResourceDecision) {
        this.evalResourceDecision = evalResourceDecision;
    }

    public ResourceSpecificResult withEvalResourceDecision(String evalResourceDecision) {
        this.evalResourceDecision = evalResourceDecision;
        return this;
    }

    public void setEvalResourceDecision(PolicyEvaluationDecisionType evalResourceDecision) {
        this.evalResourceDecision = evalResourceDecision.toString();
    }

    public ResourceSpecificResult withEvalResourceDecision(PolicyEvaluationDecisionType evalResourceDecision) {
        this.evalResourceDecision = evalResourceDecision.toString();
        return this;
    }

    public List<Statement> getMatchedStatements() {
        if (this.matchedStatements == null) {
            this.matchedStatements = new ListWithAutoConstructFlag();
            this.matchedStatements.setAutoConstruct(true);
        }
        return this.matchedStatements;
    }

    public void setMatchedStatements(Collection<Statement> matchedStatements) {
        if (matchedStatements == null) {
            this.matchedStatements = null;
            return;
        }
        ListWithAutoConstructFlag matchedStatementsCopy = new ListWithAutoConstructFlag(matchedStatements.size());
        matchedStatementsCopy.addAll(matchedStatements);
        this.matchedStatements = matchedStatementsCopy;
    }

    public ResourceSpecificResult withMatchedStatements(Statement ... matchedStatements) {
        if (this.getMatchedStatements() == null) {
            this.setMatchedStatements(new ArrayList<Statement>(matchedStatements.length));
        }
        for (Statement value : matchedStatements) {
            this.getMatchedStatements().add(value);
        }
        return this;
    }

    public ResourceSpecificResult withMatchedStatements(Collection<Statement> matchedStatements) {
        if (matchedStatements == null) {
            this.matchedStatements = null;
        } else {
            ListWithAutoConstructFlag matchedStatementsCopy = new ListWithAutoConstructFlag(matchedStatements.size());
            matchedStatementsCopy.addAll(matchedStatements);
            this.matchedStatements = matchedStatementsCopy;
        }
        return this;
    }

    public List<String> getMissingContextValues() {
        if (this.missingContextValues == null) {
            this.missingContextValues = new ListWithAutoConstructFlag();
            this.missingContextValues.setAutoConstruct(true);
        }
        return this.missingContextValues;
    }

    public void setMissingContextValues(Collection<String> missingContextValues) {
        if (missingContextValues == null) {
            this.missingContextValues = null;
            return;
        }
        ListWithAutoConstructFlag missingContextValuesCopy = new ListWithAutoConstructFlag(missingContextValues.size());
        missingContextValuesCopy.addAll(missingContextValues);
        this.missingContextValues = missingContextValuesCopy;
    }

    public ResourceSpecificResult withMissingContextValues(String ... missingContextValues) {
        if (this.getMissingContextValues() == null) {
            this.setMissingContextValues(new ArrayList<String>(missingContextValues.length));
        }
        for (String value : missingContextValues) {
            this.getMissingContextValues().add(value);
        }
        return this;
    }

    public ResourceSpecificResult withMissingContextValues(Collection<String> missingContextValues) {
        if (missingContextValues == null) {
            this.missingContextValues = null;
        } else {
            ListWithAutoConstructFlag missingContextValuesCopy = new ListWithAutoConstructFlag(missingContextValues.size());
            missingContextValuesCopy.addAll(missingContextValues);
            this.missingContextValues = missingContextValuesCopy;
        }
        return this;
    }

    public Map<String, String> getEvalDecisionDetails() {
        if (this.evalDecisionDetails == null) {
            this.evalDecisionDetails = new HashMap<String, String>();
        }
        return this.evalDecisionDetails;
    }

    public void setEvalDecisionDetails(Map<String, String> evalDecisionDetails) {
        this.evalDecisionDetails = evalDecisionDetails;
    }

    public ResourceSpecificResult withEvalDecisionDetails(Map<String, String> evalDecisionDetails) {
        this.setEvalDecisionDetails(evalDecisionDetails);
        return this;
    }

    public ResourceSpecificResult addEvalDecisionDetailsEntry(String key, String value) {
        if (null == this.evalDecisionDetails) {
            this.evalDecisionDetails = new HashMap<String, String>();
        }
        if (this.evalDecisionDetails.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.evalDecisionDetails.put(key, value);
        return this;
    }

    public ResourceSpecificResult clearEvalDecisionDetailsEntries() {
        this.evalDecisionDetails = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEvalResourceName() != null) {
            sb.append("EvalResourceName: " + this.getEvalResourceName() + ",");
        }
        if (this.getEvalResourceDecision() != null) {
            sb.append("EvalResourceDecision: " + this.getEvalResourceDecision() + ",");
        }
        if (this.getMatchedStatements() != null) {
            sb.append("MatchedStatements: " + this.getMatchedStatements() + ",");
        }
        if (this.getMissingContextValues() != null) {
            sb.append("MissingContextValues: " + this.getMissingContextValues() + ",");
        }
        if (this.getEvalDecisionDetails() != null) {
            sb.append("EvalDecisionDetails: " + this.getEvalDecisionDetails());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEvalResourceName() == null ? 0 : this.getEvalResourceName().hashCode());
        hashCode = 31 * hashCode + (this.getEvalResourceDecision() == null ? 0 : this.getEvalResourceDecision().hashCode());
        hashCode = 31 * hashCode + (this.getMatchedStatements() == null ? 0 : this.getMatchedStatements().hashCode());
        hashCode = 31 * hashCode + (this.getMissingContextValues() == null ? 0 : this.getMissingContextValues().hashCode());
        hashCode = 31 * hashCode + (this.getEvalDecisionDetails() == null ? 0 : this.getEvalDecisionDetails().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSpecificResult)) {
            return false;
        }
        ResourceSpecificResult other = (ResourceSpecificResult)obj;
        if (other.getEvalResourceName() == null ^ this.getEvalResourceName() == null) {
            return false;
        }
        if (other.getEvalResourceName() != null && !other.getEvalResourceName().equals(this.getEvalResourceName())) {
            return false;
        }
        if (other.getEvalResourceDecision() == null ^ this.getEvalResourceDecision() == null) {
            return false;
        }
        if (other.getEvalResourceDecision() != null && !other.getEvalResourceDecision().equals(this.getEvalResourceDecision())) {
            return false;
        }
        if (other.getMatchedStatements() == null ^ this.getMatchedStatements() == null) {
            return false;
        }
        if (other.getMatchedStatements() != null && !other.getMatchedStatements().equals(this.getMatchedStatements())) {
            return false;
        }
        if (other.getMissingContextValues() == null ^ this.getMissingContextValues() == null) {
            return false;
        }
        if (other.getMissingContextValues() != null && !other.getMissingContextValues().equals(this.getMissingContextValues())) {
            return false;
        }
        if (other.getEvalDecisionDetails() == null ^ this.getEvalDecisionDetails() == null) {
            return false;
        }
        return other.getEvalDecisionDetails() == null || other.getEvalDecisionDetails().equals(this.getEvalDecisionDetails());
    }

    public ResourceSpecificResult clone() {
        try {
            return (ResourceSpecificResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

