/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.CreateServiceRequest;
import com.amazonaws.services.ecs.model.LoadBalancer;
import com.amazonaws.services.ecs.model.transform.LoadBalancerJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class CreateServiceRequestMarshaller
implements Marshaller<Request<CreateServiceRequest>, CreateServiceRequest> {
    @Override
    public Request<CreateServiceRequest> marshall(CreateServiceRequest createServiceRequest) {
        if (createServiceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateServiceRequest> request = new DefaultRequest<CreateServiceRequest>(createServiceRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.CreateService");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList loadBalancersList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createServiceRequest.getCluster() != null) {
                jsonWriter.key("cluster").value(createServiceRequest.getCluster());
            }
            if (createServiceRequest.getServiceName() != null) {
                jsonWriter.key("serviceName").value(createServiceRequest.getServiceName());
            }
            if (createServiceRequest.getTaskDefinition() != null) {
                jsonWriter.key("taskDefinition").value(createServiceRequest.getTaskDefinition());
            }
            if (!(loadBalancersList = (SdkInternalList)createServiceRequest.getLoadBalancers()).isEmpty() || !loadBalancersList.isAutoConstruct()) {
                jsonWriter.key("loadBalancers");
                jsonWriter.array();
                for (LoadBalancer loadBalancersListValue : loadBalancersList) {
                    if (loadBalancersListValue == null) continue;
                    LoadBalancerJsonMarshaller.getInstance().marshall(loadBalancersListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (createServiceRequest.getDesiredCount() != null) {
                jsonWriter.key("desiredCount").value(createServiceRequest.getDesiredCount());
            }
            if (createServiceRequest.getClientToken() != null) {
                jsonWriter.key("clientToken").value(createServiceRequest.getClientToken());
            }
            if (createServiceRequest.getRole() != null) {
                jsonWriter.key("role").value(createServiceRequest.getRole());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

