/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.ec2.AmazonEC2Async;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.AcceptVpcPeeringConnectionRequest;
import com.amazonaws.services.ec2.model.AcceptVpcPeeringConnectionResult;
import com.amazonaws.services.ec2.model.AllocateAddressRequest;
import com.amazonaws.services.ec2.model.AllocateAddressResult;
import com.amazonaws.services.ec2.model.AllocateHostsRequest;
import com.amazonaws.services.ec2.model.AllocateHostsResult;
import com.amazonaws.services.ec2.model.AssignPrivateIpAddressesRequest;
import com.amazonaws.services.ec2.model.AssociateAddressRequest;
import com.amazonaws.services.ec2.model.AssociateAddressResult;
import com.amazonaws.services.ec2.model.AssociateDhcpOptionsRequest;
import com.amazonaws.services.ec2.model.AssociateRouteTableRequest;
import com.amazonaws.services.ec2.model.AssociateRouteTableResult;
import com.amazonaws.services.ec2.model.AttachClassicLinkVpcRequest;
import com.amazonaws.services.ec2.model.AttachClassicLinkVpcResult;
import com.amazonaws.services.ec2.model.AttachInternetGatewayRequest;
import com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest;
import com.amazonaws.services.ec2.model.AttachNetworkInterfaceResult;
import com.amazonaws.services.ec2.model.AttachVolumeRequest;
import com.amazonaws.services.ec2.model.AttachVolumeResult;
import com.amazonaws.services.ec2.model.AttachVpnGatewayRequest;
import com.amazonaws.services.ec2.model.AttachVpnGatewayResult;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupEgressRequest;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.BundleInstanceRequest;
import com.amazonaws.services.ec2.model.BundleInstanceResult;
import com.amazonaws.services.ec2.model.CancelBundleTaskRequest;
import com.amazonaws.services.ec2.model.CancelBundleTaskResult;
import com.amazonaws.services.ec2.model.CancelConversionTaskRequest;
import com.amazonaws.services.ec2.model.CancelExportTaskRequest;
import com.amazonaws.services.ec2.model.CancelImportTaskRequest;
import com.amazonaws.services.ec2.model.CancelImportTaskResult;
import com.amazonaws.services.ec2.model.CancelReservedInstancesListingRequest;
import com.amazonaws.services.ec2.model.CancelReservedInstancesListingResult;
import com.amazonaws.services.ec2.model.CancelSpotFleetRequestsRequest;
import com.amazonaws.services.ec2.model.CancelSpotFleetRequestsResult;
import com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest;
import com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsResult;
import com.amazonaws.services.ec2.model.ConfirmProductInstanceRequest;
import com.amazonaws.services.ec2.model.ConfirmProductInstanceResult;
import com.amazonaws.services.ec2.model.CopyImageRequest;
import com.amazonaws.services.ec2.model.CopyImageResult;
import com.amazonaws.services.ec2.model.CopySnapshotRequest;
import com.amazonaws.services.ec2.model.CopySnapshotResult;
import com.amazonaws.services.ec2.model.CreateCustomerGatewayRequest;
import com.amazonaws.services.ec2.model.CreateCustomerGatewayResult;
import com.amazonaws.services.ec2.model.CreateDhcpOptionsRequest;
import com.amazonaws.services.ec2.model.CreateDhcpOptionsResult;
import com.amazonaws.services.ec2.model.CreateFlowLogsRequest;
import com.amazonaws.services.ec2.model.CreateFlowLogsResult;
import com.amazonaws.services.ec2.model.CreateImageRequest;
import com.amazonaws.services.ec2.model.CreateImageResult;
import com.amazonaws.services.ec2.model.CreateInstanceExportTaskRequest;
import com.amazonaws.services.ec2.model.CreateInstanceExportTaskResult;
import com.amazonaws.services.ec2.model.CreateInternetGatewayRequest;
import com.amazonaws.services.ec2.model.CreateInternetGatewayResult;
import com.amazonaws.services.ec2.model.CreateKeyPairRequest;
import com.amazonaws.services.ec2.model.CreateKeyPairResult;
import com.amazonaws.services.ec2.model.CreateNetworkAclEntryRequest;
import com.amazonaws.services.ec2.model.CreateNetworkAclRequest;
import com.amazonaws.services.ec2.model.CreateNetworkAclResult;
import com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest;
import com.amazonaws.services.ec2.model.CreateNetworkInterfaceResult;
import com.amazonaws.services.ec2.model.CreatePlacementGroupRequest;
import com.amazonaws.services.ec2.model.CreateReservedInstancesListingRequest;
import com.amazonaws.services.ec2.model.CreateReservedInstancesListingResult;
import com.amazonaws.services.ec2.model.CreateRouteRequest;
import com.amazonaws.services.ec2.model.CreateRouteResult;
import com.amazonaws.services.ec2.model.CreateRouteTableRequest;
import com.amazonaws.services.ec2.model.CreateRouteTableResult;
import com.amazonaws.services.ec2.model.CreateSecurityGroupRequest;
import com.amazonaws.services.ec2.model.CreateSecurityGroupResult;
import com.amazonaws.services.ec2.model.CreateSnapshotRequest;
import com.amazonaws.services.ec2.model.CreateSnapshotResult;
import com.amazonaws.services.ec2.model.CreateSpotDatafeedSubscriptionRequest;
import com.amazonaws.services.ec2.model.CreateSpotDatafeedSubscriptionResult;
import com.amazonaws.services.ec2.model.CreateSubnetRequest;
import com.amazonaws.services.ec2.model.CreateSubnetResult;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.CreateVolumeRequest;
import com.amazonaws.services.ec2.model.CreateVolumeResult;
import com.amazonaws.services.ec2.model.CreateVpcEndpointRequest;
import com.amazonaws.services.ec2.model.CreateVpcEndpointResult;
import com.amazonaws.services.ec2.model.CreateVpcPeeringConnectionRequest;
import com.amazonaws.services.ec2.model.CreateVpcPeeringConnectionResult;
import com.amazonaws.services.ec2.model.CreateVpcRequest;
import com.amazonaws.services.ec2.model.CreateVpcResult;
import com.amazonaws.services.ec2.model.CreateVpnConnectionRequest;
import com.amazonaws.services.ec2.model.CreateVpnConnectionResult;
import com.amazonaws.services.ec2.model.CreateVpnConnectionRouteRequest;
import com.amazonaws.services.ec2.model.CreateVpnGatewayRequest;
import com.amazonaws.services.ec2.model.CreateVpnGatewayResult;
import com.amazonaws.services.ec2.model.DeleteCustomerGatewayRequest;
import com.amazonaws.services.ec2.model.DeleteDhcpOptionsRequest;
import com.amazonaws.services.ec2.model.DeleteFlowLogsRequest;
import com.amazonaws.services.ec2.model.DeleteFlowLogsResult;
import com.amazonaws.services.ec2.model.DeleteInternetGatewayRequest;
import com.amazonaws.services.ec2.model.DeleteKeyPairRequest;
import com.amazonaws.services.ec2.model.DeleteNetworkAclEntryRequest;
import com.amazonaws.services.ec2.model.DeleteNetworkAclRequest;
import com.amazonaws.services.ec2.model.DeleteNetworkInterfaceRequest;
import com.amazonaws.services.ec2.model.DeletePlacementGroupRequest;
import com.amazonaws.services.ec2.model.DeleteRouteRequest;
import com.amazonaws.services.ec2.model.DeleteRouteTableRequest;
import com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest;
import com.amazonaws.services.ec2.model.DeleteSnapshotRequest;
import com.amazonaws.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest;
import com.amazonaws.services.ec2.model.DeleteSubnetRequest;
import com.amazonaws.services.ec2.model.DeleteTagsRequest;
import com.amazonaws.services.ec2.model.DeleteVolumeRequest;
import com.amazonaws.services.ec2.model.DeleteVpcEndpointsRequest;
import com.amazonaws.services.ec2.model.DeleteVpcEndpointsResult;
import com.amazonaws.services.ec2.model.DeleteVpcPeeringConnectionRequest;
import com.amazonaws.services.ec2.model.DeleteVpcPeeringConnectionResult;
import com.amazonaws.services.ec2.model.DeleteVpcRequest;
import com.amazonaws.services.ec2.model.DeleteVpnConnectionRequest;
import com.amazonaws.services.ec2.model.DeleteVpnConnectionRouteRequest;
import com.amazonaws.services.ec2.model.DeleteVpnGatewayRequest;
import com.amazonaws.services.ec2.model.DeregisterImageRequest;
import com.amazonaws.services.ec2.model.DescribeAccountAttributesRequest;
import com.amazonaws.services.ec2.model.DescribeAccountAttributesResult;
import com.amazonaws.services.ec2.model.DescribeAddressesRequest;
import com.amazonaws.services.ec2.model.DescribeAddressesResult;
import com.amazonaws.services.ec2.model.DescribeAvailabilityZonesRequest;
import com.amazonaws.services.ec2.model.DescribeAvailabilityZonesResult;
import com.amazonaws.services.ec2.model.DescribeBundleTasksRequest;
import com.amazonaws.services.ec2.model.DescribeBundleTasksResult;
import com.amazonaws.services.ec2.model.DescribeClassicLinkInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeClassicLinkInstancesResult;
import com.amazonaws.services.ec2.model.DescribeConversionTasksRequest;
import com.amazonaws.services.ec2.model.DescribeConversionTasksResult;
import com.amazonaws.services.ec2.model.DescribeCustomerGatewaysRequest;
import com.amazonaws.services.ec2.model.DescribeCustomerGatewaysResult;
import com.amazonaws.services.ec2.model.DescribeDhcpOptionsRequest;
import com.amazonaws.services.ec2.model.DescribeDhcpOptionsResult;
import com.amazonaws.services.ec2.model.DescribeExportTasksRequest;
import com.amazonaws.services.ec2.model.DescribeExportTasksResult;
import com.amazonaws.services.ec2.model.DescribeFlowLogsRequest;
import com.amazonaws.services.ec2.model.DescribeFlowLogsResult;
import com.amazonaws.services.ec2.model.DescribeHostsRequest;
import com.amazonaws.services.ec2.model.DescribeHostsResult;
import com.amazonaws.services.ec2.model.DescribeIdFormatRequest;
import com.amazonaws.services.ec2.model.DescribeIdFormatResult;
import com.amazonaws.services.ec2.model.DescribeImageAttributeRequest;
import com.amazonaws.services.ec2.model.DescribeImageAttributeResult;
import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.services.ec2.model.DescribeImagesResult;
import com.amazonaws.services.ec2.model.DescribeImportImageTasksRequest;
import com.amazonaws.services.ec2.model.DescribeImportImageTasksResult;
import com.amazonaws.services.ec2.model.DescribeImportSnapshotTasksRequest;
import com.amazonaws.services.ec2.model.DescribeImportSnapshotTasksResult;
import com.amazonaws.services.ec2.model.DescribeInstanceAttributeRequest;
import com.amazonaws.services.ec2.model.DescribeInstanceAttributeResult;
import com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest;
import com.amazonaws.services.ec2.model.DescribeInstanceStatusResult;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.DescribeInternetGatewaysRequest;
import com.amazonaws.services.ec2.model.DescribeInternetGatewaysResult;
import com.amazonaws.services.ec2.model.DescribeKeyPairsRequest;
import com.amazonaws.services.ec2.model.DescribeKeyPairsResult;
import com.amazonaws.services.ec2.model.DescribeMovingAddressesRequest;
import com.amazonaws.services.ec2.model.DescribeMovingAddressesResult;
import com.amazonaws.services.ec2.model.DescribeNetworkAclsRequest;
import com.amazonaws.services.ec2.model.DescribeNetworkAclsResult;
import com.amazonaws.services.ec2.model.DescribeNetworkInterfaceAttributeRequest;
import com.amazonaws.services.ec2.model.DescribeNetworkInterfaceAttributeResult;
import com.amazonaws.services.ec2.model.DescribeNetworkInterfacesRequest;
import com.amazonaws.services.ec2.model.DescribeNetworkInterfacesResult;
import com.amazonaws.services.ec2.model.DescribePlacementGroupsRequest;
import com.amazonaws.services.ec2.model.DescribePlacementGroupsResult;
import com.amazonaws.services.ec2.model.DescribePrefixListsRequest;
import com.amazonaws.services.ec2.model.DescribePrefixListsResult;
import com.amazonaws.services.ec2.model.DescribeRegionsRequest;
import com.amazonaws.services.ec2.model.DescribeRegionsResult;
import com.amazonaws.services.ec2.model.DescribeReservedInstancesListingsRequest;
import com.amazonaws.services.ec2.model.DescribeReservedInstancesListingsResult;
import com.amazonaws.services.ec2.model.DescribeReservedInstancesModificationsRequest;
import com.amazonaws.services.ec2.model.DescribeReservedInstancesModificationsResult;
import com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsRequest;
import com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsResult;
import com.amazonaws.services.ec2.model.DescribeReservedInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeReservedInstancesResult;
import com.amazonaws.services.ec2.model.DescribeRouteTablesRequest;
import com.amazonaws.services.ec2.model.DescribeRouteTablesResult;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsResult;
import com.amazonaws.services.ec2.model.DescribeSnapshotAttributeRequest;
import com.amazonaws.services.ec2.model.DescribeSnapshotAttributeResult;
import com.amazonaws.services.ec2.model.DescribeSnapshotsRequest;
import com.amazonaws.services.ec2.model.DescribeSnapshotsResult;
import com.amazonaws.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest;
import com.amazonaws.services.ec2.model.DescribeSpotDatafeedSubscriptionResult;
import com.amazonaws.services.ec2.model.DescribeSpotFleetInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeSpotFleetInstancesResult;
import com.amazonaws.services.ec2.model.DescribeSpotFleetRequestHistoryRequest;
import com.amazonaws.services.ec2.model.DescribeSpotFleetRequestHistoryResult;
import com.amazonaws.services.ec2.model.DescribeSpotFleetRequestsRequest;
import com.amazonaws.services.ec2.model.DescribeSpotFleetRequestsResult;
import com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsResult;
import com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest;
import com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryResult;
import com.amazonaws.services.ec2.model.DescribeSubnetsRequest;
import com.amazonaws.services.ec2.model.DescribeSubnetsResult;
import com.amazonaws.services.ec2.model.DescribeTagsRequest;
import com.amazonaws.services.ec2.model.DescribeTagsResult;
import com.amazonaws.services.ec2.model.DescribeVolumeAttributeRequest;
import com.amazonaws.services.ec2.model.DescribeVolumeAttributeResult;
import com.amazonaws.services.ec2.model.DescribeVolumeStatusRequest;
import com.amazonaws.services.ec2.model.DescribeVolumeStatusResult;
import com.amazonaws.services.ec2.model.DescribeVolumesRequest;
import com.amazonaws.services.ec2.model.DescribeVolumesResult;
import com.amazonaws.services.ec2.model.DescribeVpcAttributeRequest;
import com.amazonaws.services.ec2.model.DescribeVpcAttributeResult;
import com.amazonaws.services.ec2.model.DescribeVpcClassicLinkRequest;
import com.amazonaws.services.ec2.model.DescribeVpcClassicLinkResult;
import com.amazonaws.services.ec2.model.DescribeVpcEndpointServicesRequest;
import com.amazonaws.services.ec2.model.DescribeVpcEndpointServicesResult;
import com.amazonaws.services.ec2.model.DescribeVpcEndpointsRequest;
import com.amazonaws.services.ec2.model.DescribeVpcEndpointsResult;
import com.amazonaws.services.ec2.model.DescribeVpcPeeringConnectionsRequest;
import com.amazonaws.services.ec2.model.DescribeVpcPeeringConnectionsResult;
import com.amazonaws.services.ec2.model.DescribeVpcsRequest;
import com.amazonaws.services.ec2.model.DescribeVpcsResult;
import com.amazonaws.services.ec2.model.DescribeVpnConnectionsRequest;
import com.amazonaws.services.ec2.model.DescribeVpnConnectionsResult;
import com.amazonaws.services.ec2.model.DescribeVpnGatewaysRequest;
import com.amazonaws.services.ec2.model.DescribeVpnGatewaysResult;
import com.amazonaws.services.ec2.model.DetachClassicLinkVpcRequest;
import com.amazonaws.services.ec2.model.DetachClassicLinkVpcResult;
import com.amazonaws.services.ec2.model.DetachInternetGatewayRequest;
import com.amazonaws.services.ec2.model.DetachNetworkInterfaceRequest;
import com.amazonaws.services.ec2.model.DetachVolumeRequest;
import com.amazonaws.services.ec2.model.DetachVolumeResult;
import com.amazonaws.services.ec2.model.DetachVpnGatewayRequest;
import com.amazonaws.services.ec2.model.DisableVgwRoutePropagationRequest;
import com.amazonaws.services.ec2.model.DisableVpcClassicLinkRequest;
import com.amazonaws.services.ec2.model.DisableVpcClassicLinkResult;
import com.amazonaws.services.ec2.model.DisassociateAddressRequest;
import com.amazonaws.services.ec2.model.DisassociateRouteTableRequest;
import com.amazonaws.services.ec2.model.EnableVgwRoutePropagationRequest;
import com.amazonaws.services.ec2.model.EnableVolumeIORequest;
import com.amazonaws.services.ec2.model.EnableVpcClassicLinkRequest;
import com.amazonaws.services.ec2.model.EnableVpcClassicLinkResult;
import com.amazonaws.services.ec2.model.GetConsoleOutputRequest;
import com.amazonaws.services.ec2.model.GetConsoleOutputResult;
import com.amazonaws.services.ec2.model.GetPasswordDataRequest;
import com.amazonaws.services.ec2.model.GetPasswordDataResult;
import com.amazonaws.services.ec2.model.ImportImageRequest;
import com.amazonaws.services.ec2.model.ImportImageResult;
import com.amazonaws.services.ec2.model.ImportInstanceRequest;
import com.amazonaws.services.ec2.model.ImportInstanceResult;
import com.amazonaws.services.ec2.model.ImportKeyPairRequest;
import com.amazonaws.services.ec2.model.ImportKeyPairResult;
import com.amazonaws.services.ec2.model.ImportSnapshotRequest;
import com.amazonaws.services.ec2.model.ImportSnapshotResult;
import com.amazonaws.services.ec2.model.ImportVolumeRequest;
import com.amazonaws.services.ec2.model.ImportVolumeResult;
import com.amazonaws.services.ec2.model.ModifyHostsRequest;
import com.amazonaws.services.ec2.model.ModifyHostsResult;
import com.amazonaws.services.ec2.model.ModifyIdFormatRequest;
import com.amazonaws.services.ec2.model.ModifyImageAttributeRequest;
import com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest;
import com.amazonaws.services.ec2.model.ModifyInstancePlacementRequest;
import com.amazonaws.services.ec2.model.ModifyInstancePlacementResult;
import com.amazonaws.services.ec2.model.ModifyNetworkInterfaceAttributeRequest;
import com.amazonaws.services.ec2.model.ModifyReservedInstancesRequest;
import com.amazonaws.services.ec2.model.ModifyReservedInstancesResult;
import com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest;
import com.amazonaws.services.ec2.model.ModifySpotFleetRequestRequest;
import com.amazonaws.services.ec2.model.ModifySpotFleetRequestResult;
import com.amazonaws.services.ec2.model.ModifySubnetAttributeRequest;
import com.amazonaws.services.ec2.model.ModifyVolumeAttributeRequest;
import com.amazonaws.services.ec2.model.ModifyVpcAttributeRequest;
import com.amazonaws.services.ec2.model.ModifyVpcEndpointRequest;
import com.amazonaws.services.ec2.model.ModifyVpcEndpointResult;
import com.amazonaws.services.ec2.model.MonitorInstancesRequest;
import com.amazonaws.services.ec2.model.MonitorInstancesResult;
import com.amazonaws.services.ec2.model.MoveAddressToVpcRequest;
import com.amazonaws.services.ec2.model.MoveAddressToVpcResult;
import com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingRequest;
import com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingResult;
import com.amazonaws.services.ec2.model.RebootInstancesRequest;
import com.amazonaws.services.ec2.model.RegisterImageRequest;
import com.amazonaws.services.ec2.model.RegisterImageResult;
import com.amazonaws.services.ec2.model.RejectVpcPeeringConnectionRequest;
import com.amazonaws.services.ec2.model.RejectVpcPeeringConnectionResult;
import com.amazonaws.services.ec2.model.ReleaseAddressRequest;
import com.amazonaws.services.ec2.model.ReleaseHostsRequest;
import com.amazonaws.services.ec2.model.ReleaseHostsResult;
import com.amazonaws.services.ec2.model.ReplaceNetworkAclAssociationRequest;
import com.amazonaws.services.ec2.model.ReplaceNetworkAclAssociationResult;
import com.amazonaws.services.ec2.model.ReplaceNetworkAclEntryRequest;
import com.amazonaws.services.ec2.model.ReplaceRouteRequest;
import com.amazonaws.services.ec2.model.ReplaceRouteTableAssociationRequest;
import com.amazonaws.services.ec2.model.ReplaceRouteTableAssociationResult;
import com.amazonaws.services.ec2.model.ReportInstanceStatusRequest;
import com.amazonaws.services.ec2.model.RequestSpotFleetRequest;
import com.amazonaws.services.ec2.model.RequestSpotFleetResult;
import com.amazonaws.services.ec2.model.RequestSpotInstancesRequest;
import com.amazonaws.services.ec2.model.RequestSpotInstancesResult;
import com.amazonaws.services.ec2.model.ResetImageAttributeRequest;
import com.amazonaws.services.ec2.model.ResetInstanceAttributeRequest;
import com.amazonaws.services.ec2.model.ResetNetworkInterfaceAttributeRequest;
import com.amazonaws.services.ec2.model.ResetSnapshotAttributeRequest;
import com.amazonaws.services.ec2.model.RestoreAddressToClassicRequest;
import com.amazonaws.services.ec2.model.RestoreAddressToClassicResult;
import com.amazonaws.services.ec2.model.RevokeSecurityGroupEgressRequest;
import com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.amazonaws.services.ec2.model.StartInstancesRequest;
import com.amazonaws.services.ec2.model.StartInstancesResult;
import com.amazonaws.services.ec2.model.StopInstancesRequest;
import com.amazonaws.services.ec2.model.StopInstancesResult;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.amazonaws.services.ec2.model.TerminateInstancesResult;
import com.amazonaws.services.ec2.model.UnassignPrivateIpAddressesRequest;
import com.amazonaws.services.ec2.model.UnmonitorInstancesRequest;
import com.amazonaws.services.ec2.model.UnmonitorInstancesResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonEC2AsyncClient
extends AmazonEC2Client
implements AmazonEC2Async {
    private final ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AmazonEC2AsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonEC2AsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonEC2AsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonEC2AsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonEC2AsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonEC2AsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonEC2AsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonEC2AsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonEC2AsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<Void> rebootInstancesAsync(final RebootInstancesRequest rebootInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.rebootInstances(rebootInstancesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> rebootInstancesAsync(final RebootInstancesRequest rebootInstancesRequest, final AsyncHandler<RebootInstancesRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.rebootInstances(rebootInstancesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(rebootInstancesRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeReservedInstancesResult> describeReservedInstancesAsync(final DescribeReservedInstancesRequest describeReservedInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedInstancesResult>(){

            @Override
            public DescribeReservedInstancesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeReservedInstances(describeReservedInstancesRequest);
            }
        });
    }

    @Override
    public Future<DescribeReservedInstancesResult> describeReservedInstancesAsync(final DescribeReservedInstancesRequest describeReservedInstancesRequest, final AsyncHandler<DescribeReservedInstancesRequest, DescribeReservedInstancesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedInstancesResult>(){

            @Override
            public DescribeReservedInstancesResult call() throws Exception {
                DescribeReservedInstancesResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeReservedInstances(describeReservedInstancesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeReservedInstancesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateFlowLogsResult> createFlowLogsAsync(final CreateFlowLogsRequest createFlowLogsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateFlowLogsResult>(){

            @Override
            public CreateFlowLogsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createFlowLogs(createFlowLogsRequest);
            }
        });
    }

    @Override
    public Future<CreateFlowLogsResult> createFlowLogsAsync(final CreateFlowLogsRequest createFlowLogsRequest, final AsyncHandler<CreateFlowLogsRequest, CreateFlowLogsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateFlowLogsResult>(){

            @Override
            public CreateFlowLogsResult call() throws Exception {
                CreateFlowLogsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.createFlowLogs(createFlowLogsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createFlowLogsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAvailabilityZonesResult> describeAvailabilityZonesAsync(final DescribeAvailabilityZonesRequest describeAvailabilityZonesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAvailabilityZonesResult>(){

            @Override
            public DescribeAvailabilityZonesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeAvailabilityZones(describeAvailabilityZonesRequest);
            }
        });
    }

    @Override
    public Future<DescribeAvailabilityZonesResult> describeAvailabilityZonesAsync(final DescribeAvailabilityZonesRequest describeAvailabilityZonesRequest, final AsyncHandler<DescribeAvailabilityZonesRequest, DescribeAvailabilityZonesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAvailabilityZonesResult>(){

            @Override
            public DescribeAvailabilityZonesResult call() throws Exception {
                DescribeAvailabilityZonesResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeAvailabilityZones(describeAvailabilityZonesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeAvailabilityZonesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<RestoreAddressToClassicResult> restoreAddressToClassicAsync(final RestoreAddressToClassicRequest restoreAddressToClassicRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RestoreAddressToClassicResult>(){

            @Override
            public RestoreAddressToClassicResult call() throws Exception {
                return AmazonEC2AsyncClient.this.restoreAddressToClassic(restoreAddressToClassicRequest);
            }
        });
    }

    @Override
    public Future<RestoreAddressToClassicResult> restoreAddressToClassicAsync(final RestoreAddressToClassicRequest restoreAddressToClassicRequest, final AsyncHandler<RestoreAddressToClassicRequest, RestoreAddressToClassicResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RestoreAddressToClassicResult>(){

            @Override
            public RestoreAddressToClassicResult call() throws Exception {
                RestoreAddressToClassicResult result;
                try {
                    result = AmazonEC2AsyncClient.this.restoreAddressToClassic(restoreAddressToClassicRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(restoreAddressToClassicRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DetachVolumeResult> detachVolumeAsync(final DetachVolumeRequest detachVolumeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DetachVolumeResult>(){

            @Override
            public DetachVolumeResult call() throws Exception {
                return AmazonEC2AsyncClient.this.detachVolume(detachVolumeRequest);
            }
        });
    }

    @Override
    public Future<DetachVolumeResult> detachVolumeAsync(final DetachVolumeRequest detachVolumeRequest, final AsyncHandler<DetachVolumeRequest, DetachVolumeResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DetachVolumeResult>(){

            @Override
            public DetachVolumeResult call() throws Exception {
                DetachVolumeResult result;
                try {
                    result = AmazonEC2AsyncClient.this.detachVolume(detachVolumeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(detachVolumeRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteKeyPairAsync(final DeleteKeyPairRequest deleteKeyPairRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteKeyPair(deleteKeyPairRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteKeyPairAsync(final DeleteKeyPairRequest deleteKeyPairRequest, final AsyncHandler<DeleteKeyPairRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.deleteKeyPair(deleteKeyPairRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteKeyPairRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<UnmonitorInstancesResult> unmonitorInstancesAsync(final UnmonitorInstancesRequest unmonitorInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UnmonitorInstancesResult>(){

            @Override
            public UnmonitorInstancesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.unmonitorInstances(unmonitorInstancesRequest);
            }
        });
    }

    @Override
    public Future<UnmonitorInstancesResult> unmonitorInstancesAsync(final UnmonitorInstancesRequest unmonitorInstancesRequest, final AsyncHandler<UnmonitorInstancesRequest, UnmonitorInstancesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UnmonitorInstancesResult>(){

            @Override
            public UnmonitorInstancesResult call() throws Exception {
                UnmonitorInstancesResult result;
                try {
                    result = AmazonEC2AsyncClient.this.unmonitorInstances(unmonitorInstancesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(unmonitorInstancesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<AttachVpnGatewayResult> attachVpnGatewayAsync(final AttachVpnGatewayRequest attachVpnGatewayRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AttachVpnGatewayResult>(){

            @Override
            public AttachVpnGatewayResult call() throws Exception {
                return AmazonEC2AsyncClient.this.attachVpnGateway(attachVpnGatewayRequest);
            }
        });
    }

    @Override
    public Future<AttachVpnGatewayResult> attachVpnGatewayAsync(final AttachVpnGatewayRequest attachVpnGatewayRequest, final AsyncHandler<AttachVpnGatewayRequest, AttachVpnGatewayResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AttachVpnGatewayResult>(){

            @Override
            public AttachVpnGatewayResult call() throws Exception {
                AttachVpnGatewayResult result;
                try {
                    result = AmazonEC2AsyncClient.this.attachVpnGateway(attachVpnGatewayRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(attachVpnGatewayRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateImageResult> createImageAsync(final CreateImageRequest createImageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateImageResult>(){

            @Override
            public CreateImageResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createImage(createImageRequest);
            }
        });
    }

    @Override
    public Future<CreateImageResult> createImageAsync(final CreateImageRequest createImageRequest, final AsyncHandler<CreateImageRequest, CreateImageResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateImageResult>(){

            @Override
            public CreateImageResult call() throws Exception {
                CreateImageResult result;
                try {
                    result = AmazonEC2AsyncClient.this.createImage(createImageRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createImageRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteSecurityGroupAsync(final DeleteSecurityGroupRequest deleteSecurityGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteSecurityGroup(deleteSecurityGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteSecurityGroupAsync(final DeleteSecurityGroupRequest deleteSecurityGroupRequest, final AsyncHandler<DeleteSecurityGroupRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.deleteSecurityGroup(deleteSecurityGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteSecurityGroupRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<ModifyInstancePlacementResult> modifyInstancePlacementAsync(final ModifyInstancePlacementRequest modifyInstancePlacementRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifyInstancePlacementResult>(){

            @Override
            public ModifyInstancePlacementResult call() throws Exception {
                return AmazonEC2AsyncClient.this.modifyInstancePlacement(modifyInstancePlacementRequest);
            }
        });
    }

    @Override
    public Future<ModifyInstancePlacementResult> modifyInstancePlacementAsync(final ModifyInstancePlacementRequest modifyInstancePlacementRequest, final AsyncHandler<ModifyInstancePlacementRequest, ModifyInstancePlacementResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifyInstancePlacementResult>(){

            @Override
            public ModifyInstancePlacementResult call() throws Exception {
                ModifyInstancePlacementResult result;
                try {
                    result = AmazonEC2AsyncClient.this.modifyInstancePlacement(modifyInstancePlacementRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(modifyInstancePlacementRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeHostsResult> describeHostsAsync(final DescribeHostsRequest describeHostsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeHostsResult>(){

            @Override
            public DescribeHostsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeHosts(describeHostsRequest);
            }
        });
    }

    @Override
    public Future<DescribeHostsResult> describeHostsAsync(final DescribeHostsRequest describeHostsRequest, final AsyncHandler<DescribeHostsRequest, DescribeHostsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeHostsResult>(){

            @Override
            public DescribeHostsResult call() throws Exception {
                DescribeHostsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeHosts(describeHostsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeHostsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateInstanceExportTaskResult> createInstanceExportTaskAsync(final CreateInstanceExportTaskRequest createInstanceExportTaskRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateInstanceExportTaskResult>(){

            @Override
            public CreateInstanceExportTaskResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createInstanceExportTask(createInstanceExportTaskRequest);
            }
        });
    }

    @Override
    public Future<CreateInstanceExportTaskResult> createInstanceExportTaskAsync(final CreateInstanceExportTaskRequest createInstanceExportTaskRequest, final AsyncHandler<CreateInstanceExportTaskRequest, CreateInstanceExportTaskResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateInstanceExportTaskResult>(){

            @Override
            public CreateInstanceExportTaskResult call() throws Exception {
                CreateInstanceExportTaskResult result;
                try {
                    result = AmazonEC2AsyncClient.this.createInstanceExportTask(createInstanceExportTaskRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createInstanceExportTaskRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> authorizeSecurityGroupEgressAsync(final AuthorizeSecurityGroupEgressRequest authorizeSecurityGroupEgressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.authorizeSecurityGroupEgress(authorizeSecurityGroupEgressRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> authorizeSecurityGroupEgressAsync(final AuthorizeSecurityGroupEgressRequest authorizeSecurityGroupEgressRequest, final AsyncHandler<AuthorizeSecurityGroupEgressRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.authorizeSecurityGroupEgress(authorizeSecurityGroupEgressRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(authorizeSecurityGroupEgressRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> associateDhcpOptionsAsync(final AssociateDhcpOptionsRequest associateDhcpOptionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.associateDhcpOptions(associateDhcpOptionsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> associateDhcpOptionsAsync(final AssociateDhcpOptionsRequest associateDhcpOptionsRequest, final AsyncHandler<AssociateDhcpOptionsRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.associateDhcpOptions(associateDhcpOptionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(associateDhcpOptionsRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<GetPasswordDataResult> getPasswordDataAsync(final GetPasswordDataRequest getPasswordDataRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetPasswordDataResult>(){

            @Override
            public GetPasswordDataResult call() throws Exception {
                return AmazonEC2AsyncClient.this.getPasswordData(getPasswordDataRequest);
            }
        });
    }

    @Override
    public Future<GetPasswordDataResult> getPasswordDataAsync(final GetPasswordDataRequest getPasswordDataRequest, final AsyncHandler<GetPasswordDataRequest, GetPasswordDataResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetPasswordDataResult>(){

            @Override
            public GetPasswordDataResult call() throws Exception {
                GetPasswordDataResult result;
                try {
                    result = AmazonEC2AsyncClient.this.getPasswordData(getPasswordDataRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getPasswordDataRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<StopInstancesResult> stopInstancesAsync(final StopInstancesRequest stopInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<StopInstancesResult>(){

            @Override
            public StopInstancesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.stopInstances(stopInstancesRequest);
            }
        });
    }

    @Override
    public Future<StopInstancesResult> stopInstancesAsync(final StopInstancesRequest stopInstancesRequest, final AsyncHandler<StopInstancesRequest, StopInstancesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<StopInstancesResult>(){

            @Override
            public StopInstancesResult call() throws Exception {
                StopInstancesResult result;
                try {
                    result = AmazonEC2AsyncClient.this.stopInstances(stopInstancesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(stopInstancesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ImportKeyPairResult> importKeyPairAsync(final ImportKeyPairRequest importKeyPairRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ImportKeyPairResult>(){

            @Override
            public ImportKeyPairResult call() throws Exception {
                return AmazonEC2AsyncClient.this.importKeyPair(importKeyPairRequest);
            }
        });
    }

    @Override
    public Future<ImportKeyPairResult> importKeyPairAsync(final ImportKeyPairRequest importKeyPairRequest, final AsyncHandler<ImportKeyPairRequest, ImportKeyPairResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ImportKeyPairResult>(){

            @Override
            public ImportKeyPairResult call() throws Exception {
                ImportKeyPairResult result;
                try {
                    result = AmazonEC2AsyncClient.this.importKeyPair(importKeyPairRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(importKeyPairRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteNetworkInterfaceAsync(final DeleteNetworkInterfaceRequest deleteNetworkInterfaceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteNetworkInterface(deleteNetworkInterfaceRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteNetworkInterfaceAsync(final DeleteNetworkInterfaceRequest deleteNetworkInterfaceRequest, final AsyncHandler<DeleteNetworkInterfaceRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.deleteNetworkInterface(deleteNetworkInterfaceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteNetworkInterfaceRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> modifyVpcAttributeAsync(final ModifyVpcAttributeRequest modifyVpcAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.modifyVpcAttribute(modifyVpcAttributeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> modifyVpcAttributeAsync(final ModifyVpcAttributeRequest modifyVpcAttributeRequest, final AsyncHandler<ModifyVpcAttributeRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.modifyVpcAttribute(modifyVpcAttributeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(modifyVpcAttributeRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeSpotFleetInstancesResult> describeSpotFleetInstancesAsync(final DescribeSpotFleetInstancesRequest describeSpotFleetInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSpotFleetInstancesResult>(){

            @Override
            public DescribeSpotFleetInstancesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeSpotFleetInstances(describeSpotFleetInstancesRequest);
            }
        });
    }

    @Override
    public Future<DescribeSpotFleetInstancesResult> describeSpotFleetInstancesAsync(final DescribeSpotFleetInstancesRequest describeSpotFleetInstancesRequest, final AsyncHandler<DescribeSpotFleetInstancesRequest, DescribeSpotFleetInstancesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSpotFleetInstancesResult>(){

            @Override
            public DescribeSpotFleetInstancesResult call() throws Exception {
                DescribeSpotFleetInstancesResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeSpotFleetInstances(describeSpotFleetInstancesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeSpotFleetInstancesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateSecurityGroupResult> createSecurityGroupAsync(final CreateSecurityGroupRequest createSecurityGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateSecurityGroupResult>(){

            @Override
            public CreateSecurityGroupResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createSecurityGroup(createSecurityGroupRequest);
            }
        });
    }

    @Override
    public Future<CreateSecurityGroupResult> createSecurityGroupAsync(final CreateSecurityGroupRequest createSecurityGroupRequest, final AsyncHandler<CreateSecurityGroupRequest, CreateSecurityGroupResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateSecurityGroupResult>(){

            @Override
            public CreateSecurityGroupResult call() throws Exception {
                CreateSecurityGroupResult result;
                try {
                    result = AmazonEC2AsyncClient.this.createSecurityGroup(createSecurityGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createSecurityGroupRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSpotPriceHistoryResult> describeSpotPriceHistoryAsync(final DescribeSpotPriceHistoryRequest describeSpotPriceHistoryRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSpotPriceHistoryResult>(){

            @Override
            public DescribeSpotPriceHistoryResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeSpotPriceHistory(describeSpotPriceHistoryRequest);
            }
        });
    }

    @Override
    public Future<DescribeSpotPriceHistoryResult> describeSpotPriceHistoryAsync(final DescribeSpotPriceHistoryRequest describeSpotPriceHistoryRequest, final AsyncHandler<DescribeSpotPriceHistoryRequest, DescribeSpotPriceHistoryResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSpotPriceHistoryResult>(){

            @Override
            public DescribeSpotPriceHistoryResult call() throws Exception {
                DescribeSpotPriceHistoryResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeSpotPriceHistory(describeSpotPriceHistoryRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeSpotPriceHistoryRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRegionsResult> describeRegionsAsync(final DescribeRegionsRequest describeRegionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeRegionsResult>(){

            @Override
            public DescribeRegionsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeRegions(describeRegionsRequest);
            }
        });
    }

    @Override
    public Future<DescribeRegionsResult> describeRegionsAsync(final DescribeRegionsRequest describeRegionsRequest, final AsyncHandler<DescribeRegionsRequest, DescribeRegionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeRegionsResult>(){

            @Override
            public DescribeRegionsResult call() throws Exception {
                DescribeRegionsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeRegions(describeRegionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeRegionsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeNetworkInterfacesResult> describeNetworkInterfacesAsync(final DescribeNetworkInterfacesRequest describeNetworkInterfacesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeNetworkInterfacesResult>(){

            @Override
            public DescribeNetworkInterfacesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeNetworkInterfaces(describeNetworkInterfacesRequest);
            }
        });
    }

    @Override
    public Future<DescribeNetworkInterfacesResult> describeNetworkInterfacesAsync(final DescribeNetworkInterfacesRequest describeNetworkInterfacesRequest, final AsyncHandler<DescribeNetworkInterfacesRequest, DescribeNetworkInterfacesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeNetworkInterfacesResult>(){

            @Override
            public DescribeNetworkInterfacesResult call() throws Exception {
                DescribeNetworkInterfacesResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeNetworkInterfaces(describeNetworkInterfacesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeNetworkInterfacesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateDhcpOptionsResult> createDhcpOptionsAsync(final CreateDhcpOptionsRequest createDhcpOptionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateDhcpOptionsResult>(){

            @Override
            public CreateDhcpOptionsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createDhcpOptions(createDhcpOptionsRequest);
            }
        });
    }

    @Override
    public Future<CreateDhcpOptionsResult> createDhcpOptionsAsync(final CreateDhcpOptionsRequest createDhcpOptionsRequest, final AsyncHandler<CreateDhcpOptionsRequest, CreateDhcpOptionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateDhcpOptionsResult>(){

            @Override
            public CreateDhcpOptionsResult call() throws Exception {
                CreateDhcpOptionsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.createDhcpOptions(createDhcpOptionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createDhcpOptionsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateReservedInstancesListingResult> createReservedInstancesListingAsync(final CreateReservedInstancesListingRequest createReservedInstancesListingRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateReservedInstancesListingResult>(){

            @Override
            public CreateReservedInstancesListingResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createReservedInstancesListing(createReservedInstancesListingRequest);
            }
        });
    }

    @Override
    public Future<CreateReservedInstancesListingResult> createReservedInstancesListingAsync(final CreateReservedInstancesListingRequest createReservedInstancesListingRequest, final AsyncHandler<CreateReservedInstancesListingRequest, CreateReservedInstancesListingResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateReservedInstancesListingResult>(){

            @Override
            public CreateReservedInstancesListingResult call() throws Exception {
                CreateReservedInstancesListingResult result;
                try {
                    result = AmazonEC2AsyncClient.this.createReservedInstancesListing(createReservedInstancesListingRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createReservedInstancesListingRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteVpcEndpointsResult> deleteVpcEndpointsAsync(final DeleteVpcEndpointsRequest deleteVpcEndpointsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteVpcEndpointsResult>(){

            @Override
            public DeleteVpcEndpointsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.deleteVpcEndpoints(deleteVpcEndpointsRequest);
            }
        });
    }

    @Override
    public Future<DeleteVpcEndpointsResult> deleteVpcEndpointsAsync(final DeleteVpcEndpointsRequest deleteVpcEndpointsRequest, final AsyncHandler<DeleteVpcEndpointsRequest, DeleteVpcEndpointsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteVpcEndpointsResult>(){

            @Override
            public DeleteVpcEndpointsResult call() throws Exception {
                DeleteVpcEndpointsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.deleteVpcEndpoints(deleteVpcEndpointsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteVpcEndpointsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> resetSnapshotAttributeAsync(final ResetSnapshotAttributeRequest resetSnapshotAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.resetSnapshotAttribute(resetSnapshotAttributeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> resetSnapshotAttributeAsync(final ResetSnapshotAttributeRequest resetSnapshotAttributeRequest, final AsyncHandler<ResetSnapshotAttributeRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.resetSnapshotAttribute(resetSnapshotAttributeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(resetSnapshotAttributeRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteRouteAsync(final DeleteRouteRequest deleteRouteRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteRoute(deleteRouteRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteRouteAsync(final DeleteRouteRequest deleteRouteRequest, final AsyncHandler<DeleteRouteRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.deleteRoute(deleteRouteRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteRouteRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeInternetGatewaysResult> describeInternetGatewaysAsync(final DescribeInternetGatewaysRequest describeInternetGatewaysRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeInternetGatewaysResult>(){

            @Override
            public DescribeInternetGatewaysResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeInternetGateways(describeInternetGatewaysRequest);
            }
        });
    }

    @Override
    public Future<DescribeInternetGatewaysResult> describeInternetGatewaysAsync(final DescribeInternetGatewaysRequest describeInternetGatewaysRequest, final AsyncHandler<DescribeInternetGatewaysRequest, DescribeInternetGatewaysResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeInternetGatewaysResult>(){

            @Override
            public DescribeInternetGatewaysResult call() throws Exception {
                DescribeInternetGatewaysResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeInternetGateways(describeInternetGatewaysRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeInternetGatewaysRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ImportVolumeResult> importVolumeAsync(final ImportVolumeRequest importVolumeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ImportVolumeResult>(){

            @Override
            public ImportVolumeResult call() throws Exception {
                return AmazonEC2AsyncClient.this.importVolume(importVolumeRequest);
            }
        });
    }

    @Override
    public Future<ImportVolumeResult> importVolumeAsync(final ImportVolumeRequest importVolumeRequest, final AsyncHandler<ImportVolumeRequest, ImportVolumeResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ImportVolumeResult>(){

            @Override
            public ImportVolumeResult call() throws Exception {
                ImportVolumeResult result;
                try {
                    result = AmazonEC2AsyncClient.this.importVolume(importVolumeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(importVolumeRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSecurityGroupsResult> describeSecurityGroupsAsync(final DescribeSecurityGroupsRequest describeSecurityGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSecurityGroupsResult>(){

            @Override
            public DescribeSecurityGroupsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeSecurityGroups(describeSecurityGroupsRequest);
            }
        });
    }

    @Override
    public Future<DescribeSecurityGroupsResult> describeSecurityGroupsAsync(final DescribeSecurityGroupsRequest describeSecurityGroupsRequest, final AsyncHandler<DescribeSecurityGroupsRequest, DescribeSecurityGroupsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSecurityGroupsResult>(){

            @Override
            public DescribeSecurityGroupsResult call() throws Exception {
                DescribeSecurityGroupsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeSecurityGroups(describeSecurityGroupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeSecurityGroupsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<RejectVpcPeeringConnectionResult> rejectVpcPeeringConnectionAsync(final RejectVpcPeeringConnectionRequest rejectVpcPeeringConnectionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RejectVpcPeeringConnectionResult>(){

            @Override
            public RejectVpcPeeringConnectionResult call() throws Exception {
                return AmazonEC2AsyncClient.this.rejectVpcPeeringConnection(rejectVpcPeeringConnectionRequest);
            }
        });
    }

    @Override
    public Future<RejectVpcPeeringConnectionResult> rejectVpcPeeringConnectionAsync(final RejectVpcPeeringConnectionRequest rejectVpcPeeringConnectionRequest, final AsyncHandler<RejectVpcPeeringConnectionRequest, RejectVpcPeeringConnectionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RejectVpcPeeringConnectionResult>(){

            @Override
            public RejectVpcPeeringConnectionResult call() throws Exception {
                RejectVpcPeeringConnectionResult result;
                try {
                    result = AmazonEC2AsyncClient.this.rejectVpcPeeringConnection(rejectVpcPeeringConnectionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(rejectVpcPeeringConnectionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteFlowLogsResult> deleteFlowLogsAsync(final DeleteFlowLogsRequest deleteFlowLogsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteFlowLogsResult>(){

            @Override
            public DeleteFlowLogsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.deleteFlowLogs(deleteFlowLogsRequest);
            }
        });
    }

    @Override
    public Future<DeleteFlowLogsResult> deleteFlowLogsAsync(final DeleteFlowLogsRequest deleteFlowLogsRequest, final AsyncHandler<DeleteFlowLogsRequest, DeleteFlowLogsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteFlowLogsResult>(){

            @Override
            public DeleteFlowLogsResult call() throws Exception {
                DeleteFlowLogsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.deleteFlowLogs(deleteFlowLogsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteFlowLogsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> detachVpnGatewayAsync(final DetachVpnGatewayRequest detachVpnGatewayRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.detachVpnGateway(detachVpnGatewayRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> detachVpnGatewayAsync(final DetachVpnGatewayRequest detachVpnGatewayRequest, final AsyncHandler<DetachVpnGatewayRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.detachVpnGateway(detachVpnGatewayRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(detachVpnGatewayRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deregisterImageAsync(final DeregisterImageRequest deregisterImageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deregisterImage(deregisterImageRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deregisterImageAsync(final DeregisterImageRequest deregisterImageRequest, final AsyncHandler<DeregisterImageRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.deregisterImage(deregisterImageRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deregisterImageRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeSpotDatafeedSubscriptionResult> describeSpotDatafeedSubscriptionAsync(final DescribeSpotDatafeedSubscriptionRequest describeSpotDatafeedSubscriptionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSpotDatafeedSubscriptionResult>(){

            @Override
            public DescribeSpotDatafeedSubscriptionResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeSpotDatafeedSubscription(describeSpotDatafeedSubscriptionRequest);
            }
        });
    }

    @Override
    public Future<DescribeSpotDatafeedSubscriptionResult> describeSpotDatafeedSubscriptionAsync(final DescribeSpotDatafeedSubscriptionRequest describeSpotDatafeedSubscriptionRequest, final AsyncHandler<DescribeSpotDatafeedSubscriptionRequest, DescribeSpotDatafeedSubscriptionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSpotDatafeedSubscriptionResult>(){

            @Override
            public DescribeSpotDatafeedSubscriptionResult call() throws Exception {
                DescribeSpotDatafeedSubscriptionResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeSpotDatafeedSubscription(describeSpotDatafeedSubscriptionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeSpotDatafeedSubscriptionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteTagsAsync(final DeleteTagsRequest deleteTagsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteTags(deleteTagsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteTagsAsync(final DeleteTagsRequest deleteTagsRequest, final AsyncHandler<DeleteTagsRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.deleteTags(deleteTagsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteTagsRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<ReleaseHostsResult> releaseHostsAsync(final ReleaseHostsRequest releaseHostsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReleaseHostsResult>(){

            @Override
            public ReleaseHostsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.releaseHosts(releaseHostsRequest);
            }
        });
    }

    @Override
    public Future<ReleaseHostsResult> releaseHostsAsync(final ReleaseHostsRequest releaseHostsRequest, final AsyncHandler<ReleaseHostsRequest, ReleaseHostsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReleaseHostsResult>(){

            @Override
            public ReleaseHostsResult call() throws Exception {
                ReleaseHostsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.releaseHosts(releaseHostsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(releaseHostsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteSubnetAsync(final DeleteSubnetRequest deleteSubnetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteSubnet(deleteSubnetRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteSubnetAsync(final DeleteSubnetRequest deleteSubnetRequest, final AsyncHandler<DeleteSubnetRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.deleteSubnet(deleteSubnetRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteSubnetRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeAccountAttributesResult> describeAccountAttributesAsync(final DescribeAccountAttributesRequest describeAccountAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAccountAttributesResult>(){

            @Override
            public DescribeAccountAttributesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeAccountAttributes(describeAccountAttributesRequest);
            }
        });
    }

    @Override
    public Future<DescribeAccountAttributesResult> describeAccountAttributesAsync(final DescribeAccountAttributesRequest describeAccountAttributesRequest, final AsyncHandler<DescribeAccountAttributesRequest, DescribeAccountAttributesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAccountAttributesResult>(){

            @Override
            public DescribeAccountAttributesResult call() throws Exception {
                DescribeAccountAttributesResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeAccountAttributes(describeAccountAttributesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeAccountAttributesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<AttachClassicLinkVpcResult> attachClassicLinkVpcAsync(final AttachClassicLinkVpcRequest attachClassicLinkVpcRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AttachClassicLinkVpcResult>(){

            @Override
            public AttachClassicLinkVpcResult call() throws Exception {
                return AmazonEC2AsyncClient.this.attachClassicLinkVpc(attachClassicLinkVpcRequest);
            }
        });
    }

    @Override
    public Future<AttachClassicLinkVpcResult> attachClassicLinkVpcAsync(final AttachClassicLinkVpcRequest attachClassicLinkVpcRequest, final AsyncHandler<AttachClassicLinkVpcRequest, AttachClassicLinkVpcResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AttachClassicLinkVpcResult>(){

            @Override
            public AttachClassicLinkVpcResult call() throws Exception {
                AttachClassicLinkVpcResult result;
                try {
                    result = AmazonEC2AsyncClient.this.attachClassicLinkVpc(attachClassicLinkVpcRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(attachClassicLinkVpcRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateVpnGatewayResult> createVpnGatewayAsync(final CreateVpnGatewayRequest createVpnGatewayRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateVpnGatewayResult>(){

            @Override
            public CreateVpnGatewayResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createVpnGateway(createVpnGatewayRequest);
            }
        });
    }

    @Override
    public Future<CreateVpnGatewayResult> createVpnGatewayAsync(final CreateVpnGatewayRequest createVpnGatewayRequest, final AsyncHandler<CreateVpnGatewayRequest, CreateVpnGatewayResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateVpnGatewayResult>(){

            @Override
            public CreateVpnGatewayResult call() throws Exception {
                CreateVpnGatewayResult result;
                try {
                    result = AmazonEC2AsyncClient.this.createVpnGateway(createVpnGatewayRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createVpnGatewayRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> enableVolumeIOAsync(final EnableVolumeIORequest enableVolumeIORequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.enableVolumeIO(enableVolumeIORequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> enableVolumeIOAsync(final EnableVolumeIORequest enableVolumeIORequest, final AsyncHandler<EnableVolumeIORequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.enableVolumeIO(enableVolumeIORequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(enableVolumeIORequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<MoveAddressToVpcResult> moveAddressToVpcAsync(final MoveAddressToVpcRequest moveAddressToVpcRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<MoveAddressToVpcResult>(){

            @Override
            public MoveAddressToVpcResult call() throws Exception {
                return AmazonEC2AsyncClient.this.moveAddressToVpc(moveAddressToVpcRequest);
            }
        });
    }

    @Override
    public Future<MoveAddressToVpcResult> moveAddressToVpcAsync(final MoveAddressToVpcRequest moveAddressToVpcRequest, final AsyncHandler<MoveAddressToVpcRequest, MoveAddressToVpcResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<MoveAddressToVpcResult>(){

            @Override
            public MoveAddressToVpcResult call() throws Exception {
                MoveAddressToVpcResult result;
                try {
                    result = AmazonEC2AsyncClient.this.moveAddressToVpc(moveAddressToVpcRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(moveAddressToVpcRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteVpnGatewayAsync(final DeleteVpnGatewayRequest deleteVpnGatewayRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteVpnGateway(deleteVpnGatewayRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteVpnGatewayAsync(final DeleteVpnGatewayRequest deleteVpnGatewayRequest, final AsyncHandler<DeleteVpnGatewayRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.deleteVpnGateway(deleteVpnGatewayRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteVpnGatewayRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<AttachVolumeResult> attachVolumeAsync(final AttachVolumeRequest attachVolumeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AttachVolumeResult>(){

            @Override
            public AttachVolumeResult call() throws Exception {
                return AmazonEC2AsyncClient.this.attachVolume(attachVolumeRequest);
            }
        });
    }

    @Override
    public Future<AttachVolumeResult> attachVolumeAsync(final AttachVolumeRequest attachVolumeRequest, final AsyncHandler<AttachVolumeRequest, AttachVolumeResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AttachVolumeResult>(){

            @Override
            public AttachVolumeResult call() throws Exception {
                AttachVolumeResult result;
                try {
                    result = AmazonEC2AsyncClient.this.attachVolume(attachVolumeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(attachVolumeRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeVolumeStatusResult> describeVolumeStatusAsync(final DescribeVolumeStatusRequest describeVolumeStatusRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVolumeStatusResult>(){

            @Override
            public DescribeVolumeStatusResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeVolumeStatus(describeVolumeStatusRequest);
            }
        });
    }

    @Override
    public Future<DescribeVolumeStatusResult> describeVolumeStatusAsync(final DescribeVolumeStatusRequest describeVolumeStatusRequest, final AsyncHandler<DescribeVolumeStatusRequest, DescribeVolumeStatusResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVolumeStatusResult>(){

            @Override
            public DescribeVolumeStatusResult call() throws Exception {
                DescribeVolumeStatusResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeVolumeStatus(describeVolumeStatusRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeVolumeStatusRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeImportSnapshotTasksResult> describeImportSnapshotTasksAsync(final DescribeImportSnapshotTasksRequest describeImportSnapshotTasksRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeImportSnapshotTasksResult>(){

            @Override
            public DescribeImportSnapshotTasksResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeImportSnapshotTasks(describeImportSnapshotTasksRequest);
            }
        });
    }

    @Override
    public Future<DescribeImportSnapshotTasksResult> describeImportSnapshotTasksAsync(final DescribeImportSnapshotTasksRequest describeImportSnapshotTasksRequest, final AsyncHandler<DescribeImportSnapshotTasksRequest, DescribeImportSnapshotTasksResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeImportSnapshotTasksResult>(){

            @Override
            public DescribeImportSnapshotTasksResult call() throws Exception {
                DescribeImportSnapshotTasksResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeImportSnapshotTasks(describeImportSnapshotTasksRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeImportSnapshotTasksRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeVpnConnectionsResult> describeVpnConnectionsAsync(final DescribeVpnConnectionsRequest describeVpnConnectionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVpnConnectionsResult>(){

            @Override
            public DescribeVpnConnectionsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeVpnConnections(describeVpnConnectionsRequest);
            }
        });
    }

    @Override
    public Future<DescribeVpnConnectionsResult> describeVpnConnectionsAsync(final DescribeVpnConnectionsRequest describeVpnConnectionsRequest, final AsyncHandler<DescribeVpnConnectionsRequest, DescribeVpnConnectionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVpnConnectionsResult>(){

            @Override
            public DescribeVpnConnectionsResult call() throws Exception {
                DescribeVpnConnectionsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeVpnConnections(describeVpnConnectionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeVpnConnectionsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> resetImageAttributeAsync(final ResetImageAttributeRequest resetImageAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.resetImageAttribute(resetImageAttributeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> resetImageAttributeAsync(final ResetImageAttributeRequest resetImageAttributeRequest, final AsyncHandler<ResetImageAttributeRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.resetImageAttribute(resetImageAttributeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(resetImageAttributeRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> enableVgwRoutePropagationAsync(final EnableVgwRoutePropagationRequest enableVgwRoutePropagationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.enableVgwRoutePropagation(enableVgwRoutePropagationRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> enableVgwRoutePropagationAsync(final EnableVgwRoutePropagationRequest enableVgwRoutePropagationRequest, final AsyncHandler<EnableVgwRoutePropagationRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.enableVgwRoutePropagation(enableVgwRoutePropagationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(enableVgwRoutePropagationRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<CreateSnapshotResult> createSnapshotAsync(final CreateSnapshotRequest createSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateSnapshotResult>(){

            @Override
            public CreateSnapshotResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createSnapshot(createSnapshotRequest);
            }
        });
    }

    @Override
    public Future<CreateSnapshotResult> createSnapshotAsync(final CreateSnapshotRequest createSnapshotRequest, final AsyncHandler<CreateSnapshotRequest, CreateSnapshotResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateSnapshotResult>(){

            @Override
            public CreateSnapshotResult call() throws Exception {
                CreateSnapshotResult result;
                try {
                    result = AmazonEC2AsyncClient.this.createSnapshot(createSnapshotRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createSnapshotRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteVolumeAsync(final DeleteVolumeRequest deleteVolumeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteVolume(deleteVolumeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteVolumeAsync(final DeleteVolumeRequest deleteVolumeRequest, final AsyncHandler<DeleteVolumeRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.deleteVolume(deleteVolumeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteVolumeRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<CreateNetworkInterfaceResult> createNetworkInterfaceAsync(final CreateNetworkInterfaceRequest createNetworkInterfaceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateNetworkInterfaceResult>(){

            @Override
            public CreateNetworkInterfaceResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createNetworkInterface(createNetworkInterfaceRequest);
            }
        });
    }

    @Override
    public Future<CreateNetworkInterfaceResult> createNetworkInterfaceAsync(final CreateNetworkInterfaceRequest createNetworkInterfaceRequest, final AsyncHandler<CreateNetworkInterfaceRequest, CreateNetworkInterfaceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateNetworkInterfaceResult>(){

            @Override
            public CreateNetworkInterfaceResult call() throws Exception {
                CreateNetworkInterfaceResult result;
                try {
                    result = AmazonEC2AsyncClient.this.createNetworkInterface(createNetworkInterfaceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createNetworkInterfaceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ModifyReservedInstancesResult> modifyReservedInstancesAsync(final ModifyReservedInstancesRequest modifyReservedInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifyReservedInstancesResult>(){

            @Override
            public ModifyReservedInstancesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.modifyReservedInstances(modifyReservedInstancesRequest);
            }
        });
    }

    @Override
    public Future<ModifyReservedInstancesResult> modifyReservedInstancesAsync(final ModifyReservedInstancesRequest modifyReservedInstancesRequest, final AsyncHandler<ModifyReservedInstancesRequest, ModifyReservedInstancesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifyReservedInstancesResult>(){

            @Override
            public ModifyReservedInstancesResult call() throws Exception {
                ModifyReservedInstancesResult result;
                try {
                    result = AmazonEC2AsyncClient.this.modifyReservedInstances(modifyReservedInstancesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(modifyReservedInstancesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CancelSpotFleetRequestsResult> cancelSpotFleetRequestsAsync(final CancelSpotFleetRequestsRequest cancelSpotFleetRequestsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CancelSpotFleetRequestsResult>(){

            @Override
            public CancelSpotFleetRequestsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.cancelSpotFleetRequests(cancelSpotFleetRequestsRequest);
            }
        });
    }

    @Override
    public Future<CancelSpotFleetRequestsResult> cancelSpotFleetRequestsAsync(final CancelSpotFleetRequestsRequest cancelSpotFleetRequestsRequest, final AsyncHandler<CancelSpotFleetRequestsRequest, CancelSpotFleetRequestsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CancelSpotFleetRequestsResult>(){

            @Override
            public CancelSpotFleetRequestsResult call() throws Exception {
                CancelSpotFleetRequestsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.cancelSpotFleetRequests(cancelSpotFleetRequestsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(cancelSpotFleetRequestsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> unassignPrivateIpAddressesAsync(final UnassignPrivateIpAddressesRequest unassignPrivateIpAddressesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.unassignPrivateIpAddresses(unassignPrivateIpAddressesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> unassignPrivateIpAddressesAsync(final UnassignPrivateIpAddressesRequest unassignPrivateIpAddressesRequest, final AsyncHandler<UnassignPrivateIpAddressesRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.unassignPrivateIpAddresses(unassignPrivateIpAddressesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(unassignPrivateIpAddressesRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeVpcsResult> describeVpcsAsync(final DescribeVpcsRequest describeVpcsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVpcsResult>(){

            @Override
            public DescribeVpcsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeVpcs(describeVpcsRequest);
            }
        });
    }

    @Override
    public Future<DescribeVpcsResult> describeVpcsAsync(final DescribeVpcsRequest describeVpcsRequest, final AsyncHandler<DescribeVpcsRequest, DescribeVpcsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVpcsResult>(){

            @Override
            public DescribeVpcsResult call() throws Exception {
                DescribeVpcsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeVpcs(describeVpcsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeVpcsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> cancelConversionTaskAsync(final CancelConversionTaskRequest cancelConversionTaskRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.cancelConversionTask(cancelConversionTaskRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> cancelConversionTaskAsync(final CancelConversionTaskRequest cancelConversionTaskRequest, final AsyncHandler<CancelConversionTaskRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.cancelConversionTask(cancelConversionTaskRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(cancelConversionTaskRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<AssociateAddressResult> associateAddressAsync(final AssociateAddressRequest associateAddressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AssociateAddressResult>(){

            @Override
            public AssociateAddressResult call() throws Exception {
                return AmazonEC2AsyncClient.this.associateAddress(associateAddressRequest);
            }
        });
    }

    @Override
    public Future<AssociateAddressResult> associateAddressAsync(final AssociateAddressRequest associateAddressRequest, final AsyncHandler<AssociateAddressRequest, AssociateAddressResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AssociateAddressResult>(){

            @Override
            public AssociateAddressResult call() throws Exception {
                AssociateAddressResult result;
                try {
                    result = AmazonEC2AsyncClient.this.associateAddress(associateAddressRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(associateAddressRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteCustomerGatewayAsync(final DeleteCustomerGatewayRequest deleteCustomerGatewayRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteCustomerGateway(deleteCustomerGatewayRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteCustomerGatewayAsync(final DeleteCustomerGatewayRequest deleteCustomerGatewayRequest, final AsyncHandler<DeleteCustomerGatewayRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.deleteCustomerGateway(deleteCustomerGatewayRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteCustomerGatewayRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createNetworkAclEntryAsync(final CreateNetworkAclEntryRequest createNetworkAclEntryRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.createNetworkAclEntry(createNetworkAclEntryRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createNetworkAclEntryAsync(final CreateNetworkAclEntryRequest createNetworkAclEntryRequest, final AsyncHandler<CreateNetworkAclEntryRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.createNetworkAclEntry(createNetworkAclEntryRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createNetworkAclEntryRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<AcceptVpcPeeringConnectionResult> acceptVpcPeeringConnectionAsync(final AcceptVpcPeeringConnectionRequest acceptVpcPeeringConnectionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AcceptVpcPeeringConnectionResult>(){

            @Override
            public AcceptVpcPeeringConnectionResult call() throws Exception {
                return AmazonEC2AsyncClient.this.acceptVpcPeeringConnection(acceptVpcPeeringConnectionRequest);
            }
        });
    }

    @Override
    public Future<AcceptVpcPeeringConnectionResult> acceptVpcPeeringConnectionAsync(final AcceptVpcPeeringConnectionRequest acceptVpcPeeringConnectionRequest, final AsyncHandler<AcceptVpcPeeringConnectionRequest, AcceptVpcPeeringConnectionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AcceptVpcPeeringConnectionResult>(){

            @Override
            public AcceptVpcPeeringConnectionResult call() throws Exception {
                AcceptVpcPeeringConnectionResult result;
                try {
                    result = AmazonEC2AsyncClient.this.acceptVpcPeeringConnection(acceptVpcPeeringConnectionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(acceptVpcPeeringConnectionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeExportTasksResult> describeExportTasksAsync(final DescribeExportTasksRequest describeExportTasksRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeExportTasksResult>(){

            @Override
            public DescribeExportTasksResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeExportTasks(describeExportTasksRequest);
            }
        });
    }

    @Override
    public Future<DescribeExportTasksResult> describeExportTasksAsync(final DescribeExportTasksRequest describeExportTasksRequest, final AsyncHandler<DescribeExportTasksRequest, DescribeExportTasksResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeExportTasksResult>(){

            @Override
            public DescribeExportTasksResult call() throws Exception {
                DescribeExportTasksResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeExportTasks(describeExportTasksRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeExportTasksRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> detachInternetGatewayAsync(final DetachInternetGatewayRequest detachInternetGatewayRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.detachInternetGateway(detachInternetGatewayRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> detachInternetGatewayAsync(final DetachInternetGatewayRequest detachInternetGatewayRequest, final AsyncHandler<DetachInternetGatewayRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.detachInternetGateway(detachInternetGatewayRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(detachInternetGatewayRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<CreateVpcPeeringConnectionResult> createVpcPeeringConnectionAsync(final CreateVpcPeeringConnectionRequest createVpcPeeringConnectionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateVpcPeeringConnectionResult>(){

            @Override
            public CreateVpcPeeringConnectionResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createVpcPeeringConnection(createVpcPeeringConnectionRequest);
            }
        });
    }

    @Override
    public Future<CreateVpcPeeringConnectionResult> createVpcPeeringConnectionAsync(final CreateVpcPeeringConnectionRequest createVpcPeeringConnectionRequest, final AsyncHandler<CreateVpcPeeringConnectionRequest, CreateVpcPeeringConnectionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateVpcPeeringConnectionResult>(){

            @Override
            public CreateVpcPeeringConnectionResult call() throws Exception {
                CreateVpcPeeringConnectionResult result;
                try {
                    result = AmazonEC2AsyncClient.this.createVpcPeeringConnection(createVpcPeeringConnectionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createVpcPeeringConnectionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateRouteTableResult> createRouteTableAsync(final CreateRouteTableRequest createRouteTableRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateRouteTableResult>(){

            @Override
            public CreateRouteTableResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createRouteTable(createRouteTableRequest);
            }
        });
    }

    @Override
    public Future<CreateRouteTableResult> createRouteTableAsync(final CreateRouteTableRequest createRouteTableRequest, final AsyncHandler<CreateRouteTableRequest, CreateRouteTableResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateRouteTableResult>(){

            @Override
            public CreateRouteTableResult call() throws Exception {
                CreateRouteTableResult result;
                try {
                    result = AmazonEC2AsyncClient.this.createRouteTable(createRouteTableRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createRouteTableRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CancelImportTaskResult> cancelImportTaskAsync(final CancelImportTaskRequest cancelImportTaskRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CancelImportTaskResult>(){

            @Override
            public CancelImportTaskResult call() throws Exception {
                return AmazonEC2AsyncClient.this.cancelImportTask(cancelImportTaskRequest);
            }
        });
    }

    @Override
    public Future<CancelImportTaskResult> cancelImportTaskAsync(final CancelImportTaskRequest cancelImportTaskRequest, final AsyncHandler<CancelImportTaskRequest, CancelImportTaskResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CancelImportTaskResult>(){

            @Override
            public CancelImportTaskResult call() throws Exception {
                CancelImportTaskResult result;
                try {
                    result = AmazonEC2AsyncClient.this.cancelImportTask(cancelImportTaskRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(cancelImportTaskRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeVolumesResult> describeVolumesAsync(final DescribeVolumesRequest describeVolumesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVolumesResult>(){

            @Override
            public DescribeVolumesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeVolumes(describeVolumesRequest);
            }
        });
    }

    @Override
    public Future<DescribeVolumesResult> describeVolumesAsync(final DescribeVolumesRequest describeVolumesRequest, final AsyncHandler<DescribeVolumesRequest, DescribeVolumesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVolumesResult>(){

            @Override
            public DescribeVolumesResult call() throws Exception {
                DescribeVolumesResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeVolumes(describeVolumesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeVolumesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReservedInstancesListingsResult> describeReservedInstancesListingsAsync(final DescribeReservedInstancesListingsRequest describeReservedInstancesListingsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedInstancesListingsResult>(){

            @Override
            public DescribeReservedInstancesListingsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeReservedInstancesListings(describeReservedInstancesListingsRequest);
            }
        });
    }

    @Override
    public Future<DescribeReservedInstancesListingsResult> describeReservedInstancesListingsAsync(final DescribeReservedInstancesListingsRequest describeReservedInstancesListingsRequest, final AsyncHandler<DescribeReservedInstancesListingsRequest, DescribeReservedInstancesListingsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedInstancesListingsResult>(){

            @Override
            public DescribeReservedInstancesListingsResult call() throws Exception {
                DescribeReservedInstancesListingsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeReservedInstancesListings(describeReservedInstancesListingsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeReservedInstancesListingsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> reportInstanceStatusAsync(final ReportInstanceStatusRequest reportInstanceStatusRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.reportInstanceStatus(reportInstanceStatusRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> reportInstanceStatusAsync(final ReportInstanceStatusRequest reportInstanceStatusRequest, final AsyncHandler<ReportInstanceStatusRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.reportInstanceStatus(reportInstanceStatusRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(reportInstanceStatusRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeRouteTablesResult> describeRouteTablesAsync(final DescribeRouteTablesRequest describeRouteTablesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeRouteTablesResult>(){

            @Override
            public DescribeRouteTablesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeRouteTables(describeRouteTablesRequest);
            }
        });
    }

    @Override
    public Future<DescribeRouteTablesResult> describeRouteTablesAsync(final DescribeRouteTablesRequest describeRouteTablesRequest, final AsyncHandler<DescribeRouteTablesRequest, DescribeRouteTablesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeRouteTablesResult>(){

            @Override
            public DescribeRouteTablesResult call() throws Exception {
                DescribeRouteTablesResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeRouteTables(describeRouteTablesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeRouteTablesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDhcpOptionsResult> describeDhcpOptionsAsync(final DescribeDhcpOptionsRequest describeDhcpOptionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDhcpOptionsResult>(){

            @Override
            public DescribeDhcpOptionsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeDhcpOptions(describeDhcpOptionsRequest);
            }
        });
    }

    @Override
    public Future<DescribeDhcpOptionsResult> describeDhcpOptionsAsync(final DescribeDhcpOptionsRequest describeDhcpOptionsRequest, final AsyncHandler<DescribeDhcpOptionsRequest, DescribeDhcpOptionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDhcpOptionsResult>(){

            @Override
            public DescribeDhcpOptionsResult call() throws Exception {
                DescribeDhcpOptionsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeDhcpOptions(describeDhcpOptionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeDhcpOptionsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<MonitorInstancesResult> monitorInstancesAsync(final MonitorInstancesRequest monitorInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<MonitorInstancesResult>(){

            @Override
            public MonitorInstancesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.monitorInstances(monitorInstancesRequest);
            }
        });
    }

    @Override
    public Future<MonitorInstancesResult> monitorInstancesAsync(final MonitorInstancesRequest monitorInstancesRequest, final AsyncHandler<MonitorInstancesRequest, MonitorInstancesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<MonitorInstancesResult>(){

            @Override
            public MonitorInstancesResult call() throws Exception {
                MonitorInstancesResult result;
                try {
                    result = AmazonEC2AsyncClient.this.monitorInstances(monitorInstancesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(monitorInstancesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribePrefixListsResult> describePrefixListsAsync(final DescribePrefixListsRequest describePrefixListsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribePrefixListsResult>(){

            @Override
            public DescribePrefixListsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describePrefixLists(describePrefixListsRequest);
            }
        });
    }

    @Override
    public Future<DescribePrefixListsResult> describePrefixListsAsync(final DescribePrefixListsRequest describePrefixListsRequest, final AsyncHandler<DescribePrefixListsRequest, DescribePrefixListsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribePrefixListsResult>(){

            @Override
            public DescribePrefixListsResult call() throws Exception {
                DescribePrefixListsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describePrefixLists(describePrefixListsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describePrefixListsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<RequestSpotFleetResult> requestSpotFleetAsync(final RequestSpotFleetRequest requestSpotFleetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RequestSpotFleetResult>(){

            @Override
            public RequestSpotFleetResult call() throws Exception {
                return AmazonEC2AsyncClient.this.requestSpotFleet(requestSpotFleetRequest);
            }
        });
    }

    @Override
    public Future<RequestSpotFleetResult> requestSpotFleetAsync(final RequestSpotFleetRequest requestSpotFleetRequest, final AsyncHandler<RequestSpotFleetRequest, RequestSpotFleetResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RequestSpotFleetResult>(){

            @Override
            public RequestSpotFleetResult call() throws Exception {
                RequestSpotFleetResult result;
                try {
                    result = AmazonEC2AsyncClient.this.requestSpotFleet(requestSpotFleetRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(requestSpotFleetRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeImportImageTasksResult> describeImportImageTasksAsync(final DescribeImportImageTasksRequest describeImportImageTasksRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeImportImageTasksResult>(){

            @Override
            public DescribeImportImageTasksResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeImportImageTasks(describeImportImageTasksRequest);
            }
        });
    }

    @Override
    public Future<DescribeImportImageTasksResult> describeImportImageTasksAsync(final DescribeImportImageTasksRequest describeImportImageTasksRequest, final AsyncHandler<DescribeImportImageTasksRequest, DescribeImportImageTasksResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeImportImageTasksResult>(){

            @Override
            public DescribeImportImageTasksResult call() throws Exception {
                DescribeImportImageTasksResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeImportImageTasks(describeImportImageTasksRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeImportImageTasksRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeNetworkAclsResult> describeNetworkAclsAsync(final DescribeNetworkAclsRequest describeNetworkAclsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeNetworkAclsResult>(){

            @Override
            public DescribeNetworkAclsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeNetworkAcls(describeNetworkAclsRequest);
            }
        });
    }

    @Override
    public Future<DescribeNetworkAclsResult> describeNetworkAclsAsync(final DescribeNetworkAclsRequest describeNetworkAclsRequest, final AsyncHandler<DescribeNetworkAclsRequest, DescribeNetworkAclsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeNetworkAclsResult>(){

            @Override
            public DescribeNetworkAclsResult call() throws Exception {
                DescribeNetworkAclsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeNetworkAcls(describeNetworkAclsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeNetworkAclsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeBundleTasksResult> describeBundleTasksAsync(final DescribeBundleTasksRequest describeBundleTasksRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeBundleTasksResult>(){

            @Override
            public DescribeBundleTasksResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeBundleTasks(describeBundleTasksRequest);
            }
        });
    }

    @Override
    public Future<DescribeBundleTasksResult> describeBundleTasksAsync(final DescribeBundleTasksRequest describeBundleTasksRequest, final AsyncHandler<DescribeBundleTasksRequest, DescribeBundleTasksResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeBundleTasksResult>(){

            @Override
            public DescribeBundleTasksResult call() throws Exception {
                DescribeBundleTasksResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeBundleTasks(describeBundleTasksRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeBundleTasksRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ImportInstanceResult> importInstanceAsync(final ImportInstanceRequest importInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ImportInstanceResult>(){

            @Override
            public ImportInstanceResult call() throws Exception {
                return AmazonEC2AsyncClient.this.importInstance(importInstanceRequest);
            }
        });
    }

    @Override
    public Future<ImportInstanceResult> importInstanceAsync(final ImportInstanceRequest importInstanceRequest, final AsyncHandler<ImportInstanceRequest, ImportInstanceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ImportInstanceResult>(){

            @Override
            public ImportInstanceResult call() throws Exception {
                ImportInstanceResult result;
                try {
                    result = AmazonEC2AsyncClient.this.importInstance(importInstanceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(importInstanceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> revokeSecurityGroupIngressAsync(final RevokeSecurityGroupIngressRequest revokeSecurityGroupIngressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.revokeSecurityGroupIngress(revokeSecurityGroupIngressRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> revokeSecurityGroupIngressAsync(final RevokeSecurityGroupIngressRequest revokeSecurityGroupIngressRequest, final AsyncHandler<RevokeSecurityGroupIngressRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.revokeSecurityGroupIngress(revokeSecurityGroupIngressRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(revokeSecurityGroupIngressRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DeleteVpcPeeringConnectionResult> deleteVpcPeeringConnectionAsync(final DeleteVpcPeeringConnectionRequest deleteVpcPeeringConnectionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteVpcPeeringConnectionResult>(){

            @Override
            public DeleteVpcPeeringConnectionResult call() throws Exception {
                return AmazonEC2AsyncClient.this.deleteVpcPeeringConnection(deleteVpcPeeringConnectionRequest);
            }
        });
    }

    @Override
    public Future<DeleteVpcPeeringConnectionResult> deleteVpcPeeringConnectionAsync(final DeleteVpcPeeringConnectionRequest deleteVpcPeeringConnectionRequest, final AsyncHandler<DeleteVpcPeeringConnectionRequest, DeleteVpcPeeringConnectionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteVpcPeeringConnectionResult>(){

            @Override
            public DeleteVpcPeeringConnectionResult call() throws Exception {
                DeleteVpcPeeringConnectionResult result;
                try {
                    result = AmazonEC2AsyncClient.this.deleteVpcPeeringConnection(deleteVpcPeeringConnectionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteVpcPeeringConnectionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetConsoleOutputResult> getConsoleOutputAsync(final GetConsoleOutputRequest getConsoleOutputRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetConsoleOutputResult>(){

            @Override
            public GetConsoleOutputResult call() throws Exception {
                return AmazonEC2AsyncClient.this.getConsoleOutput(getConsoleOutputRequest);
            }
        });
    }

    @Override
    public Future<GetConsoleOutputResult> getConsoleOutputAsync(final GetConsoleOutputRequest getConsoleOutputRequest, final AsyncHandler<GetConsoleOutputRequest, GetConsoleOutputResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetConsoleOutputResult>(){

            @Override
            public GetConsoleOutputResult call() throws Exception {
                GetConsoleOutputResult result;
                try {
                    result = AmazonEC2AsyncClient.this.getConsoleOutput(getConsoleOutputRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getConsoleOutputRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateInternetGatewayResult> createInternetGatewayAsync(final CreateInternetGatewayRequest createInternetGatewayRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateInternetGatewayResult>(){

            @Override
            public CreateInternetGatewayResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createInternetGateway(createInternetGatewayRequest);
            }
        });
    }

    @Override
    public Future<CreateInternetGatewayResult> createInternetGatewayAsync(final CreateInternetGatewayRequest createInternetGatewayRequest, final AsyncHandler<CreateInternetGatewayRequest, CreateInternetGatewayResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateInternetGatewayResult>(){

            @Override
            public CreateInternetGatewayResult call() throws Exception {
                CreateInternetGatewayResult result;
                try {
                    result = AmazonEC2AsyncClient.this.createInternetGateway(createInternetGatewayRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createInternetGatewayRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteVpnConnectionRouteAsync(final DeleteVpnConnectionRouteRequest deleteVpnConnectionRouteRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteVpnConnectionRoute(deleteVpnConnectionRouteRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteVpnConnectionRouteAsync(final DeleteVpnConnectionRouteRequest deleteVpnConnectionRouteRequest, final AsyncHandler<DeleteVpnConnectionRouteRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.deleteVpnConnectionRoute(deleteVpnConnectionRouteRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteVpnConnectionRouteRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> detachNetworkInterfaceAsync(final DetachNetworkInterfaceRequest detachNetworkInterfaceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.detachNetworkInterface(detachNetworkInterfaceRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> detachNetworkInterfaceAsync(final DetachNetworkInterfaceRequest detachNetworkInterfaceRequest, final AsyncHandler<DetachNetworkInterfaceRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.detachNetworkInterface(detachNetworkInterfaceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(detachNetworkInterfaceRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> modifyImageAttributeAsync(final ModifyImageAttributeRequest modifyImageAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.modifyImageAttribute(modifyImageAttributeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> modifyImageAttributeAsync(final ModifyImageAttributeRequest modifyImageAttributeRequest, final AsyncHandler<ModifyImageAttributeRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.modifyImageAttribute(modifyImageAttributeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(modifyImageAttributeRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<AllocateHostsResult> allocateHostsAsync(final AllocateHostsRequest allocateHostsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AllocateHostsResult>(){

            @Override
            public AllocateHostsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.allocateHosts(allocateHostsRequest);
            }
        });
    }

    @Override
    public Future<AllocateHostsResult> allocateHostsAsync(final AllocateHostsRequest allocateHostsRequest, final AsyncHandler<AllocateHostsRequest, AllocateHostsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AllocateHostsResult>(){

            @Override
            public AllocateHostsResult call() throws Exception {
                AllocateHostsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.allocateHosts(allocateHostsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(allocateHostsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateCustomerGatewayResult> createCustomerGatewayAsync(final CreateCustomerGatewayRequest createCustomerGatewayRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateCustomerGatewayResult>(){

            @Override
            public CreateCustomerGatewayResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createCustomerGateway(createCustomerGatewayRequest);
            }
        });
    }

    @Override
    public Future<CreateCustomerGatewayResult> createCustomerGatewayAsync(final CreateCustomerGatewayRequest createCustomerGatewayRequest, final AsyncHandler<CreateCustomerGatewayRequest, CreateCustomerGatewayResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateCustomerGatewayResult>(){

            @Override
            public CreateCustomerGatewayResult call() throws Exception {
                CreateCustomerGatewayResult result;
                try {
                    result = AmazonEC2AsyncClient.this.createCustomerGateway(createCustomerGatewayRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createCustomerGatewayRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateSpotDatafeedSubscriptionResult> createSpotDatafeedSubscriptionAsync(final CreateSpotDatafeedSubscriptionRequest createSpotDatafeedSubscriptionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateSpotDatafeedSubscriptionResult>(){

            @Override
            public CreateSpotDatafeedSubscriptionResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createSpotDatafeedSubscription(createSpotDatafeedSubscriptionRequest);
            }
        });
    }

    @Override
    public Future<CreateSpotDatafeedSubscriptionResult> createSpotDatafeedSubscriptionAsync(final CreateSpotDatafeedSubscriptionRequest createSpotDatafeedSubscriptionRequest, final AsyncHandler<CreateSpotDatafeedSubscriptionRequest, CreateSpotDatafeedSubscriptionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateSpotDatafeedSubscriptionResult>(){

            @Override
            public CreateSpotDatafeedSubscriptionResult call() throws Exception {
                CreateSpotDatafeedSubscriptionResult result;
                try {
                    result = AmazonEC2AsyncClient.this.createSpotDatafeedSubscription(createSpotDatafeedSubscriptionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createSpotDatafeedSubscriptionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> attachInternetGatewayAsync(final AttachInternetGatewayRequest attachInternetGatewayRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.attachInternetGateway(attachInternetGatewayRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> attachInternetGatewayAsync(final AttachInternetGatewayRequest attachInternetGatewayRequest, final AsyncHandler<AttachInternetGatewayRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.attachInternetGateway(attachInternetGatewayRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(attachInternetGatewayRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteVpnConnectionAsync(final DeleteVpnConnectionRequest deleteVpnConnectionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteVpnConnection(deleteVpnConnectionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteVpnConnectionAsync(final DeleteVpnConnectionRequest deleteVpnConnectionRequest, final AsyncHandler<DeleteVpnConnectionRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.deleteVpnConnection(deleteVpnConnectionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteVpnConnectionRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<CreateVpnConnectionResult> createVpnConnectionAsync(final CreateVpnConnectionRequest createVpnConnectionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateVpnConnectionResult>(){

            @Override
            public CreateVpnConnectionResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createVpnConnection(createVpnConnectionRequest);
            }
        });
    }

    @Override
    public Future<CreateVpnConnectionResult> createVpnConnectionAsync(final CreateVpnConnectionRequest createVpnConnectionRequest, final AsyncHandler<CreateVpnConnectionRequest, CreateVpnConnectionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateVpnConnectionResult>(){

            @Override
            public CreateVpnConnectionResult call() throws Exception {
                CreateVpnConnectionResult result;
                try {
                    result = AmazonEC2AsyncClient.this.createVpnConnection(createVpnConnectionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createVpnConnectionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConversionTasksResult> describeConversionTasksAsync(final DescribeConversionTasksRequest describeConversionTasksRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeConversionTasksResult>(){

            @Override
            public DescribeConversionTasksResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeConversionTasks(describeConversionTasksRequest);
            }
        });
    }

    @Override
    public Future<DescribeConversionTasksResult> describeConversionTasksAsync(final DescribeConversionTasksRequest describeConversionTasksRequest, final AsyncHandler<DescribeConversionTasksRequest, DescribeConversionTasksResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeConversionTasksResult>(){

            @Override
            public DescribeConversionTasksResult call() throws Exception {
                DescribeConversionTasksResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeConversionTasks(describeConversionTasksRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeConversionTasksRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeMovingAddressesResult> describeMovingAddressesAsync(final DescribeMovingAddressesRequest describeMovingAddressesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeMovingAddressesResult>(){

            @Override
            public DescribeMovingAddressesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeMovingAddresses(describeMovingAddressesRequest);
            }
        });
    }

    @Override
    public Future<DescribeMovingAddressesResult> describeMovingAddressesAsync(final DescribeMovingAddressesRequest describeMovingAddressesRequest, final AsyncHandler<DescribeMovingAddressesRequest, DescribeMovingAddressesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeMovingAddressesResult>(){

            @Override
            public DescribeMovingAddressesResult call() throws Exception {
                DescribeMovingAddressesResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeMovingAddresses(describeMovingAddressesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeMovingAddressesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ImportImageResult> importImageAsync(final ImportImageRequest importImageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ImportImageResult>(){

            @Override
            public ImportImageResult call() throws Exception {
                return AmazonEC2AsyncClient.this.importImage(importImageRequest);
            }
        });
    }

    @Override
    public Future<ImportImageResult> importImageAsync(final ImportImageRequest importImageRequest, final AsyncHandler<ImportImageRequest, ImportImageResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ImportImageResult>(){

            @Override
            public ImportImageResult call() throws Exception {
                ImportImageResult result;
                try {
                    result = AmazonEC2AsyncClient.this.importImage(importImageRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(importImageRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DisableVpcClassicLinkResult> disableVpcClassicLinkAsync(final DisableVpcClassicLinkRequest disableVpcClassicLinkRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DisableVpcClassicLinkResult>(){

            @Override
            public DisableVpcClassicLinkResult call() throws Exception {
                return AmazonEC2AsyncClient.this.disableVpcClassicLink(disableVpcClassicLinkRequest);
            }
        });
    }

    @Override
    public Future<DisableVpcClassicLinkResult> disableVpcClassicLinkAsync(final DisableVpcClassicLinkRequest disableVpcClassicLinkRequest, final AsyncHandler<DisableVpcClassicLinkRequest, DisableVpcClassicLinkResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DisableVpcClassicLinkResult>(){

            @Override
            public DisableVpcClassicLinkResult call() throws Exception {
                DisableVpcClassicLinkResult result;
                try {
                    result = AmazonEC2AsyncClient.this.disableVpcClassicLink(disableVpcClassicLinkRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(disableVpcClassicLinkRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeInstanceAttributeResult> describeInstanceAttributeAsync(final DescribeInstanceAttributeRequest describeInstanceAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeInstanceAttributeResult>(){

            @Override
            public DescribeInstanceAttributeResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeInstanceAttribute(describeInstanceAttributeRequest);
            }
        });
    }

    @Override
    public Future<DescribeInstanceAttributeResult> describeInstanceAttributeAsync(final DescribeInstanceAttributeRequest describeInstanceAttributeRequest, final AsyncHandler<DescribeInstanceAttributeRequest, DescribeInstanceAttributeResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeInstanceAttributeResult>(){

            @Override
            public DescribeInstanceAttributeResult call() throws Exception {
                DescribeInstanceAttributeResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeInstanceAttribute(describeInstanceAttributeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeInstanceAttributeRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFlowLogsResult> describeFlowLogsAsync(final DescribeFlowLogsRequest describeFlowLogsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeFlowLogsResult>(){

            @Override
            public DescribeFlowLogsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeFlowLogs(describeFlowLogsRequest);
            }
        });
    }

    @Override
    public Future<DescribeFlowLogsResult> describeFlowLogsAsync(final DescribeFlowLogsRequest describeFlowLogsRequest, final AsyncHandler<DescribeFlowLogsRequest, DescribeFlowLogsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeFlowLogsResult>(){

            @Override
            public DescribeFlowLogsResult call() throws Exception {
                DescribeFlowLogsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeFlowLogs(describeFlowLogsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeFlowLogsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeVpcPeeringConnectionsResult> describeVpcPeeringConnectionsAsync(final DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVpcPeeringConnectionsResult>(){

            @Override
            public DescribeVpcPeeringConnectionsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeVpcPeeringConnections(describeVpcPeeringConnectionsRequest);
            }
        });
    }

    @Override
    public Future<DescribeVpcPeeringConnectionsResult> describeVpcPeeringConnectionsAsync(final DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest, final AsyncHandler<DescribeVpcPeeringConnectionsRequest, DescribeVpcPeeringConnectionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVpcPeeringConnectionsResult>(){

            @Override
            public DescribeVpcPeeringConnectionsResult call() throws Exception {
                DescribeVpcPeeringConnectionsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeVpcPeeringConnections(describeVpcPeeringConnectionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeVpcPeeringConnectionsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<RunInstancesResult> runInstancesAsync(final RunInstancesRequest runInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RunInstancesResult>(){

            @Override
            public RunInstancesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.runInstances(runInstancesRequest);
            }
        });
    }

    @Override
    public Future<RunInstancesResult> runInstancesAsync(final RunInstancesRequest runInstancesRequest, final AsyncHandler<RunInstancesRequest, RunInstancesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RunInstancesResult>(){

            @Override
            public RunInstancesResult call() throws Exception {
                RunInstancesResult result;
                try {
                    result = AmazonEC2AsyncClient.this.runInstances(runInstancesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(runInstancesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSubnetsResult> describeSubnetsAsync(final DescribeSubnetsRequest describeSubnetsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSubnetsResult>(){

            @Override
            public DescribeSubnetsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeSubnets(describeSubnetsRequest);
            }
        });
    }

    @Override
    public Future<DescribeSubnetsResult> describeSubnetsAsync(final DescribeSubnetsRequest describeSubnetsRequest, final AsyncHandler<DescribeSubnetsRequest, DescribeSubnetsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSubnetsResult>(){

            @Override
            public DescribeSubnetsResult call() throws Exception {
                DescribeSubnetsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeSubnets(describeSubnetsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeSubnetsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribePlacementGroupsResult> describePlacementGroupsAsync(final DescribePlacementGroupsRequest describePlacementGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribePlacementGroupsResult>(){

            @Override
            public DescribePlacementGroupsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describePlacementGroups(describePlacementGroupsRequest);
            }
        });
    }

    @Override
    public Future<DescribePlacementGroupsResult> describePlacementGroupsAsync(final DescribePlacementGroupsRequest describePlacementGroupsRequest, final AsyncHandler<DescribePlacementGroupsRequest, DescribePlacementGroupsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribePlacementGroupsResult>(){

            @Override
            public DescribePlacementGroupsResult call() throws Exception {
                DescribePlacementGroupsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describePlacementGroups(describePlacementGroupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describePlacementGroupsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<AssociateRouteTableResult> associateRouteTableAsync(final AssociateRouteTableRequest associateRouteTableRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AssociateRouteTableResult>(){

            @Override
            public AssociateRouteTableResult call() throws Exception {
                return AmazonEC2AsyncClient.this.associateRouteTable(associateRouteTableRequest);
            }
        });
    }

    @Override
    public Future<AssociateRouteTableResult> associateRouteTableAsync(final AssociateRouteTableRequest associateRouteTableRequest, final AsyncHandler<AssociateRouteTableRequest, AssociateRouteTableResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AssociateRouteTableResult>(){

            @Override
            public AssociateRouteTableResult call() throws Exception {
                AssociateRouteTableResult result;
                try {
                    result = AmazonEC2AsyncClient.this.associateRouteTable(associateRouteTableRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(associateRouteTableRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeInstancesResult> describeInstancesAsync(final DescribeInstancesRequest describeInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeInstancesResult>(){

            @Override
            public DescribeInstancesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeInstances(describeInstancesRequest);
            }
        });
    }

    @Override
    public Future<DescribeInstancesResult> describeInstancesAsync(final DescribeInstancesRequest describeInstancesRequest, final AsyncHandler<DescribeInstancesRequest, DescribeInstancesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeInstancesResult>(){

            @Override
            public DescribeInstancesResult call() throws Exception {
                DescribeInstancesResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeInstances(describeInstancesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeInstancesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> modifyVolumeAttributeAsync(final ModifyVolumeAttributeRequest modifyVolumeAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.modifyVolumeAttribute(modifyVolumeAttributeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> modifyVolumeAttributeAsync(final ModifyVolumeAttributeRequest modifyVolumeAttributeRequest, final AsyncHandler<ModifyVolumeAttributeRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.modifyVolumeAttribute(modifyVolumeAttributeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(modifyVolumeAttributeRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteNetworkAclAsync(final DeleteNetworkAclRequest deleteNetworkAclRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteNetworkAcl(deleteNetworkAclRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteNetworkAclAsync(final DeleteNetworkAclRequest deleteNetworkAclRequest, final AsyncHandler<DeleteNetworkAclRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.deleteNetworkAcl(deleteNetworkAclRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteNetworkAclRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeImagesResult> describeImagesAsync(final DescribeImagesRequest describeImagesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeImagesResult>(){

            @Override
            public DescribeImagesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeImages(describeImagesRequest);
            }
        });
    }

    @Override
    public Future<DescribeImagesResult> describeImagesAsync(final DescribeImagesRequest describeImagesRequest, final AsyncHandler<DescribeImagesRequest, DescribeImagesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeImagesResult>(){

            @Override
            public DescribeImagesResult call() throws Exception {
                DescribeImagesResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeImages(describeImagesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeImagesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<StartInstancesResult> startInstancesAsync(final StartInstancesRequest startInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<StartInstancesResult>(){

            @Override
            public StartInstancesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.startInstances(startInstancesRequest);
            }
        });
    }

    @Override
    public Future<StartInstancesResult> startInstancesAsync(final StartInstancesRequest startInstancesRequest, final AsyncHandler<StartInstancesRequest, StartInstancesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<StartInstancesResult>(){

            @Override
            public StartInstancesResult call() throws Exception {
                StartInstancesResult result;
                try {
                    result = AmazonEC2AsyncClient.this.startInstances(startInstancesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(startInstancesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> modifyInstanceAttributeAsync(final ModifyInstanceAttributeRequest modifyInstanceAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.modifyInstanceAttribute(modifyInstanceAttributeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> modifyInstanceAttributeAsync(final ModifyInstanceAttributeRequest modifyInstanceAttributeRequest, final AsyncHandler<ModifyInstanceAttributeRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.modifyInstanceAttribute(modifyInstanceAttributeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(modifyInstanceAttributeRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<CancelReservedInstancesListingResult> cancelReservedInstancesListingAsync(final CancelReservedInstancesListingRequest cancelReservedInstancesListingRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CancelReservedInstancesListingResult>(){

            @Override
            public CancelReservedInstancesListingResult call() throws Exception {
                return AmazonEC2AsyncClient.this.cancelReservedInstancesListing(cancelReservedInstancesListingRequest);
            }
        });
    }

    @Override
    public Future<CancelReservedInstancesListingResult> cancelReservedInstancesListingAsync(final CancelReservedInstancesListingRequest cancelReservedInstancesListingRequest, final AsyncHandler<CancelReservedInstancesListingRequest, CancelReservedInstancesListingResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CancelReservedInstancesListingResult>(){

            @Override
            public CancelReservedInstancesListingResult call() throws Exception {
                CancelReservedInstancesListingResult result;
                try {
                    result = AmazonEC2AsyncClient.this.cancelReservedInstancesListing(cancelReservedInstancesListingRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(cancelReservedInstancesListingRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteDhcpOptionsAsync(final DeleteDhcpOptionsRequest deleteDhcpOptionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteDhcpOptions(deleteDhcpOptionsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteDhcpOptionsAsync(final DeleteDhcpOptionsRequest deleteDhcpOptionsRequest, final AsyncHandler<DeleteDhcpOptionsRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.deleteDhcpOptions(deleteDhcpOptionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteDhcpOptionsRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> authorizeSecurityGroupIngressAsync(final AuthorizeSecurityGroupIngressRequest authorizeSecurityGroupIngressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.authorizeSecurityGroupIngress(authorizeSecurityGroupIngressRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> authorizeSecurityGroupIngressAsync(final AuthorizeSecurityGroupIngressRequest authorizeSecurityGroupIngressRequest, final AsyncHandler<AuthorizeSecurityGroupIngressRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.authorizeSecurityGroupIngress(authorizeSecurityGroupIngressRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(authorizeSecurityGroupIngressRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeSpotInstanceRequestsResult> describeSpotInstanceRequestsAsync(final DescribeSpotInstanceRequestsRequest describeSpotInstanceRequestsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSpotInstanceRequestsResult>(){

            @Override
            public DescribeSpotInstanceRequestsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeSpotInstanceRequests(describeSpotInstanceRequestsRequest);
            }
        });
    }

    @Override
    public Future<DescribeSpotInstanceRequestsResult> describeSpotInstanceRequestsAsync(final DescribeSpotInstanceRequestsRequest describeSpotInstanceRequestsRequest, final AsyncHandler<DescribeSpotInstanceRequestsRequest, DescribeSpotInstanceRequestsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSpotInstanceRequestsResult>(){

            @Override
            public DescribeSpotInstanceRequestsResult call() throws Exception {
                DescribeSpotInstanceRequestsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeSpotInstanceRequests(describeSpotInstanceRequestsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeSpotInstanceRequestsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateVpcResult> createVpcAsync(final CreateVpcRequest createVpcRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateVpcResult>(){

            @Override
            public CreateVpcResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createVpc(createVpcRequest);
            }
        });
    }

    @Override
    public Future<CreateVpcResult> createVpcAsync(final CreateVpcRequest createVpcRequest, final AsyncHandler<CreateVpcRequest, CreateVpcResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateVpcResult>(){

            @Override
            public CreateVpcResult call() throws Exception {
                CreateVpcResult result;
                try {
                    result = AmazonEC2AsyncClient.this.createVpc(createVpcRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createVpcRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCustomerGatewaysResult> describeCustomerGatewaysAsync(final DescribeCustomerGatewaysRequest describeCustomerGatewaysRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCustomerGatewaysResult>(){

            @Override
            public DescribeCustomerGatewaysResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeCustomerGateways(describeCustomerGatewaysRequest);
            }
        });
    }

    @Override
    public Future<DescribeCustomerGatewaysResult> describeCustomerGatewaysAsync(final DescribeCustomerGatewaysRequest describeCustomerGatewaysRequest, final AsyncHandler<DescribeCustomerGatewaysRequest, DescribeCustomerGatewaysResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCustomerGatewaysResult>(){

            @Override
            public DescribeCustomerGatewaysResult call() throws Exception {
                DescribeCustomerGatewaysResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeCustomerGateways(describeCustomerGatewaysRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeCustomerGatewaysRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> cancelExportTaskAsync(final CancelExportTaskRequest cancelExportTaskRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.cancelExportTask(cancelExportTaskRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> cancelExportTaskAsync(final CancelExportTaskRequest cancelExportTaskRequest, final AsyncHandler<CancelExportTaskRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.cancelExportTask(cancelExportTaskRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(cancelExportTaskRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<CreateRouteResult> createRouteAsync(final CreateRouteRequest createRouteRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateRouteResult>(){

            @Override
            public CreateRouteResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createRoute(createRouteRequest);
            }
        });
    }

    @Override
    public Future<CreateRouteResult> createRouteAsync(final CreateRouteRequest createRouteRequest, final AsyncHandler<CreateRouteRequest, CreateRouteResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateRouteResult>(){

            @Override
            public CreateRouteResult call() throws Exception {
                CreateRouteResult result;
                try {
                    result = AmazonEC2AsyncClient.this.createRoute(createRouteRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createRouteRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateVpcEndpointResult> createVpcEndpointAsync(final CreateVpcEndpointRequest createVpcEndpointRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateVpcEndpointResult>(){

            @Override
            public CreateVpcEndpointResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createVpcEndpoint(createVpcEndpointRequest);
            }
        });
    }

    @Override
    public Future<CreateVpcEndpointResult> createVpcEndpointAsync(final CreateVpcEndpointRequest createVpcEndpointRequest, final AsyncHandler<CreateVpcEndpointRequest, CreateVpcEndpointResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateVpcEndpointResult>(){

            @Override
            public CreateVpcEndpointResult call() throws Exception {
                CreateVpcEndpointResult result;
                try {
                    result = AmazonEC2AsyncClient.this.createVpcEndpoint(createVpcEndpointRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createVpcEndpointRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CopyImageResult> copyImageAsync(final CopyImageRequest copyImageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CopyImageResult>(){

            @Override
            public CopyImageResult call() throws Exception {
                return AmazonEC2AsyncClient.this.copyImage(copyImageRequest);
            }
        });
    }

    @Override
    public Future<CopyImageResult> copyImageAsync(final CopyImageRequest copyImageRequest, final AsyncHandler<CopyImageRequest, CopyImageResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CopyImageResult>(){

            @Override
            public CopyImageResult call() throws Exception {
                CopyImageResult result;
                try {
                    result = AmazonEC2AsyncClient.this.copyImage(copyImageRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(copyImageRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeVpcClassicLinkResult> describeVpcClassicLinkAsync(final DescribeVpcClassicLinkRequest describeVpcClassicLinkRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVpcClassicLinkResult>(){

            @Override
            public DescribeVpcClassicLinkResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeVpcClassicLink(describeVpcClassicLinkRequest);
            }
        });
    }

    @Override
    public Future<DescribeVpcClassicLinkResult> describeVpcClassicLinkAsync(final DescribeVpcClassicLinkRequest describeVpcClassicLinkRequest, final AsyncHandler<DescribeVpcClassicLinkRequest, DescribeVpcClassicLinkResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVpcClassicLinkResult>(){

            @Override
            public DescribeVpcClassicLinkResult call() throws Exception {
                DescribeVpcClassicLinkResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeVpcClassicLink(describeVpcClassicLinkRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeVpcClassicLinkRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> modifyNetworkInterfaceAttributeAsync(final ModifyNetworkInterfaceAttributeRequest modifyNetworkInterfaceAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.modifyNetworkInterfaceAttribute(modifyNetworkInterfaceAttributeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> modifyNetworkInterfaceAttributeAsync(final ModifyNetworkInterfaceAttributeRequest modifyNetworkInterfaceAttributeRequest, final AsyncHandler<ModifyNetworkInterfaceAttributeRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.modifyNetworkInterfaceAttribute(modifyNetworkInterfaceAttributeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(modifyNetworkInterfaceAttributeRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteRouteTableAsync(final DeleteRouteTableRequest deleteRouteTableRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteRouteTable(deleteRouteTableRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteRouteTableAsync(final DeleteRouteTableRequest deleteRouteTableRequest, final AsyncHandler<DeleteRouteTableRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.deleteRouteTable(deleteRouteTableRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteRouteTableRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeNetworkInterfaceAttributeResult> describeNetworkInterfaceAttributeAsync(final DescribeNetworkInterfaceAttributeRequest describeNetworkInterfaceAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeNetworkInterfaceAttributeResult>(){

            @Override
            public DescribeNetworkInterfaceAttributeResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeNetworkInterfaceAttribute(describeNetworkInterfaceAttributeRequest);
            }
        });
    }

    @Override
    public Future<DescribeNetworkInterfaceAttributeResult> describeNetworkInterfaceAttributeAsync(final DescribeNetworkInterfaceAttributeRequest describeNetworkInterfaceAttributeRequest, final AsyncHandler<DescribeNetworkInterfaceAttributeRequest, DescribeNetworkInterfaceAttributeResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeNetworkInterfaceAttributeResult>(){

            @Override
            public DescribeNetworkInterfaceAttributeResult call() throws Exception {
                DescribeNetworkInterfaceAttributeResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeNetworkInterfaceAttribute(describeNetworkInterfaceAttributeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeNetworkInterfaceAttributeRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClassicLinkInstancesResult> describeClassicLinkInstancesAsync(final DescribeClassicLinkInstancesRequest describeClassicLinkInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClassicLinkInstancesResult>(){

            @Override
            public DescribeClassicLinkInstancesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeClassicLinkInstances(describeClassicLinkInstancesRequest);
            }
        });
    }

    @Override
    public Future<DescribeClassicLinkInstancesResult> describeClassicLinkInstancesAsync(final DescribeClassicLinkInstancesRequest describeClassicLinkInstancesRequest, final AsyncHandler<DescribeClassicLinkInstancesRequest, DescribeClassicLinkInstancesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClassicLinkInstancesResult>(){

            @Override
            public DescribeClassicLinkInstancesResult call() throws Exception {
                DescribeClassicLinkInstancesResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeClassicLinkInstances(describeClassicLinkInstancesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeClassicLinkInstancesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<RequestSpotInstancesResult> requestSpotInstancesAsync(final RequestSpotInstancesRequest requestSpotInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RequestSpotInstancesResult>(){

            @Override
            public RequestSpotInstancesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.requestSpotInstances(requestSpotInstancesRequest);
            }
        });
    }

    @Override
    public Future<RequestSpotInstancesResult> requestSpotInstancesAsync(final RequestSpotInstancesRequest requestSpotInstancesRequest, final AsyncHandler<RequestSpotInstancesRequest, RequestSpotInstancesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RequestSpotInstancesResult>(){

            @Override
            public RequestSpotInstancesResult call() throws Exception {
                RequestSpotInstancesResult result;
                try {
                    result = AmazonEC2AsyncClient.this.requestSpotInstances(requestSpotInstancesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(requestSpotInstancesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> createTagsAsync(final CreateTagsRequest createTagsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.createTags(createTagsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createTagsAsync(final CreateTagsRequest createTagsRequest, final AsyncHandler<CreateTagsRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.createTags(createTagsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createTagsRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeVolumeAttributeResult> describeVolumeAttributeAsync(final DescribeVolumeAttributeRequest describeVolumeAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVolumeAttributeResult>(){

            @Override
            public DescribeVolumeAttributeResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeVolumeAttribute(describeVolumeAttributeRequest);
            }
        });
    }

    @Override
    public Future<DescribeVolumeAttributeResult> describeVolumeAttributeAsync(final DescribeVolumeAttributeRequest describeVolumeAttributeRequest, final AsyncHandler<DescribeVolumeAttributeRequest, DescribeVolumeAttributeResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVolumeAttributeResult>(){

            @Override
            public DescribeVolumeAttributeResult call() throws Exception {
                DescribeVolumeAttributeResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeVolumeAttribute(describeVolumeAttributeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeVolumeAttributeRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<AttachNetworkInterfaceResult> attachNetworkInterfaceAsync(final AttachNetworkInterfaceRequest attachNetworkInterfaceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AttachNetworkInterfaceResult>(){

            @Override
            public AttachNetworkInterfaceResult call() throws Exception {
                return AmazonEC2AsyncClient.this.attachNetworkInterface(attachNetworkInterfaceRequest);
            }
        });
    }

    @Override
    public Future<AttachNetworkInterfaceResult> attachNetworkInterfaceAsync(final AttachNetworkInterfaceRequest attachNetworkInterfaceRequest, final AsyncHandler<AttachNetworkInterfaceRequest, AttachNetworkInterfaceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AttachNetworkInterfaceResult>(){

            @Override
            public AttachNetworkInterfaceResult call() throws Exception {
                AttachNetworkInterfaceResult result;
                try {
                    result = AmazonEC2AsyncClient.this.attachNetworkInterface(attachNetworkInterfaceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(attachNetworkInterfaceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> modifyIdFormatAsync(final ModifyIdFormatRequest modifyIdFormatRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.modifyIdFormat(modifyIdFormatRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> modifyIdFormatAsync(final ModifyIdFormatRequest modifyIdFormatRequest, final AsyncHandler<ModifyIdFormatRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.modifyIdFormat(modifyIdFormatRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(modifyIdFormatRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> replaceRouteAsync(final ReplaceRouteRequest replaceRouteRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.replaceRoute(replaceRouteRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> replaceRouteAsync(final ReplaceRouteRequest replaceRouteRequest, final AsyncHandler<ReplaceRouteRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.replaceRoute(replaceRouteRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(replaceRouteRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(final DescribeTagsRequest describeTagsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTagsResult>(){

            @Override
            public DescribeTagsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeTags(describeTagsRequest);
            }
        });
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(final DescribeTagsRequest describeTagsRequest, final AsyncHandler<DescribeTagsRequest, DescribeTagsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTagsResult>(){

            @Override
            public DescribeTagsResult call() throws Exception {
                DescribeTagsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeTags(describeTagsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeTagsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CancelBundleTaskResult> cancelBundleTaskAsync(final CancelBundleTaskRequest cancelBundleTaskRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CancelBundleTaskResult>(){

            @Override
            public CancelBundleTaskResult call() throws Exception {
                return AmazonEC2AsyncClient.this.cancelBundleTask(cancelBundleTaskRequest);
            }
        });
    }

    @Override
    public Future<CancelBundleTaskResult> cancelBundleTaskAsync(final CancelBundleTaskRequest cancelBundleTaskRequest, final AsyncHandler<CancelBundleTaskRequest, CancelBundleTaskResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CancelBundleTaskResult>(){

            @Override
            public CancelBundleTaskResult call() throws Exception {
                CancelBundleTaskResult result;
                try {
                    result = AmazonEC2AsyncClient.this.cancelBundleTask(cancelBundleTaskRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(cancelBundleTaskRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> disableVgwRoutePropagationAsync(final DisableVgwRoutePropagationRequest disableVgwRoutePropagationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.disableVgwRoutePropagation(disableVgwRoutePropagationRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> disableVgwRoutePropagationAsync(final DisableVgwRoutePropagationRequest disableVgwRoutePropagationRequest, final AsyncHandler<DisableVgwRoutePropagationRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.disableVgwRoutePropagation(disableVgwRoutePropagationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(disableVgwRoutePropagationRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<ModifySpotFleetRequestResult> modifySpotFleetRequestAsync(final ModifySpotFleetRequestRequest modifySpotFleetRequestRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifySpotFleetRequestResult>(){

            @Override
            public ModifySpotFleetRequestResult call() throws Exception {
                return AmazonEC2AsyncClient.this.modifySpotFleetRequest(modifySpotFleetRequestRequest);
            }
        });
    }

    @Override
    public Future<ModifySpotFleetRequestResult> modifySpotFleetRequestAsync(final ModifySpotFleetRequestRequest modifySpotFleetRequestRequest, final AsyncHandler<ModifySpotFleetRequestRequest, ModifySpotFleetRequestResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifySpotFleetRequestResult>(){

            @Override
            public ModifySpotFleetRequestResult call() throws Exception {
                ModifySpotFleetRequestResult result;
                try {
                    result = AmazonEC2AsyncClient.this.modifySpotFleetRequest(modifySpotFleetRequestRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(modifySpotFleetRequestRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ImportSnapshotResult> importSnapshotAsync(final ImportSnapshotRequest importSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ImportSnapshotResult>(){

            @Override
            public ImportSnapshotResult call() throws Exception {
                return AmazonEC2AsyncClient.this.importSnapshot(importSnapshotRequest);
            }
        });
    }

    @Override
    public Future<ImportSnapshotResult> importSnapshotAsync(final ImportSnapshotRequest importSnapshotRequest, final AsyncHandler<ImportSnapshotRequest, ImportSnapshotResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ImportSnapshotResult>(){

            @Override
            public ImportSnapshotResult call() throws Exception {
                ImportSnapshotResult result;
                try {
                    result = AmazonEC2AsyncClient.this.importSnapshot(importSnapshotRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(importSnapshotRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CancelSpotInstanceRequestsResult> cancelSpotInstanceRequestsAsync(final CancelSpotInstanceRequestsRequest cancelSpotInstanceRequestsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CancelSpotInstanceRequestsResult>(){

            @Override
            public CancelSpotInstanceRequestsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.cancelSpotInstanceRequests(cancelSpotInstanceRequestsRequest);
            }
        });
    }

    @Override
    public Future<CancelSpotInstanceRequestsResult> cancelSpotInstanceRequestsAsync(final CancelSpotInstanceRequestsRequest cancelSpotInstanceRequestsRequest, final AsyncHandler<CancelSpotInstanceRequestsRequest, CancelSpotInstanceRequestsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CancelSpotInstanceRequestsResult>(){

            @Override
            public CancelSpotInstanceRequestsResult call() throws Exception {
                CancelSpotInstanceRequestsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.cancelSpotInstanceRequests(cancelSpotInstanceRequestsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(cancelSpotInstanceRequestsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSpotFleetRequestsResult> describeSpotFleetRequestsAsync(final DescribeSpotFleetRequestsRequest describeSpotFleetRequestsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSpotFleetRequestsResult>(){

            @Override
            public DescribeSpotFleetRequestsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeSpotFleetRequests(describeSpotFleetRequestsRequest);
            }
        });
    }

    @Override
    public Future<DescribeSpotFleetRequestsResult> describeSpotFleetRequestsAsync(final DescribeSpotFleetRequestsRequest describeSpotFleetRequestsRequest, final AsyncHandler<DescribeSpotFleetRequestsRequest, DescribeSpotFleetRequestsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSpotFleetRequestsResult>(){

            @Override
            public DescribeSpotFleetRequestsResult call() throws Exception {
                DescribeSpotFleetRequestsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeSpotFleetRequests(describeSpotFleetRequestsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeSpotFleetRequestsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<PurchaseReservedInstancesOfferingResult> purchaseReservedInstancesOfferingAsync(final PurchaseReservedInstancesOfferingRequest purchaseReservedInstancesOfferingRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PurchaseReservedInstancesOfferingResult>(){

            @Override
            public PurchaseReservedInstancesOfferingResult call() throws Exception {
                return AmazonEC2AsyncClient.this.purchaseReservedInstancesOffering(purchaseReservedInstancesOfferingRequest);
            }
        });
    }

    @Override
    public Future<PurchaseReservedInstancesOfferingResult> purchaseReservedInstancesOfferingAsync(final PurchaseReservedInstancesOfferingRequest purchaseReservedInstancesOfferingRequest, final AsyncHandler<PurchaseReservedInstancesOfferingRequest, PurchaseReservedInstancesOfferingResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PurchaseReservedInstancesOfferingResult>(){

            @Override
            public PurchaseReservedInstancesOfferingResult call() throws Exception {
                PurchaseReservedInstancesOfferingResult result;
                try {
                    result = AmazonEC2AsyncClient.this.purchaseReservedInstancesOffering(purchaseReservedInstancesOfferingRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(purchaseReservedInstancesOfferingRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> modifySnapshotAttributeAsync(final ModifySnapshotAttributeRequest modifySnapshotAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.modifySnapshotAttribute(modifySnapshotAttributeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> modifySnapshotAttributeAsync(final ModifySnapshotAttributeRequest modifySnapshotAttributeRequest, final AsyncHandler<ModifySnapshotAttributeRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.modifySnapshotAttribute(modifySnapshotAttributeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(modifySnapshotAttributeRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<ModifyHostsResult> modifyHostsAsync(final ModifyHostsRequest modifyHostsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifyHostsResult>(){

            @Override
            public ModifyHostsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.modifyHosts(modifyHostsRequest);
            }
        });
    }

    @Override
    public Future<ModifyHostsResult> modifyHostsAsync(final ModifyHostsRequest modifyHostsRequest, final AsyncHandler<ModifyHostsRequest, ModifyHostsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifyHostsResult>(){

            @Override
            public ModifyHostsResult call() throws Exception {
                ModifyHostsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.modifyHosts(modifyHostsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(modifyHostsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReservedInstancesModificationsResult> describeReservedInstancesModificationsAsync(final DescribeReservedInstancesModificationsRequest describeReservedInstancesModificationsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedInstancesModificationsResult>(){

            @Override
            public DescribeReservedInstancesModificationsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeReservedInstancesModifications(describeReservedInstancesModificationsRequest);
            }
        });
    }

    @Override
    public Future<DescribeReservedInstancesModificationsResult> describeReservedInstancesModificationsAsync(final DescribeReservedInstancesModificationsRequest describeReservedInstancesModificationsRequest, final AsyncHandler<DescribeReservedInstancesModificationsRequest, DescribeReservedInstancesModificationsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedInstancesModificationsResult>(){

            @Override
            public DescribeReservedInstancesModificationsResult call() throws Exception {
                DescribeReservedInstancesModificationsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeReservedInstancesModifications(describeReservedInstancesModificationsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeReservedInstancesModificationsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<TerminateInstancesResult> terminateInstancesAsync(final TerminateInstancesRequest terminateInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<TerminateInstancesResult>(){

            @Override
            public TerminateInstancesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.terminateInstances(terminateInstancesRequest);
            }
        });
    }

    @Override
    public Future<TerminateInstancesResult> terminateInstancesAsync(final TerminateInstancesRequest terminateInstancesRequest, final AsyncHandler<TerminateInstancesRequest, TerminateInstancesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<TerminateInstancesResult>(){

            @Override
            public TerminateInstancesResult call() throws Exception {
                TerminateInstancesResult result;
                try {
                    result = AmazonEC2AsyncClient.this.terminateInstances(terminateInstancesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(terminateInstancesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ModifyVpcEndpointResult> modifyVpcEndpointAsync(final ModifyVpcEndpointRequest modifyVpcEndpointRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifyVpcEndpointResult>(){

            @Override
            public ModifyVpcEndpointResult call() throws Exception {
                return AmazonEC2AsyncClient.this.modifyVpcEndpoint(modifyVpcEndpointRequest);
            }
        });
    }

    @Override
    public Future<ModifyVpcEndpointResult> modifyVpcEndpointAsync(final ModifyVpcEndpointRequest modifyVpcEndpointRequest, final AsyncHandler<ModifyVpcEndpointRequest, ModifyVpcEndpointResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifyVpcEndpointResult>(){

            @Override
            public ModifyVpcEndpointResult call() throws Exception {
                ModifyVpcEndpointResult result;
                try {
                    result = AmazonEC2AsyncClient.this.modifyVpcEndpoint(modifyVpcEndpointRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(modifyVpcEndpointRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteSpotDatafeedSubscriptionAsync(final DeleteSpotDatafeedSubscriptionRequest deleteSpotDatafeedSubscriptionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteSpotDatafeedSubscription(deleteSpotDatafeedSubscriptionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteSpotDatafeedSubscriptionAsync(final DeleteSpotDatafeedSubscriptionRequest deleteSpotDatafeedSubscriptionRequest, final AsyncHandler<DeleteSpotDatafeedSubscriptionRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.deleteSpotDatafeedSubscription(deleteSpotDatafeedSubscriptionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteSpotDatafeedSubscriptionRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteInternetGatewayAsync(final DeleteInternetGatewayRequest deleteInternetGatewayRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteInternetGateway(deleteInternetGatewayRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteInternetGatewayAsync(final DeleteInternetGatewayRequest deleteInternetGatewayRequest, final AsyncHandler<DeleteInternetGatewayRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.deleteInternetGateway(deleteInternetGatewayRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteInternetGatewayRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeSnapshotAttributeResult> describeSnapshotAttributeAsync(final DescribeSnapshotAttributeRequest describeSnapshotAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSnapshotAttributeResult>(){

            @Override
            public DescribeSnapshotAttributeResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeSnapshotAttribute(describeSnapshotAttributeRequest);
            }
        });
    }

    @Override
    public Future<DescribeSnapshotAttributeResult> describeSnapshotAttributeAsync(final DescribeSnapshotAttributeRequest describeSnapshotAttributeRequest, final AsyncHandler<DescribeSnapshotAttributeRequest, DescribeSnapshotAttributeResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSnapshotAttributeResult>(){

            @Override
            public DescribeSnapshotAttributeResult call() throws Exception {
                DescribeSnapshotAttributeResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeSnapshotAttribute(describeSnapshotAttributeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeSnapshotAttributeRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ReplaceRouteTableAssociationResult> replaceRouteTableAssociationAsync(final ReplaceRouteTableAssociationRequest replaceRouteTableAssociationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReplaceRouteTableAssociationResult>(){

            @Override
            public ReplaceRouteTableAssociationResult call() throws Exception {
                return AmazonEC2AsyncClient.this.replaceRouteTableAssociation(replaceRouteTableAssociationRequest);
            }
        });
    }

    @Override
    public Future<ReplaceRouteTableAssociationResult> replaceRouteTableAssociationAsync(final ReplaceRouteTableAssociationRequest replaceRouteTableAssociationRequest, final AsyncHandler<ReplaceRouteTableAssociationRequest, ReplaceRouteTableAssociationResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReplaceRouteTableAssociationResult>(){

            @Override
            public ReplaceRouteTableAssociationResult call() throws Exception {
                ReplaceRouteTableAssociationResult result;
                try {
                    result = AmazonEC2AsyncClient.this.replaceRouteTableAssociation(replaceRouteTableAssociationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(replaceRouteTableAssociationRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAddressesResult> describeAddressesAsync(final DescribeAddressesRequest describeAddressesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAddressesResult>(){

            @Override
            public DescribeAddressesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeAddresses(describeAddressesRequest);
            }
        });
    }

    @Override
    public Future<DescribeAddressesResult> describeAddressesAsync(final DescribeAddressesRequest describeAddressesRequest, final AsyncHandler<DescribeAddressesRequest, DescribeAddressesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAddressesResult>(){

            @Override
            public DescribeAddressesResult call() throws Exception {
                DescribeAddressesResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeAddresses(describeAddressesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeAddressesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeImageAttributeResult> describeImageAttributeAsync(final DescribeImageAttributeRequest describeImageAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeImageAttributeResult>(){

            @Override
            public DescribeImageAttributeResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeImageAttribute(describeImageAttributeRequest);
            }
        });
    }

    @Override
    public Future<DescribeImageAttributeResult> describeImageAttributeAsync(final DescribeImageAttributeRequest describeImageAttributeRequest, final AsyncHandler<DescribeImageAttributeRequest, DescribeImageAttributeResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeImageAttributeResult>(){

            @Override
            public DescribeImageAttributeResult call() throws Exception {
                DescribeImageAttributeResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeImageAttribute(describeImageAttributeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeImageAttributeRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeKeyPairsResult> describeKeyPairsAsync(final DescribeKeyPairsRequest describeKeyPairsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeKeyPairsResult>(){

            @Override
            public DescribeKeyPairsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeKeyPairs(describeKeyPairsRequest);
            }
        });
    }

    @Override
    public Future<DescribeKeyPairsResult> describeKeyPairsAsync(final DescribeKeyPairsRequest describeKeyPairsRequest, final AsyncHandler<DescribeKeyPairsRequest, DescribeKeyPairsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeKeyPairsResult>(){

            @Override
            public DescribeKeyPairsResult call() throws Exception {
                DescribeKeyPairsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeKeyPairs(describeKeyPairsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeKeyPairsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ConfirmProductInstanceResult> confirmProductInstanceAsync(final ConfirmProductInstanceRequest confirmProductInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ConfirmProductInstanceResult>(){

            @Override
            public ConfirmProductInstanceResult call() throws Exception {
                return AmazonEC2AsyncClient.this.confirmProductInstance(confirmProductInstanceRequest);
            }
        });
    }

    @Override
    public Future<ConfirmProductInstanceResult> confirmProductInstanceAsync(final ConfirmProductInstanceRequest confirmProductInstanceRequest, final AsyncHandler<ConfirmProductInstanceRequest, ConfirmProductInstanceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ConfirmProductInstanceResult>(){

            @Override
            public ConfirmProductInstanceResult call() throws Exception {
                ConfirmProductInstanceResult result;
                try {
                    result = AmazonEC2AsyncClient.this.confirmProductInstance(confirmProductInstanceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(confirmProductInstanceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> disassociateRouteTableAsync(final DisassociateRouteTableRequest disassociateRouteTableRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.disassociateRouteTable(disassociateRouteTableRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> disassociateRouteTableAsync(final DisassociateRouteTableRequest disassociateRouteTableRequest, final AsyncHandler<DisassociateRouteTableRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.disassociateRouteTable(disassociateRouteTableRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(disassociateRouteTableRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeVpcAttributeResult> describeVpcAttributeAsync(final DescribeVpcAttributeRequest describeVpcAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVpcAttributeResult>(){

            @Override
            public DescribeVpcAttributeResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeVpcAttribute(describeVpcAttributeRequest);
            }
        });
    }

    @Override
    public Future<DescribeVpcAttributeResult> describeVpcAttributeAsync(final DescribeVpcAttributeRequest describeVpcAttributeRequest, final AsyncHandler<DescribeVpcAttributeRequest, DescribeVpcAttributeResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVpcAttributeResult>(){

            @Override
            public DescribeVpcAttributeResult call() throws Exception {
                DescribeVpcAttributeResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeVpcAttribute(describeVpcAttributeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeVpcAttributeRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> revokeSecurityGroupEgressAsync(final RevokeSecurityGroupEgressRequest revokeSecurityGroupEgressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.revokeSecurityGroupEgress(revokeSecurityGroupEgressRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> revokeSecurityGroupEgressAsync(final RevokeSecurityGroupEgressRequest revokeSecurityGroupEgressRequest, final AsyncHandler<RevokeSecurityGroupEgressRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.revokeSecurityGroupEgress(revokeSecurityGroupEgressRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(revokeSecurityGroupEgressRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteNetworkAclEntryAsync(final DeleteNetworkAclEntryRequest deleteNetworkAclEntryRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteNetworkAclEntry(deleteNetworkAclEntryRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteNetworkAclEntryAsync(final DeleteNetworkAclEntryRequest deleteNetworkAclEntryRequest, final AsyncHandler<DeleteNetworkAclEntryRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.deleteNetworkAclEntry(deleteNetworkAclEntryRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteNetworkAclEntryRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<CreateVolumeResult> createVolumeAsync(final CreateVolumeRequest createVolumeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateVolumeResult>(){

            @Override
            public CreateVolumeResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createVolume(createVolumeRequest);
            }
        });
    }

    @Override
    public Future<CreateVolumeResult> createVolumeAsync(final CreateVolumeRequest createVolumeRequest, final AsyncHandler<CreateVolumeRequest, CreateVolumeResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateVolumeResult>(){

            @Override
            public CreateVolumeResult call() throws Exception {
                CreateVolumeResult result;
                try {
                    result = AmazonEC2AsyncClient.this.createVolume(createVolumeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createVolumeRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeInstanceStatusResult> describeInstanceStatusAsync(final DescribeInstanceStatusRequest describeInstanceStatusRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeInstanceStatusResult>(){

            @Override
            public DescribeInstanceStatusResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeInstanceStatus(describeInstanceStatusRequest);
            }
        });
    }

    @Override
    public Future<DescribeInstanceStatusResult> describeInstanceStatusAsync(final DescribeInstanceStatusRequest describeInstanceStatusRequest, final AsyncHandler<DescribeInstanceStatusRequest, DescribeInstanceStatusResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeInstanceStatusResult>(){

            @Override
            public DescribeInstanceStatusResult call() throws Exception {
                DescribeInstanceStatusResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeInstanceStatus(describeInstanceStatusRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeInstanceStatusRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeVpnGatewaysResult> describeVpnGatewaysAsync(final DescribeVpnGatewaysRequest describeVpnGatewaysRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVpnGatewaysResult>(){

            @Override
            public DescribeVpnGatewaysResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeVpnGateways(describeVpnGatewaysRequest);
            }
        });
    }

    @Override
    public Future<DescribeVpnGatewaysResult> describeVpnGatewaysAsync(final DescribeVpnGatewaysRequest describeVpnGatewaysRequest, final AsyncHandler<DescribeVpnGatewaysRequest, DescribeVpnGatewaysResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVpnGatewaysResult>(){

            @Override
            public DescribeVpnGatewaysResult call() throws Exception {
                DescribeVpnGatewaysResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeVpnGateways(describeVpnGatewaysRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeVpnGatewaysRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateSubnetResult> createSubnetAsync(final CreateSubnetRequest createSubnetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateSubnetResult>(){

            @Override
            public CreateSubnetResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createSubnet(createSubnetRequest);
            }
        });
    }

    @Override
    public Future<CreateSubnetResult> createSubnetAsync(final CreateSubnetRequest createSubnetRequest, final AsyncHandler<CreateSubnetRequest, CreateSubnetResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateSubnetResult>(){

            @Override
            public CreateSubnetResult call() throws Exception {
                CreateSubnetResult result;
                try {
                    result = AmazonEC2AsyncClient.this.createSubnet(createSubnetRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createSubnetRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReservedInstancesOfferingsResult> describeReservedInstancesOfferingsAsync(final DescribeReservedInstancesOfferingsRequest describeReservedInstancesOfferingsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedInstancesOfferingsResult>(){

            @Override
            public DescribeReservedInstancesOfferingsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeReservedInstancesOfferings(describeReservedInstancesOfferingsRequest);
            }
        });
    }

    @Override
    public Future<DescribeReservedInstancesOfferingsResult> describeReservedInstancesOfferingsAsync(final DescribeReservedInstancesOfferingsRequest describeReservedInstancesOfferingsRequest, final AsyncHandler<DescribeReservedInstancesOfferingsRequest, DescribeReservedInstancesOfferingsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedInstancesOfferingsResult>(){

            @Override
            public DescribeReservedInstancesOfferingsResult call() throws Exception {
                DescribeReservedInstancesOfferingsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeReservedInstancesOfferings(describeReservedInstancesOfferingsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeReservedInstancesOfferingsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> assignPrivateIpAddressesAsync(final AssignPrivateIpAddressesRequest assignPrivateIpAddressesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.assignPrivateIpAddresses(assignPrivateIpAddressesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> assignPrivateIpAddressesAsync(final AssignPrivateIpAddressesRequest assignPrivateIpAddressesRequest, final AsyncHandler<AssignPrivateIpAddressesRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.assignPrivateIpAddresses(assignPrivateIpAddressesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(assignPrivateIpAddressesRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeSpotFleetRequestHistoryResult> describeSpotFleetRequestHistoryAsync(final DescribeSpotFleetRequestHistoryRequest describeSpotFleetRequestHistoryRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSpotFleetRequestHistoryResult>(){

            @Override
            public DescribeSpotFleetRequestHistoryResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeSpotFleetRequestHistory(describeSpotFleetRequestHistoryRequest);
            }
        });
    }

    @Override
    public Future<DescribeSpotFleetRequestHistoryResult> describeSpotFleetRequestHistoryAsync(final DescribeSpotFleetRequestHistoryRequest describeSpotFleetRequestHistoryRequest, final AsyncHandler<DescribeSpotFleetRequestHistoryRequest, DescribeSpotFleetRequestHistoryResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSpotFleetRequestHistoryResult>(){

            @Override
            public DescribeSpotFleetRequestHistoryResult call() throws Exception {
                DescribeSpotFleetRequestHistoryResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeSpotFleetRequestHistory(describeSpotFleetRequestHistoryRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeSpotFleetRequestHistoryRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteSnapshotAsync(final DeleteSnapshotRequest deleteSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteSnapshot(deleteSnapshotRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteSnapshotAsync(final DeleteSnapshotRequest deleteSnapshotRequest, final AsyncHandler<DeleteSnapshotRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.deleteSnapshot(deleteSnapshotRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteSnapshotRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<ReplaceNetworkAclAssociationResult> replaceNetworkAclAssociationAsync(final ReplaceNetworkAclAssociationRequest replaceNetworkAclAssociationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReplaceNetworkAclAssociationResult>(){

            @Override
            public ReplaceNetworkAclAssociationResult call() throws Exception {
                return AmazonEC2AsyncClient.this.replaceNetworkAclAssociation(replaceNetworkAclAssociationRequest);
            }
        });
    }

    @Override
    public Future<ReplaceNetworkAclAssociationResult> replaceNetworkAclAssociationAsync(final ReplaceNetworkAclAssociationRequest replaceNetworkAclAssociationRequest, final AsyncHandler<ReplaceNetworkAclAssociationRequest, ReplaceNetworkAclAssociationResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReplaceNetworkAclAssociationResult>(){

            @Override
            public ReplaceNetworkAclAssociationResult call() throws Exception {
                ReplaceNetworkAclAssociationResult result;
                try {
                    result = AmazonEC2AsyncClient.this.replaceNetworkAclAssociation(replaceNetworkAclAssociationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(replaceNetworkAclAssociationRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> disassociateAddressAsync(final DisassociateAddressRequest disassociateAddressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.disassociateAddress(disassociateAddressRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> disassociateAddressAsync(final DisassociateAddressRequest disassociateAddressRequest, final AsyncHandler<DisassociateAddressRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.disassociateAddress(disassociateAddressRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(disassociateAddressRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createPlacementGroupAsync(final CreatePlacementGroupRequest createPlacementGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.createPlacementGroup(createPlacementGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createPlacementGroupAsync(final CreatePlacementGroupRequest createPlacementGroupRequest, final AsyncHandler<CreatePlacementGroupRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.createPlacementGroup(createPlacementGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createPlacementGroupRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<BundleInstanceResult> bundleInstanceAsync(final BundleInstanceRequest bundleInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<BundleInstanceResult>(){

            @Override
            public BundleInstanceResult call() throws Exception {
                return AmazonEC2AsyncClient.this.bundleInstance(bundleInstanceRequest);
            }
        });
    }

    @Override
    public Future<BundleInstanceResult> bundleInstanceAsync(final BundleInstanceRequest bundleInstanceRequest, final AsyncHandler<BundleInstanceRequest, BundleInstanceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<BundleInstanceResult>(){

            @Override
            public BundleInstanceResult call() throws Exception {
                BundleInstanceResult result;
                try {
                    result = AmazonEC2AsyncClient.this.bundleInstance(bundleInstanceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(bundleInstanceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deletePlacementGroupAsync(final DeletePlacementGroupRequest deletePlacementGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deletePlacementGroup(deletePlacementGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deletePlacementGroupAsync(final DeletePlacementGroupRequest deletePlacementGroupRequest, final AsyncHandler<DeletePlacementGroupRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.deletePlacementGroup(deletePlacementGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deletePlacementGroupRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> modifySubnetAttributeAsync(final ModifySubnetAttributeRequest modifySubnetAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.modifySubnetAttribute(modifySubnetAttributeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> modifySubnetAttributeAsync(final ModifySubnetAttributeRequest modifySubnetAttributeRequest, final AsyncHandler<ModifySubnetAttributeRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.modifySubnetAttribute(modifySubnetAttributeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(modifySubnetAttributeRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteVpcAsync(final DeleteVpcRequest deleteVpcRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteVpc(deleteVpcRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteVpcAsync(final DeleteVpcRequest deleteVpcRequest, final AsyncHandler<DeleteVpcRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.deleteVpc(deleteVpcRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteVpcRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<CopySnapshotResult> copySnapshotAsync(final CopySnapshotRequest copySnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CopySnapshotResult>(){

            @Override
            public CopySnapshotResult call() throws Exception {
                return AmazonEC2AsyncClient.this.copySnapshot(copySnapshotRequest);
            }
        });
    }

    @Override
    public Future<CopySnapshotResult> copySnapshotAsync(final CopySnapshotRequest copySnapshotRequest, final AsyncHandler<CopySnapshotRequest, CopySnapshotResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CopySnapshotResult>(){

            @Override
            public CopySnapshotResult call() throws Exception {
                CopySnapshotResult result;
                try {
                    result = AmazonEC2AsyncClient.this.copySnapshot(copySnapshotRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(copySnapshotRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeVpcEndpointServicesResult> describeVpcEndpointServicesAsync(final DescribeVpcEndpointServicesRequest describeVpcEndpointServicesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVpcEndpointServicesResult>(){

            @Override
            public DescribeVpcEndpointServicesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeVpcEndpointServices(describeVpcEndpointServicesRequest);
            }
        });
    }

    @Override
    public Future<DescribeVpcEndpointServicesResult> describeVpcEndpointServicesAsync(final DescribeVpcEndpointServicesRequest describeVpcEndpointServicesRequest, final AsyncHandler<DescribeVpcEndpointServicesRequest, DescribeVpcEndpointServicesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVpcEndpointServicesResult>(){

            @Override
            public DescribeVpcEndpointServicesResult call() throws Exception {
                DescribeVpcEndpointServicesResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeVpcEndpointServices(describeVpcEndpointServicesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeVpcEndpointServicesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<AllocateAddressResult> allocateAddressAsync(final AllocateAddressRequest allocateAddressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AllocateAddressResult>(){

            @Override
            public AllocateAddressResult call() throws Exception {
                return AmazonEC2AsyncClient.this.allocateAddress(allocateAddressRequest);
            }
        });
    }

    @Override
    public Future<AllocateAddressResult> allocateAddressAsync(final AllocateAddressRequest allocateAddressRequest, final AsyncHandler<AllocateAddressRequest, AllocateAddressResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AllocateAddressResult>(){

            @Override
            public AllocateAddressResult call() throws Exception {
                AllocateAddressResult result;
                try {
                    result = AmazonEC2AsyncClient.this.allocateAddress(allocateAddressRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(allocateAddressRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> releaseAddressAsync(final ReleaseAddressRequest releaseAddressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.releaseAddress(releaseAddressRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> releaseAddressAsync(final ReleaseAddressRequest releaseAddressRequest, final AsyncHandler<ReleaseAddressRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.releaseAddress(releaseAddressRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(releaseAddressRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> resetInstanceAttributeAsync(final ResetInstanceAttributeRequest resetInstanceAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.resetInstanceAttribute(resetInstanceAttributeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> resetInstanceAttributeAsync(final ResetInstanceAttributeRequest resetInstanceAttributeRequest, final AsyncHandler<ResetInstanceAttributeRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.resetInstanceAttribute(resetInstanceAttributeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(resetInstanceAttributeRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<CreateKeyPairResult> createKeyPairAsync(final CreateKeyPairRequest createKeyPairRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateKeyPairResult>(){

            @Override
            public CreateKeyPairResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createKeyPair(createKeyPairRequest);
            }
        });
    }

    @Override
    public Future<CreateKeyPairResult> createKeyPairAsync(final CreateKeyPairRequest createKeyPairRequest, final AsyncHandler<CreateKeyPairRequest, CreateKeyPairResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateKeyPairResult>(){

            @Override
            public CreateKeyPairResult call() throws Exception {
                CreateKeyPairResult result;
                try {
                    result = AmazonEC2AsyncClient.this.createKeyPair(createKeyPairRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createKeyPairRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeIdFormatResult> describeIdFormatAsync(final DescribeIdFormatRequest describeIdFormatRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeIdFormatResult>(){

            @Override
            public DescribeIdFormatResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeIdFormat(describeIdFormatRequest);
            }
        });
    }

    @Override
    public Future<DescribeIdFormatResult> describeIdFormatAsync(final DescribeIdFormatRequest describeIdFormatRequest, final AsyncHandler<DescribeIdFormatRequest, DescribeIdFormatResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeIdFormatResult>(){

            @Override
            public DescribeIdFormatResult call() throws Exception {
                DescribeIdFormatResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeIdFormat(describeIdFormatRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeIdFormatRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> replaceNetworkAclEntryAsync(final ReplaceNetworkAclEntryRequest replaceNetworkAclEntryRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.replaceNetworkAclEntry(replaceNetworkAclEntryRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> replaceNetworkAclEntryAsync(final ReplaceNetworkAclEntryRequest replaceNetworkAclEntryRequest, final AsyncHandler<ReplaceNetworkAclEntryRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.replaceNetworkAclEntry(replaceNetworkAclEntryRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(replaceNetworkAclEntryRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeSnapshotsResult> describeSnapshotsAsync(final DescribeSnapshotsRequest describeSnapshotsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSnapshotsResult>(){

            @Override
            public DescribeSnapshotsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeSnapshots(describeSnapshotsRequest);
            }
        });
    }

    @Override
    public Future<DescribeSnapshotsResult> describeSnapshotsAsync(final DescribeSnapshotsRequest describeSnapshotsRequest, final AsyncHandler<DescribeSnapshotsRequest, DescribeSnapshotsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSnapshotsResult>(){

            @Override
            public DescribeSnapshotsResult call() throws Exception {
                DescribeSnapshotsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeSnapshots(describeSnapshotsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeSnapshotsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateNetworkAclResult> createNetworkAclAsync(final CreateNetworkAclRequest createNetworkAclRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateNetworkAclResult>(){

            @Override
            public CreateNetworkAclResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createNetworkAcl(createNetworkAclRequest);
            }
        });
    }

    @Override
    public Future<CreateNetworkAclResult> createNetworkAclAsync(final CreateNetworkAclRequest createNetworkAclRequest, final AsyncHandler<CreateNetworkAclRequest, CreateNetworkAclResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateNetworkAclResult>(){

            @Override
            public CreateNetworkAclResult call() throws Exception {
                CreateNetworkAclResult result;
                try {
                    result = AmazonEC2AsyncClient.this.createNetworkAcl(createNetworkAclRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createNetworkAclRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<RegisterImageResult> registerImageAsync(final RegisterImageRequest registerImageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RegisterImageResult>(){

            @Override
            public RegisterImageResult call() throws Exception {
                return AmazonEC2AsyncClient.this.registerImage(registerImageRequest);
            }
        });
    }

    @Override
    public Future<RegisterImageResult> registerImageAsync(final RegisterImageRequest registerImageRequest, final AsyncHandler<RegisterImageRequest, RegisterImageResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RegisterImageResult>(){

            @Override
            public RegisterImageResult call() throws Exception {
                RegisterImageResult result;
                try {
                    result = AmazonEC2AsyncClient.this.registerImage(registerImageRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(registerImageRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> resetNetworkInterfaceAttributeAsync(final ResetNetworkInterfaceAttributeRequest resetNetworkInterfaceAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.resetNetworkInterfaceAttribute(resetNetworkInterfaceAttributeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> resetNetworkInterfaceAttributeAsync(final ResetNetworkInterfaceAttributeRequest resetNetworkInterfaceAttributeRequest, final AsyncHandler<ResetNetworkInterfaceAttributeRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.resetNetworkInterfaceAttribute(resetNetworkInterfaceAttributeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(resetNetworkInterfaceAttributeRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<EnableVpcClassicLinkResult> enableVpcClassicLinkAsync(final EnableVpcClassicLinkRequest enableVpcClassicLinkRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EnableVpcClassicLinkResult>(){

            @Override
            public EnableVpcClassicLinkResult call() throws Exception {
                return AmazonEC2AsyncClient.this.enableVpcClassicLink(enableVpcClassicLinkRequest);
            }
        });
    }

    @Override
    public Future<EnableVpcClassicLinkResult> enableVpcClassicLinkAsync(final EnableVpcClassicLinkRequest enableVpcClassicLinkRequest, final AsyncHandler<EnableVpcClassicLinkRequest, EnableVpcClassicLinkResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EnableVpcClassicLinkResult>(){

            @Override
            public EnableVpcClassicLinkResult call() throws Exception {
                EnableVpcClassicLinkResult result;
                try {
                    result = AmazonEC2AsyncClient.this.enableVpcClassicLink(enableVpcClassicLinkRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(enableVpcClassicLinkRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> createVpnConnectionRouteAsync(final CreateVpnConnectionRouteRequest createVpnConnectionRouteRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.createVpnConnectionRoute(createVpnConnectionRouteRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createVpnConnectionRouteAsync(final CreateVpnConnectionRouteRequest createVpnConnectionRouteRequest, final AsyncHandler<CreateVpnConnectionRouteRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonEC2AsyncClient.this.createVpnConnectionRoute(createVpnConnectionRouteRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createVpnConnectionRouteRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeVpcEndpointsResult> describeVpcEndpointsAsync(final DescribeVpcEndpointsRequest describeVpcEndpointsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVpcEndpointsResult>(){

            @Override
            public DescribeVpcEndpointsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeVpcEndpoints(describeVpcEndpointsRequest);
            }
        });
    }

    @Override
    public Future<DescribeVpcEndpointsResult> describeVpcEndpointsAsync(final DescribeVpcEndpointsRequest describeVpcEndpointsRequest, final AsyncHandler<DescribeVpcEndpointsRequest, DescribeVpcEndpointsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVpcEndpointsResult>(){

            @Override
            public DescribeVpcEndpointsResult call() throws Exception {
                DescribeVpcEndpointsResult result;
                try {
                    result = AmazonEC2AsyncClient.this.describeVpcEndpoints(describeVpcEndpointsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeVpcEndpointsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DetachClassicLinkVpcResult> detachClassicLinkVpcAsync(final DetachClassicLinkVpcRequest detachClassicLinkVpcRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DetachClassicLinkVpcResult>(){

            @Override
            public DetachClassicLinkVpcResult call() throws Exception {
                return AmazonEC2AsyncClient.this.detachClassicLinkVpc(detachClassicLinkVpcRequest);
            }
        });
    }

    @Override
    public Future<DetachClassicLinkVpcResult> detachClassicLinkVpcAsync(final DetachClassicLinkVpcRequest detachClassicLinkVpcRequest, final AsyncHandler<DetachClassicLinkVpcRequest, DetachClassicLinkVpcResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DetachClassicLinkVpcResult>(){

            @Override
            public DetachClassicLinkVpcResult call() throws Exception {
                DetachClassicLinkVpcResult result;
                try {
                    result = AmazonEC2AsyncClient.this.detachClassicLinkVpc(detachClassicLinkVpcRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(detachClassicLinkVpcRequest, result);
                return result;
            }
        });
    }
}

