/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.cloudtrail.model.Trail;
import com.amazonaws.util.json.JSONWriter;

public class TrailJsonMarshaller {
    private static TrailJsonMarshaller instance;

    public void marshall(Trail trail, JSONWriter jsonWriter) {
        if (trail == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (trail.getName() != null) {
                jsonWriter.key("Name").value(trail.getName());
            }
            if (trail.getS3BucketName() != null) {
                jsonWriter.key("S3BucketName").value(trail.getS3BucketName());
            }
            if (trail.getS3KeyPrefix() != null) {
                jsonWriter.key("S3KeyPrefix").value(trail.getS3KeyPrefix());
            }
            if (trail.getSnsTopicName() != null) {
                jsonWriter.key("SnsTopicName").value(trail.getSnsTopicName());
            }
            if (trail.getIncludeGlobalServiceEvents() != null) {
                jsonWriter.key("IncludeGlobalServiceEvents").value(trail.getIncludeGlobalServiceEvents());
            }
            if (trail.getTrailARN() != null) {
                jsonWriter.key("TrailARN").value(trail.getTrailARN());
            }
            if (trail.getLogFileValidationEnabled() != null) {
                jsonWriter.key("LogFileValidationEnabled").value(trail.getLogFileValidationEnabled());
            }
            if (trail.getCloudWatchLogsLogGroupArn() != null) {
                jsonWriter.key("CloudWatchLogsLogGroupArn").value(trail.getCloudWatchLogsLogGroupArn());
            }
            if (trail.getCloudWatchLogsRoleArn() != null) {
                jsonWriter.key("CloudWatchLogsRoleArn").value(trail.getCloudWatchLogsRoleArn());
            }
            if (trail.getKmsKeyId() != null) {
                jsonWriter.key("KmsKeyId").value(trail.getKmsKeyId());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TrailJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TrailJsonMarshaller();
        }
        return instance;
    }
}

