/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.ClientData;
import com.amazonaws.services.ec2.model.ImportSnapshotRequest;
import com.amazonaws.services.ec2.model.SnapshotDiskContainer;
import com.amazonaws.services.ec2.model.UserBucket;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ImportSnapshotRequestMarshaller
implements Marshaller<Request<ImportSnapshotRequest>, ImportSnapshotRequest> {
    @Override
    public Request<ImportSnapshotRequest> marshall(ImportSnapshotRequest importSnapshotRequest) {
        ClientData clientDataClientData;
        SnapshotDiskContainer snapshotDiskContainerDiskContainer;
        if (importSnapshotRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ImportSnapshotRequest> request = new DefaultRequest<ImportSnapshotRequest>(importSnapshotRequest, "AmazonEC2");
        request.addParameter("Action", "ImportSnapshot");
        request.addParameter("Version", "2015-10-01");
        if (importSnapshotRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(importSnapshotRequest.getDescription()));
        }
        if ((snapshotDiskContainerDiskContainer = importSnapshotRequest.getDiskContainer()) != null) {
            UserBucket userBucketUserBucket;
            if (snapshotDiskContainerDiskContainer.getDescription() != null) {
                request.addParameter("DiskContainer.Description", StringUtils.fromString(snapshotDiskContainerDiskContainer.getDescription()));
            }
            if (snapshotDiskContainerDiskContainer.getFormat() != null) {
                request.addParameter("DiskContainer.Format", StringUtils.fromString(snapshotDiskContainerDiskContainer.getFormat()));
            }
            if (snapshotDiskContainerDiskContainer.getUrl() != null) {
                request.addParameter("DiskContainer.Url", StringUtils.fromString(snapshotDiskContainerDiskContainer.getUrl()));
            }
            if ((userBucketUserBucket = snapshotDiskContainerDiskContainer.getUserBucket()) != null) {
                if (userBucketUserBucket.getS3Bucket() != null) {
                    request.addParameter("DiskContainer.UserBucket.S3Bucket", StringUtils.fromString(userBucketUserBucket.getS3Bucket()));
                }
                if (userBucketUserBucket.getS3Key() != null) {
                    request.addParameter("DiskContainer.UserBucket.S3Key", StringUtils.fromString(userBucketUserBucket.getS3Key()));
                }
            }
        }
        if ((clientDataClientData = importSnapshotRequest.getClientData()) != null) {
            if (clientDataClientData.getUploadStart() != null) {
                request.addParameter("ClientData.UploadStart", StringUtils.fromDate(clientDataClientData.getUploadStart()));
            }
            if (clientDataClientData.getUploadEnd() != null) {
                request.addParameter("ClientData.UploadEnd", StringUtils.fromDate(clientDataClientData.getUploadEnd()));
            }
            if (clientDataClientData.getUploadSize() != null) {
                request.addParameter("ClientData.UploadSize", StringUtils.fromDouble(clientDataClientData.getUploadSize()));
            }
            if (clientDataClientData.getComment() != null) {
                request.addParameter("ClientData.Comment", StringUtils.fromString(clientDataClientData.getComment()));
            }
        }
        if (importSnapshotRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(importSnapshotRequest.getClientToken()));
        }
        if (importSnapshotRequest.getRoleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString(importSnapshotRequest.getRoleName()));
        }
        return request;
    }
}

