/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchAsync;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryResult;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricResult;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsResult;
import com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest;
import com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsResult;
import com.amazonaws.services.cloudwatch.model.ListMetricsRequest;
import com.amazonaws.services.cloudwatch.model.ListMetricsResult;
import com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.SetAlarmStateRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonCloudWatchAsyncClient
extends AmazonCloudWatchClient
implements AmazonCloudWatchAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonCloudWatchAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonCloudWatchAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCloudWatchAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonCloudWatchAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, new ClientConfiguration(), executorService);
    }

    public AmazonCloudWatchAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonCloudWatchAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonCloudWatchAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCloudWatchAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonCloudWatchAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<Void> deleteAlarmsAsync(DeleteAlarmsRequest request) {
        return this.deleteAlarmsAsync(request, null);
    }

    @Override
    public Future<Void> deleteAlarmsAsync(final DeleteAlarmsRequest request, final AsyncHandler<DeleteAlarmsRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonCloudWatchAsyncClient.this.deleteAlarms(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAlarmHistoryResult> describeAlarmHistoryAsync(DescribeAlarmHistoryRequest request) {
        return this.describeAlarmHistoryAsync(request, null);
    }

    @Override
    public Future<DescribeAlarmHistoryResult> describeAlarmHistoryAsync(final DescribeAlarmHistoryRequest request, final AsyncHandler<DescribeAlarmHistoryRequest, DescribeAlarmHistoryResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeAlarmHistoryResult>(){

            @Override
            public DescribeAlarmHistoryResult call() throws Exception {
                DescribeAlarmHistoryResult result;
                try {
                    result = AmazonCloudWatchAsyncClient.this.describeAlarmHistory(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAlarmHistoryResult> describeAlarmHistoryAsync() {
        return this.describeAlarmHistoryAsync(new DescribeAlarmHistoryRequest());
    }

    @Override
    public Future<DescribeAlarmHistoryResult> describeAlarmHistoryAsync(AsyncHandler<DescribeAlarmHistoryRequest, DescribeAlarmHistoryResult> asyncHandler) {
        return this.describeAlarmHistoryAsync(new DescribeAlarmHistoryRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeAlarmsResult> describeAlarmsAsync(DescribeAlarmsRequest request) {
        return this.describeAlarmsAsync(request, null);
    }

    @Override
    public Future<DescribeAlarmsResult> describeAlarmsAsync(final DescribeAlarmsRequest request, final AsyncHandler<DescribeAlarmsRequest, DescribeAlarmsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeAlarmsResult>(){

            @Override
            public DescribeAlarmsResult call() throws Exception {
                DescribeAlarmsResult result;
                try {
                    result = AmazonCloudWatchAsyncClient.this.describeAlarms(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAlarmsResult> describeAlarmsAsync() {
        return this.describeAlarmsAsync(new DescribeAlarmsRequest());
    }

    @Override
    public Future<DescribeAlarmsResult> describeAlarmsAsync(AsyncHandler<DescribeAlarmsRequest, DescribeAlarmsResult> asyncHandler) {
        return this.describeAlarmsAsync(new DescribeAlarmsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeAlarmsForMetricResult> describeAlarmsForMetricAsync(DescribeAlarmsForMetricRequest request) {
        return this.describeAlarmsForMetricAsync(request, null);
    }

    @Override
    public Future<DescribeAlarmsForMetricResult> describeAlarmsForMetricAsync(final DescribeAlarmsForMetricRequest request, final AsyncHandler<DescribeAlarmsForMetricRequest, DescribeAlarmsForMetricResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeAlarmsForMetricResult>(){

            @Override
            public DescribeAlarmsForMetricResult call() throws Exception {
                DescribeAlarmsForMetricResult result;
                try {
                    result = AmazonCloudWatchAsyncClient.this.describeAlarmsForMetric(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> disableAlarmActionsAsync(DisableAlarmActionsRequest request) {
        return this.disableAlarmActionsAsync(request, null);
    }

    @Override
    public Future<Void> disableAlarmActionsAsync(final DisableAlarmActionsRequest request, final AsyncHandler<DisableAlarmActionsRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonCloudWatchAsyncClient.this.disableAlarmActions(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> enableAlarmActionsAsync(EnableAlarmActionsRequest request) {
        return this.enableAlarmActionsAsync(request, null);
    }

    @Override
    public Future<Void> enableAlarmActionsAsync(final EnableAlarmActionsRequest request, final AsyncHandler<EnableAlarmActionsRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonCloudWatchAsyncClient.this.enableAlarmActions(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMetricStatisticsResult> getMetricStatisticsAsync(GetMetricStatisticsRequest request) {
        return this.getMetricStatisticsAsync(request, null);
    }

    @Override
    public Future<GetMetricStatisticsResult> getMetricStatisticsAsync(final GetMetricStatisticsRequest request, final AsyncHandler<GetMetricStatisticsRequest, GetMetricStatisticsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetMetricStatisticsResult>(){

            @Override
            public GetMetricStatisticsResult call() throws Exception {
                GetMetricStatisticsResult result;
                try {
                    result = AmazonCloudWatchAsyncClient.this.getMetricStatistics(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMetricsResult> listMetricsAsync(ListMetricsRequest request) {
        return this.listMetricsAsync(request, null);
    }

    @Override
    public Future<ListMetricsResult> listMetricsAsync(final ListMetricsRequest request, final AsyncHandler<ListMetricsRequest, ListMetricsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListMetricsResult>(){

            @Override
            public ListMetricsResult call() throws Exception {
                ListMetricsResult result;
                try {
                    result = AmazonCloudWatchAsyncClient.this.listMetrics(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMetricsResult> listMetricsAsync() {
        return this.listMetricsAsync(new ListMetricsRequest());
    }

    @Override
    public Future<ListMetricsResult> listMetricsAsync(AsyncHandler<ListMetricsRequest, ListMetricsResult> asyncHandler) {
        return this.listMetricsAsync(new ListMetricsRequest(), asyncHandler);
    }

    @Override
    public Future<Void> putMetricAlarmAsync(PutMetricAlarmRequest request) {
        return this.putMetricAlarmAsync(request, null);
    }

    @Override
    public Future<Void> putMetricAlarmAsync(final PutMetricAlarmRequest request, final AsyncHandler<PutMetricAlarmRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonCloudWatchAsyncClient.this.putMetricAlarm(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> putMetricDataAsync(PutMetricDataRequest request) {
        return this.putMetricDataAsync(request, null);
    }

    @Override
    public Future<Void> putMetricDataAsync(final PutMetricDataRequest request, final AsyncHandler<PutMetricDataRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonCloudWatchAsyncClient.this.putMetricData(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> setAlarmStateAsync(SetAlarmStateRequest request) {
        return this.setAlarmStateAsync(request, null);
    }

    @Override
    public Future<Void> setAlarmStateAsync(final SetAlarmStateRequest request, final AsyncHandler<SetAlarmStateRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonCloudWatchAsyncClient.this.setAlarmState(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

