/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.identitymanagement.model.Policy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListPoliciesResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<Policy> policies;
    private Boolean isTruncated;
    private String marker;

    public List<Policy> getPolicies() {
        if (this.policies == null) {
            this.policies = new ListWithAutoConstructFlag();
            this.policies.setAutoConstruct(true);
        }
        return this.policies;
    }

    public void setPolicies(Collection<Policy> policies) {
        if (policies == null) {
            this.policies = null;
            return;
        }
        ListWithAutoConstructFlag policiesCopy = new ListWithAutoConstructFlag(policies.size());
        policiesCopy.addAll(policies);
        this.policies = policiesCopy;
    }

    public ListPoliciesResult withPolicies(Policy ... policies) {
        if (this.getPolicies() == null) {
            this.setPolicies(new ArrayList<Policy>(policies.length));
        }
        for (Policy value : policies) {
            this.getPolicies().add(value);
        }
        return this;
    }

    public ListPoliciesResult withPolicies(Collection<Policy> policies) {
        if (policies == null) {
            this.policies = null;
        } else {
            ListWithAutoConstructFlag policiesCopy = new ListWithAutoConstructFlag(policies.size());
            policiesCopy.addAll(policies);
            this.policies = policiesCopy;
        }
        return this;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public void setIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public ListPoliciesResult withIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
        return this;
    }

    public Boolean getIsTruncated() {
        return this.isTruncated;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public ListPoliciesResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPolicies() != null) {
            sb.append("Policies: " + this.getPolicies() + ",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: " + this.isTruncated() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPolicies() == null ? 0 : this.getPolicies().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPoliciesResult)) {
            return false;
        }
        ListPoliciesResult other = (ListPoliciesResult)obj;
        if (other.getPolicies() == null ^ this.getPolicies() == null) {
            return false;
        }
        if (other.getPolicies() != null && !other.getPolicies().equals(this.getPolicies())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public ListPoliciesResult clone() {
        try {
            return (ListPoliciesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

