/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworkscm.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.opsworkscm.model.EngineAttribute;
import com.amazonaws.services.opsworkscm.model.MaintenanceStatus;
import com.amazonaws.services.opsworkscm.model.ServerStatus;
import com.amazonaws.services.opsworkscm.model.transform.ServerMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Server
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean associatePublicIpAddress;
    private Integer backupRetentionCount;
    private String serverName;
    private Date createdAt;
    private String cloudFormationStackArn;
    private Boolean disableAutomatedBackup;
    private String endpoint;
    private String engine;
    private String engineModel;
    private List<EngineAttribute> engineAttributes;
    private String engineVersion;
    private String instanceProfileArn;
    private String instanceType;
    private String keyPair;
    private String maintenanceStatus;
    private String preferredMaintenanceWindow;
    private String preferredBackupWindow;
    private List<String> securityGroupIds;
    private String serviceRoleArn;
    private String status;
    private String statusReason;
    private List<String> subnetIds;
    private String serverArn;

    public void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
        this.associatePublicIpAddress = associatePublicIpAddress;
    }

    public Boolean getAssociatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public Server withAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
        this.setAssociatePublicIpAddress(associatePublicIpAddress);
        return this;
    }

    public Boolean isAssociatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public void setBackupRetentionCount(Integer backupRetentionCount) {
        this.backupRetentionCount = backupRetentionCount;
    }

    public Integer getBackupRetentionCount() {
        return this.backupRetentionCount;
    }

    public Server withBackupRetentionCount(Integer backupRetentionCount) {
        this.setBackupRetentionCount(backupRetentionCount);
        return this;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public Server withServerName(String serverName) {
        this.setServerName(serverName);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Server withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setCloudFormationStackArn(String cloudFormationStackArn) {
        this.cloudFormationStackArn = cloudFormationStackArn;
    }

    public String getCloudFormationStackArn() {
        return this.cloudFormationStackArn;
    }

    public Server withCloudFormationStackArn(String cloudFormationStackArn) {
        this.setCloudFormationStackArn(cloudFormationStackArn);
        return this;
    }

    public void setDisableAutomatedBackup(Boolean disableAutomatedBackup) {
        this.disableAutomatedBackup = disableAutomatedBackup;
    }

    public Boolean getDisableAutomatedBackup() {
        return this.disableAutomatedBackup;
    }

    public Server withDisableAutomatedBackup(Boolean disableAutomatedBackup) {
        this.setDisableAutomatedBackup(disableAutomatedBackup);
        return this;
    }

    public Boolean isDisableAutomatedBackup() {
        return this.disableAutomatedBackup;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Server withEndpoint(String endpoint) {
        this.setEndpoint(endpoint);
        return this;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getEngine() {
        return this.engine;
    }

    public Server withEngine(String engine) {
        this.setEngine(engine);
        return this;
    }

    public void setEngineModel(String engineModel) {
        this.engineModel = engineModel;
    }

    public String getEngineModel() {
        return this.engineModel;
    }

    public Server withEngineModel(String engineModel) {
        this.setEngineModel(engineModel);
        return this;
    }

    public List<EngineAttribute> getEngineAttributes() {
        return this.engineAttributes;
    }

    public void setEngineAttributes(Collection<EngineAttribute> engineAttributes) {
        if (engineAttributes == null) {
            this.engineAttributes = null;
            return;
        }
        this.engineAttributes = new ArrayList<EngineAttribute>(engineAttributes);
    }

    public Server withEngineAttributes(EngineAttribute ... engineAttributes) {
        if (this.engineAttributes == null) {
            this.setEngineAttributes(new ArrayList<EngineAttribute>(engineAttributes.length));
        }
        for (EngineAttribute ele : engineAttributes) {
            this.engineAttributes.add(ele);
        }
        return this;
    }

    public Server withEngineAttributes(Collection<EngineAttribute> engineAttributes) {
        this.setEngineAttributes(engineAttributes);
        return this;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public Server withEngineVersion(String engineVersion) {
        this.setEngineVersion(engineVersion);
        return this;
    }

    public void setInstanceProfileArn(String instanceProfileArn) {
        this.instanceProfileArn = instanceProfileArn;
    }

    public String getInstanceProfileArn() {
        return this.instanceProfileArn;
    }

    public Server withInstanceProfileArn(String instanceProfileArn) {
        this.setInstanceProfileArn(instanceProfileArn);
        return this;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public Server withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public void setKeyPair(String keyPair) {
        this.keyPair = keyPair;
    }

    public String getKeyPair() {
        return this.keyPair;
    }

    public Server withKeyPair(String keyPair) {
        this.setKeyPair(keyPair);
        return this;
    }

    public void setMaintenanceStatus(String maintenanceStatus) {
        this.maintenanceStatus = maintenanceStatus;
    }

    @JsonProperty(value="maintenanceStatus")
    public String getMaintenanceStatus() {
        return this.maintenanceStatus;
    }

    public Server withMaintenanceStatus(String maintenanceStatus) {
        this.setMaintenanceStatus(maintenanceStatus);
        return this;
    }

    @JsonIgnore
    public void setMaintenanceStatus(MaintenanceStatus maintenanceStatus) {
        this.withMaintenanceStatus(maintenanceStatus);
    }

    public Server withMaintenanceStatus(MaintenanceStatus maintenanceStatus) {
        this.maintenanceStatus = maintenanceStatus.toString();
        return this;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public Server withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.setPreferredMaintenanceWindow(preferredMaintenanceWindow);
        return this;
    }

    public void setPreferredBackupWindow(String preferredBackupWindow) {
        this.preferredBackupWindow = preferredBackupWindow;
    }

    public String getPreferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public Server withPreferredBackupWindow(String preferredBackupWindow) {
        this.setPreferredBackupWindow(preferredBackupWindow);
        return this;
    }

    public List<String> getSecurityGroupIds() {
        return this.securityGroupIds;
    }

    public void setSecurityGroupIds(Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
            return;
        }
        this.securityGroupIds = new ArrayList<String>(securityGroupIds);
    }

    public Server withSecurityGroupIds(String ... securityGroupIds) {
        if (this.securityGroupIds == null) {
            this.setSecurityGroupIds(new ArrayList<String>(securityGroupIds.length));
        }
        for (String ele : securityGroupIds) {
            this.securityGroupIds.add(ele);
        }
        return this;
    }

    public Server withSecurityGroupIds(Collection<String> securityGroupIds) {
        this.setSecurityGroupIds(securityGroupIds);
        return this;
    }

    public void setServiceRoleArn(String serviceRoleArn) {
        this.serviceRoleArn = serviceRoleArn;
    }

    public String getServiceRoleArn() {
        return this.serviceRoleArn;
    }

    public Server withServiceRoleArn(String serviceRoleArn) {
        this.setServiceRoleArn(serviceRoleArn);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    public Server withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    @JsonIgnore
    public void setStatus(ServerStatus status) {
        this.withStatus(status);
    }

    public Server withStatus(ServerStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public Server withStatusReason(String statusReason) {
        this.setStatusReason(statusReason);
        return this;
    }

    public List<String> getSubnetIds() {
        return this.subnetIds;
    }

    public void setSubnetIds(Collection<String> subnetIds) {
        if (subnetIds == null) {
            this.subnetIds = null;
            return;
        }
        this.subnetIds = new ArrayList<String>(subnetIds);
    }

    public Server withSubnetIds(String ... subnetIds) {
        if (this.subnetIds == null) {
            this.setSubnetIds(new ArrayList<String>(subnetIds.length));
        }
        for (String ele : subnetIds) {
            this.subnetIds.add(ele);
        }
        return this;
    }

    public Server withSubnetIds(Collection<String> subnetIds) {
        this.setSubnetIds(subnetIds);
        return this;
    }

    public void setServerArn(String serverArn) {
        this.serverArn = serverArn;
    }

    public String getServerArn() {
        return this.serverArn;
    }

    public Server withServerArn(String serverArn) {
        this.setServerArn(serverArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAssociatePublicIpAddress() != null) {
            sb.append("AssociatePublicIpAddress: ").append(this.getAssociatePublicIpAddress()).append(",");
        }
        if (this.getBackupRetentionCount() != null) {
            sb.append("BackupRetentionCount: ").append(this.getBackupRetentionCount()).append(",");
        }
        if (this.getServerName() != null) {
            sb.append("ServerName: ").append(this.getServerName()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getCloudFormationStackArn() != null) {
            sb.append("CloudFormationStackArn: ").append(this.getCloudFormationStackArn()).append(",");
        }
        if (this.getDisableAutomatedBackup() != null) {
            sb.append("DisableAutomatedBackup: ").append(this.getDisableAutomatedBackup()).append(",");
        }
        if (this.getEndpoint() != null) {
            sb.append("Endpoint: ").append(this.getEndpoint()).append(",");
        }
        if (this.getEngine() != null) {
            sb.append("Engine: ").append(this.getEngine()).append(",");
        }
        if (this.getEngineModel() != null) {
            sb.append("EngineModel: ").append(this.getEngineModel()).append(",");
        }
        if (this.getEngineAttributes() != null) {
            sb.append("EngineAttributes: ").append(this.getEngineAttributes()).append(",");
        }
        if (this.getEngineVersion() != null) {
            sb.append("EngineVersion: ").append(this.getEngineVersion()).append(",");
        }
        if (this.getInstanceProfileArn() != null) {
            sb.append("InstanceProfileArn: ").append(this.getInstanceProfileArn()).append(",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getKeyPair() != null) {
            sb.append("KeyPair: ").append(this.getKeyPair()).append(",");
        }
        if (this.getMaintenanceStatus() != null) {
            sb.append("MaintenanceStatus: ").append(this.getMaintenanceStatus()).append(",");
        }
        if (this.getPreferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.getPreferredMaintenanceWindow()).append(",");
        }
        if (this.getPreferredBackupWindow() != null) {
            sb.append("PreferredBackupWindow: ").append(this.getPreferredBackupWindow()).append(",");
        }
        if (this.getSecurityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.getSecurityGroupIds()).append(",");
        }
        if (this.getServiceRoleArn() != null) {
            sb.append("ServiceRoleArn: ").append(this.getServiceRoleArn()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getStatusReason() != null) {
            sb.append("StatusReason: ").append(this.getStatusReason()).append(",");
        }
        if (this.getSubnetIds() != null) {
            sb.append("SubnetIds: ").append(this.getSubnetIds()).append(",");
        }
        if (this.getServerArn() != null) {
            sb.append("ServerArn: ").append(this.getServerArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Server)) {
            return false;
        }
        Server other = (Server)obj;
        if (other.getAssociatePublicIpAddress() == null ^ this.getAssociatePublicIpAddress() == null) {
            return false;
        }
        if (other.getAssociatePublicIpAddress() != null && !other.getAssociatePublicIpAddress().equals(this.getAssociatePublicIpAddress())) {
            return false;
        }
        if (other.getBackupRetentionCount() == null ^ this.getBackupRetentionCount() == null) {
            return false;
        }
        if (other.getBackupRetentionCount() != null && !other.getBackupRetentionCount().equals(this.getBackupRetentionCount())) {
            return false;
        }
        if (other.getServerName() == null ^ this.getServerName() == null) {
            return false;
        }
        if (other.getServerName() != null && !other.getServerName().equals(this.getServerName())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getCloudFormationStackArn() == null ^ this.getCloudFormationStackArn() == null) {
            return false;
        }
        if (other.getCloudFormationStackArn() != null && !other.getCloudFormationStackArn().equals(this.getCloudFormationStackArn())) {
            return false;
        }
        if (other.getDisableAutomatedBackup() == null ^ this.getDisableAutomatedBackup() == null) {
            return false;
        }
        if (other.getDisableAutomatedBackup() != null && !other.getDisableAutomatedBackup().equals(this.getDisableAutomatedBackup())) {
            return false;
        }
        if (other.getEndpoint() == null ^ this.getEndpoint() == null) {
            return false;
        }
        if (other.getEndpoint() != null && !other.getEndpoint().equals(this.getEndpoint())) {
            return false;
        }
        if (other.getEngine() == null ^ this.getEngine() == null) {
            return false;
        }
        if (other.getEngine() != null && !other.getEngine().equals(this.getEngine())) {
            return false;
        }
        if (other.getEngineModel() == null ^ this.getEngineModel() == null) {
            return false;
        }
        if (other.getEngineModel() != null && !other.getEngineModel().equals(this.getEngineModel())) {
            return false;
        }
        if (other.getEngineAttributes() == null ^ this.getEngineAttributes() == null) {
            return false;
        }
        if (other.getEngineAttributes() != null && !other.getEngineAttributes().equals(this.getEngineAttributes())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.getInstanceProfileArn() == null ^ this.getInstanceProfileArn() == null) {
            return false;
        }
        if (other.getInstanceProfileArn() != null && !other.getInstanceProfileArn().equals(this.getInstanceProfileArn())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getKeyPair() == null ^ this.getKeyPair() == null) {
            return false;
        }
        if (other.getKeyPair() != null && !other.getKeyPair().equals(this.getKeyPair())) {
            return false;
        }
        if (other.getMaintenanceStatus() == null ^ this.getMaintenanceStatus() == null) {
            return false;
        }
        if (other.getMaintenanceStatus() != null && !other.getMaintenanceStatus().equals(this.getMaintenanceStatus())) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() != null && !other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow())) {
            return false;
        }
        if (other.getPreferredBackupWindow() == null ^ this.getPreferredBackupWindow() == null) {
            return false;
        }
        if (other.getPreferredBackupWindow() != null && !other.getPreferredBackupWindow().equals(this.getPreferredBackupWindow())) {
            return false;
        }
        if (other.getSecurityGroupIds() == null ^ this.getSecurityGroupIds() == null) {
            return false;
        }
        if (other.getSecurityGroupIds() != null && !other.getSecurityGroupIds().equals(this.getSecurityGroupIds())) {
            return false;
        }
        if (other.getServiceRoleArn() == null ^ this.getServiceRoleArn() == null) {
            return false;
        }
        if (other.getServiceRoleArn() != null && !other.getServiceRoleArn().equals(this.getServiceRoleArn())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getStatusReason() == null ^ this.getStatusReason() == null) {
            return false;
        }
        if (other.getStatusReason() != null && !other.getStatusReason().equals(this.getStatusReason())) {
            return false;
        }
        if (other.getSubnetIds() == null ^ this.getSubnetIds() == null) {
            return false;
        }
        if (other.getSubnetIds() != null && !other.getSubnetIds().equals(this.getSubnetIds())) {
            return false;
        }
        if (other.getServerArn() == null ^ this.getServerArn() == null) {
            return false;
        }
        return other.getServerArn() == null || other.getServerArn().equals(this.getServerArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAssociatePublicIpAddress() == null ? 0 : this.getAssociatePublicIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getBackupRetentionCount() == null ? 0 : this.getBackupRetentionCount().hashCode());
        hashCode = 31 * hashCode + (this.getServerName() == null ? 0 : this.getServerName().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getCloudFormationStackArn() == null ? 0 : this.getCloudFormationStackArn().hashCode());
        hashCode = 31 * hashCode + (this.getDisableAutomatedBackup() == null ? 0 : this.getDisableAutomatedBackup().hashCode());
        hashCode = 31 * hashCode + (this.getEndpoint() == null ? 0 : this.getEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getEngine() == null ? 0 : this.getEngine().hashCode());
        hashCode = 31 * hashCode + (this.getEngineModel() == null ? 0 : this.getEngineModel().hashCode());
        hashCode = 31 * hashCode + (this.getEngineAttributes() == null ? 0 : this.getEngineAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceProfileArn() == null ? 0 : this.getInstanceProfileArn().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getKeyPair() == null ? 0 : this.getKeyPair().hashCode());
        hashCode = 31 * hashCode + (this.getMaintenanceStatus() == null ? 0 : this.getMaintenanceStatus().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredMaintenanceWindow() == null ? 0 : this.getPreferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredBackupWindow() == null ? 0 : this.getPreferredBackupWindow().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroupIds() == null ? 0 : this.getSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getServiceRoleArn() == null ? 0 : this.getServiceRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStatusReason() == null ? 0 : this.getStatusReason().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetIds() == null ? 0 : this.getSubnetIds().hashCode());
        hashCode = 31 * hashCode + (this.getServerArn() == null ? 0 : this.getServerArn().hashCode());
        return hashCode;
    }

    public Server clone() {
        try {
            return (Server)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

