/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.Recipes;

public class RecipesJsonMarshaller {
    private static RecipesJsonMarshaller instance;

    public void marshall(Recipes recipes, StructuredJsonGenerator jsonGenerator) {
        if (recipes == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList shutdownList;
            SdkInternalList undeployList;
            SdkInternalList deployList;
            SdkInternalList configureList;
            jsonGenerator.writeStartObject();
            SdkInternalList setupList = (SdkInternalList)recipes.getSetup();
            if (!setupList.isEmpty() || !setupList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Setup");
                jsonGenerator.writeStartArray();
                for (Object setupListValue : setupList) {
                    if (setupListValue == null) continue;
                    jsonGenerator.writeValue((String)setupListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(configureList = (SdkInternalList)recipes.getConfigure()).isEmpty() || !configureList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Configure");
                jsonGenerator.writeStartArray();
                for (Object configureListValue : configureList) {
                    if (configureListValue == null) continue;
                    jsonGenerator.writeValue((String)configureListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(deployList = (SdkInternalList)recipes.getDeploy()).isEmpty() || !deployList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Deploy");
                jsonGenerator.writeStartArray();
                for (Object deployListValue : deployList) {
                    if (deployListValue == null) continue;
                    jsonGenerator.writeValue((String)deployListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(undeployList = (SdkInternalList)recipes.getUndeploy()).isEmpty() || !undeployList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Undeploy");
                jsonGenerator.writeStartArray();
                for (String undeployListValue : undeployList) {
                    if (undeployListValue == null) continue;
                    jsonGenerator.writeValue(undeployListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(shutdownList = (SdkInternalList)recipes.getShutdown()).isEmpty() || !shutdownList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Shutdown");
                jsonGenerator.writeStartArray();
                for (String shutdownListValue : shutdownList) {
                    if (shutdownListValue == null) continue;
                    jsonGenerator.writeValue(shutdownListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RecipesJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RecipesJsonMarshaller();
        }
        return instance;
    }
}

