/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.VolumeConfiguration;

public class VolumeConfigurationJsonMarshaller {
    private static VolumeConfigurationJsonMarshaller instance;

    public void marshall(VolumeConfiguration volumeConfiguration, StructuredJsonGenerator jsonGenerator) {
        if (volumeConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (volumeConfiguration.getMountPoint() != null) {
                jsonGenerator.writeFieldName("MountPoint").writeValue(volumeConfiguration.getMountPoint());
            }
            if (volumeConfiguration.getRaidLevel() != null) {
                jsonGenerator.writeFieldName("RaidLevel").writeValue(volumeConfiguration.getRaidLevel().intValue());
            }
            if (volumeConfiguration.getNumberOfDisks() != null) {
                jsonGenerator.writeFieldName("NumberOfDisks").writeValue(volumeConfiguration.getNumberOfDisks().intValue());
            }
            if (volumeConfiguration.getSize() != null) {
                jsonGenerator.writeFieldName("Size").writeValue(volumeConfiguration.getSize().intValue());
            }
            if (volumeConfiguration.getVolumeType() != null) {
                jsonGenerator.writeFieldName("VolumeType").writeValue(volumeConfiguration.getVolumeType());
            }
            if (volumeConfiguration.getIops() != null) {
                jsonGenerator.writeFieldName("Iops").writeValue(volumeConfiguration.getIops().intValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static VolumeConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new VolumeConfigurationJsonMarshaller();
        }
        return instance;
    }
}

