/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.DescribeUserProfilesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeUserProfilesRequestMarshaller
implements Marshaller<Request<DescribeUserProfilesRequest>, DescribeUserProfilesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeUserProfilesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeUserProfilesRequest> marshall(DescribeUserProfilesRequest describeUserProfilesRequest) {
        if (describeUserProfilesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeUserProfilesRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.DescribeUserProfiles");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList iamUserArnsList = (SdkInternalList)describeUserProfilesRequest.getIamUserArns();
            if (!iamUserArnsList.isEmpty() || !iamUserArnsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("IamUserArns");
                jsonGenerator.writeStartArray();
                for (String iamUserArnsListValue : iamUserArnsList) {
                    if (iamUserArnsListValue == null) continue;
                    jsonGenerator.writeValue(iamUserArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

