/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.Layer;
import com.amazonaws.services.opsworks.model.VolumeConfiguration;
import com.amazonaws.services.opsworks.model.transform.LifecycleEventConfigurationJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.RecipesJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.VolumeConfigurationJsonMarshaller;

public class LayerJsonMarshaller {
    private static LayerJsonMarshaller instance;

    public void marshall(Layer layer, StructuredJsonGenerator jsonGenerator) {
        if (layer == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList volumeConfigurationsList;
            SdkInternalList packagesList;
            SdkInternalList defaultSecurityGroupNamesList;
            SdkInternalList customSecurityGroupIdsList;
            SdkInternalMap attributesMap;
            jsonGenerator.writeStartObject();
            if (layer.getStackId() != null) {
                jsonGenerator.writeFieldName("StackId").writeValue(layer.getStackId());
            }
            if (layer.getLayerId() != null) {
                jsonGenerator.writeFieldName("LayerId").writeValue(layer.getLayerId());
            }
            if (layer.getType() != null) {
                jsonGenerator.writeFieldName("Type").writeValue(layer.getType());
            }
            if (layer.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(layer.getName());
            }
            if (layer.getShortname() != null) {
                jsonGenerator.writeFieldName("Shortname").writeValue(layer.getShortname());
            }
            if (!(attributesMap = (SdkInternalMap)layer.getAttributes()).isEmpty() || !attributesMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Attributes");
                jsonGenerator.writeStartObject();
                for (Object attributesMapValue : attributesMap.entrySet()) {
                    if (attributesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)attributesMapValue.getKey());
                    jsonGenerator.writeValue((String)attributesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (layer.getCustomInstanceProfileArn() != null) {
                jsonGenerator.writeFieldName("CustomInstanceProfileArn").writeValue(layer.getCustomInstanceProfileArn());
            }
            if (layer.getCustomJson() != null) {
                jsonGenerator.writeFieldName("CustomJson").writeValue(layer.getCustomJson());
            }
            if (!(customSecurityGroupIdsList = (SdkInternalList)layer.getCustomSecurityGroupIds()).isEmpty() || !customSecurityGroupIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("CustomSecurityGroupIds");
                jsonGenerator.writeStartArray();
                for (Object customSecurityGroupIdsListValue : customSecurityGroupIdsList) {
                    if (customSecurityGroupIdsListValue == null) continue;
                    jsonGenerator.writeValue((String)customSecurityGroupIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(defaultSecurityGroupNamesList = (SdkInternalList)layer.getDefaultSecurityGroupNames()).isEmpty() || !defaultSecurityGroupNamesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("DefaultSecurityGroupNames");
                jsonGenerator.writeStartArray();
                for (Object defaultSecurityGroupNamesListValue : defaultSecurityGroupNamesList) {
                    if (defaultSecurityGroupNamesListValue == null) continue;
                    jsonGenerator.writeValue((String)defaultSecurityGroupNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(packagesList = (SdkInternalList)layer.getPackages()).isEmpty() || !packagesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Packages");
                jsonGenerator.writeStartArray();
                for (String packagesListValue : packagesList) {
                    if (packagesListValue == null) continue;
                    jsonGenerator.writeValue(packagesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(volumeConfigurationsList = (SdkInternalList)layer.getVolumeConfigurations()).isEmpty() || !volumeConfigurationsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("VolumeConfigurations");
                jsonGenerator.writeStartArray();
                for (VolumeConfiguration volumeConfigurationsListValue : volumeConfigurationsList) {
                    if (volumeConfigurationsListValue == null) continue;
                    VolumeConfigurationJsonMarshaller.getInstance().marshall(volumeConfigurationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (layer.getEnableAutoHealing() != null) {
                jsonGenerator.writeFieldName("EnableAutoHealing").writeValue(layer.getEnableAutoHealing().booleanValue());
            }
            if (layer.getAutoAssignElasticIps() != null) {
                jsonGenerator.writeFieldName("AutoAssignElasticIps").writeValue(layer.getAutoAssignElasticIps().booleanValue());
            }
            if (layer.getAutoAssignPublicIps() != null) {
                jsonGenerator.writeFieldName("AutoAssignPublicIps").writeValue(layer.getAutoAssignPublicIps().booleanValue());
            }
            if (layer.getDefaultRecipes() != null) {
                jsonGenerator.writeFieldName("DefaultRecipes");
                RecipesJsonMarshaller.getInstance().marshall(layer.getDefaultRecipes(), jsonGenerator);
            }
            if (layer.getCustomRecipes() != null) {
                jsonGenerator.writeFieldName("CustomRecipes");
                RecipesJsonMarshaller.getInstance().marshall(layer.getCustomRecipes(), jsonGenerator);
            }
            if (layer.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("CreatedAt").writeValue(layer.getCreatedAt());
            }
            if (layer.getInstallUpdatesOnBoot() != null) {
                jsonGenerator.writeFieldName("InstallUpdatesOnBoot").writeValue(layer.getInstallUpdatesOnBoot().booleanValue());
            }
            if (layer.getUseEbsOptimizedInstances() != null) {
                jsonGenerator.writeFieldName("UseEbsOptimizedInstances").writeValue(layer.getUseEbsOptimizedInstances().booleanValue());
            }
            if (layer.getLifecycleEventConfiguration() != null) {
                jsonGenerator.writeFieldName("LifecycleEventConfiguration");
                LifecycleEventConfigurationJsonMarshaller.getInstance().marshall(layer.getLifecycleEventConfiguration(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static LayerJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new LayerJsonMarshaller();
        }
        return instance;
    }
}

